/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr.listener;

import io.debezium.connector.mysql.MySqlDefaultValueConverter;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.connector.mysql.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class CreateTableParserListener
extends MySqlParserBaseListener {
    private final List<ParseTreeListener> listeners;
    private final MySqlAntlrDdlParser parser;
    private TableEditor tableEditor;
    private ColumnDefinitionParserListener columnDefinitionListener;
    private final MySqlDefaultValueConverter defaultValueConverter;

    public CreateTableParserListener(MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
        this.defaultValueConverter = new MySqlDefaultValueConverter(parser.getConverters());
    }

    @Override
    public void enterColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName().fullId());
        if (this.parser.databaseTables().forTable(tableId) == null) {
            this.tableEditor = this.parser.databaseTables().editOrCreateTable(tableId);
            super.enterColumnCreateTable(ctx);
        }
    }

    @Override
    public void exitColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (!this.tableEditor.hasDefaultCharsetName()) {
                this.tableEditor.setDefaultCharsetName(this.parser.currentDatabaseCharset());
            }
            this.listeners.remove(this.columnDefinitionListener);
            this.columnDefinitionListener = null;
            String defaultCharsetName = this.tableEditor.create().defaultCharsetName();
            this.tableEditor.setColumns(this.tableEditor.columns().stream().map(column -> {
                ColumnEditor columnEditor = column.edit();
                if (columnEditor.charsetNameOfTable() == null) {
                    columnEditor.charsetNameOfTable(defaultCharsetName);
                }
                return columnEditor;
            }).map(this::convertDefaultValueToSchemaType).map(ColumnEditor::create).collect(Collectors.toList()));
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.parser.signalCreateTable(this.tableEditor.tableId(), ctx);
        }, this.tableEditor);
        super.exitColumnCreateTable(ctx);
    }

    @Override
    public void exitCopyCreateTable(MySqlParser.CopyCreateTableContext ctx) {
        TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName(0).fullId());
        TableId originalTableId = this.parser.parseQualifiedTableId(ctx.tableName(1).fullId());
        Table original = this.parser.databaseTables().forTable(originalTableId);
        if (original != null) {
            this.parser.databaseTables().overwriteTable(tableId, original.columns(), original.primaryKeyColumnNames(), original.defaultCharsetName());
            this.parser.signalCreateTable(tableId, ctx);
        }
        super.exitCopyCreateTable(ctx);
    }

    @Override
    public void enterColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = this.parser.parseName(ctx.uid());
            ColumnEditor columnEditor = Column.editor().name(columnName);
            if (this.columnDefinitionListener == null) {
                this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners, false);
                this.listeners.add(this.columnDefinitionListener);
            } else {
                this.columnDefinitionListener.setColumnEditor(columnEditor);
            }
        }, this.tableEditor);
        super.enterColumnDeclaration(ctx);
    }

    @Override
    public void exitColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.addColumn(this.columnDefinitionListener.getColumn()), this.tableEditor, this.columnDefinitionListener);
        super.exitColumnDeclaration(ctx);
    }

    @Override
    public void enterPrimaryKeyTableConstraint(MySqlParser.PrimaryKeyTableConstraintContext ctx) {
        this.parser.runIfNotNull(() -> this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor), this.tableEditor);
        super.enterPrimaryKeyTableConstraint(ctx);
    }

    @Override
    public void enterUniqueKeyTableConstraint(MySqlParser.UniqueKeyTableConstraintContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (!this.tableEditor.hasPrimaryKey()) {
                this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor);
            }
        }, this.tableEditor);
        super.enterUniqueKeyTableConstraint(ctx);
    }

    @Override
    public void enterTableOptionCharset(MySqlParser.TableOptionCharsetContext ctx) {
        this.parser.runIfNotNull(() -> {
            String charsetName = this.parser.withoutQuotes(ctx.charsetName());
            this.tableEditor.setDefaultCharsetName(charsetName);
        }, this.tableEditor);
        super.enterTableOptionCharset(ctx);
    }

    private ColumnEditor convertDefaultValueToSchemaType(ColumnEditor columnEditor) {
        return this.defaultValueConverter.setColumnDefaultValue(columnEditor);
    }
}

