/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.data.Enum;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractSourceInfoStructMaker<T extends AbstractSourceInfo>
implements SourceInfoStructMaker<T> {
    public static final Schema SNAPSHOT_RECORD_SCHEMA = Enum.builder("true,last,false").defaultValue("false").optional().build();
    private final String version;
    private final String connector;
    private final String serverName;

    public AbstractSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.version = Objects.requireNonNull(version);
        this.serverName = connectorConfig.getLogicalName();
    }

    protected SchemaBuilder commonSchemaBuilder() {
        return SchemaBuilder.struct().field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA);
    }

    protected Struct commonStruct(T sourceInfo) {
        Struct ret = new Struct(this.schema()).put("version", (Object)this.version).put("connector", (Object)this.connector).put("name", (Object)this.serverName).put("ts_ms", (Object)((AbstractSourceInfo)sourceInfo).timestamp().toEpochMilli()).put("db", (Object)((AbstractSourceInfo)sourceInfo).database());
        SnapshotRecord snapshot = ((AbstractSourceInfo)sourceInfo).snapshot();
        if (snapshot != null) {
            snapshot.toSource(ret);
        }
        return ret;
    }
}

