/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.debezium.internal;

import io.debezium.config.Configuration;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class FlinkDatabaseHistory
extends AbstractDatabaseHistory {
    public static final String DATABASE_HISTORY_INSTANCE_NAME = "database.history.instance.name";
    public static final Map<String, ConcurrentLinkedQueue<HistoryRecord>> ALL_RECORDS = new HashMap<String, ConcurrentLinkedQueue<HistoryRecord>>();
    private ConcurrentLinkedQueue<HistoryRecord> records;
    private String instanceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHistoryRecords(String instanceName, ConcurrentLinkedQueue<HistoryRecord> historyRecords) {
        Map<String, ConcurrentLinkedQueue<HistoryRecord>> map = ALL_RECORDS;
        synchronized (map) {
            ALL_RECORDS.put(instanceName, historyRecords);
        }
    }

    public static void registerEmptyHistoryRecord(String instanceName) {
        FlinkDatabaseHistory.registerHistoryRecords(instanceName, new ConcurrentLinkedQueue<HistoryRecord>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentLinkedQueue<HistoryRecord> getRegisteredHistoryRecord(String instanceName) {
        Map<String, ConcurrentLinkedQueue<HistoryRecord>> map = ALL_RECORDS;
        synchronized (map) {
            if (ALL_RECORDS.containsKey(instanceName)) {
                return ALL_RECORDS.get(instanceName);
            }
        }
        return null;
    }

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        this.instanceName = config.getString(DATABASE_HISTORY_INSTANCE_NAME);
        this.records = FlinkDatabaseHistory.getRegisteredHistoryRecord(this.instanceName);
        if (this.records == null) {
            throw new IllegalStateException(String.format("Couldn't find engine instance %s in the global records.", this.instanceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        if (this.instanceName != null) {
            Map<String, ConcurrentLinkedQueue<HistoryRecord>> map = ALL_RECORDS;
            synchronized (map) {
                ALL_RECORDS.remove(this.instanceName);
            }
        }
    }

    @Override
    protected void storeRecord(HistoryRecord record) throws DatabaseHistoryException {
        this.records.add(record);
    }

    @Override
    protected void recoverRecords(Consumer<HistoryRecord> records) {
        this.records.forEach(records);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean storageExists() {
        return true;
    }

    public String toString() {
        return "Flink Database History";
    }
}

