/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.debezium;

import com.alibaba.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.alibaba.ververica.cdc.debezium.internal.DebeziumChangeConsumer;
import com.alibaba.ververica.cdc.debezium.internal.FlinkDatabaseHistory;
import com.alibaba.ververica.cdc.debezium.internal.FlinkOffsetBackingStore;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.embedded.Connect;
import io.debezium.engine.DebeziumEngine;
import io.debezium.relational.history.HistoryRecord;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class DebeziumSourceFunction<T>
extends RichSourceFunction<T>
implements CheckpointedFunction,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = -5808108641062931623L;
    protected static final Logger LOG = LoggerFactory.getLogger(DebeziumSourceFunction.class);
    public static final String OFFSETS_STATE_NAME = "offset-states";
    public static final String HISTORY_RECORDS_STATE_NAME = "history-records-states";
    private final DebeziumDeserializationSchema<T> deserializer;
    private final Properties properties;
    private ExecutorService executor;
    private DebeziumEngine<?> engine;
    private volatile transient Throwable error;
    private volatile boolean running = true;
    private volatile transient DebeziumChangeConsumer<T> debeziumConsumer;
    private volatile transient String restoredOffsetState;
    private transient ListState<byte[]> offsetState;
    private transient ListState<String> historyRecordsState;
    private transient String engineInstanceName;

    public DebeziumSourceFunction(DebeziumDeserializationSchema<T> deserializer, Properties properties) {
        this.deserializer = deserializer;
        this.properties = properties;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-engine").build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        OperatorStateStore stateStore = context.getOperatorStateStore();
        this.offsetState = stateStore.getUnionListState(new ListStateDescriptor(OFFSETS_STATE_NAME, (TypeInformation)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO));
        this.historyRecordsState = stateStore.getUnionListState(new ListStateDescriptor(HISTORY_RECORDS_STATE_NAME, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO));
        if (context.isRestored()) {
            this.restoreOffsetState();
            this.restoreHistoryRecordsState();
        } else {
            LOG.info("Consumer subtask {} has no restore state.", (Object)this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    private void restoreOffsetState() throws Exception {
        for (byte[] serializedOffset : (Iterable)this.offsetState.get()) {
            if (this.restoredOffsetState == null) {
                this.restoredOffsetState = new String(serializedOffset, StandardCharsets.UTF_8);
                continue;
            }
            throw new RuntimeException("Debezium Source only support single task, however, this is restored from multiple tasks.");
        }
        LOG.info("Consumer subtask {} restored offset state: {}.", (Object)this.getRuntimeContext().getIndexOfThisSubtask(), (Object)this.restoredOffsetState);
    }

    private void restoreHistoryRecordsState() throws Exception {
        DocumentReader reader = DocumentReader.defaultReader();
        ConcurrentLinkedQueue<HistoryRecord> historyRecords = new ConcurrentLinkedQueue<HistoryRecord>();
        int recordsCount = 0;
        boolean firstEntry = true;
        for (String record : (Iterable)this.historyRecordsState.get()) {
            if (firstEntry) {
                this.engineInstanceName = record;
                firstEntry = false;
                continue;
            }
            historyRecords.add(new HistoryRecord(reader.read(record)));
            ++recordsCount;
        }
        if (this.engineInstanceName != null) {
            FlinkDatabaseHistory.registerHistoryRecords(this.engineInstanceName, historyRecords);
        }
        LOG.info("Consumer subtask {} restored history records state: {} with {} records.", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.engineInstanceName, recordsCount});
    }

    public void snapshotState(FunctionSnapshotContext functionSnapshotContext) throws Exception {
        if (!this.running) {
            LOG.debug("snapshotState() called on closed source");
        } else {
            this.snapshotOffsetState();
            this.snapshotHistoryRecordsState();
        }
    }

    private void snapshotOffsetState() throws Exception {
        this.offsetState.clear();
        DebeziumChangeConsumer<T> consumer = this.debeziumConsumer;
        byte[] serializedOffset = null;
        if (consumer == null) {
            if (this.restoredOffsetState != null) {
                serializedOffset = this.restoredOffsetState.getBytes(StandardCharsets.UTF_8);
            }
        } else {
            serializedOffset = consumer.snapshotCurrentState();
        }
        if (serializedOffset != null) {
            this.offsetState.add((Object)serializedOffset);
        }
    }

    private void snapshotHistoryRecordsState() throws Exception {
        this.historyRecordsState.clear();
        if (this.engineInstanceName != null) {
            this.historyRecordsState.add((Object)this.engineInstanceName);
            ConcurrentLinkedQueue<HistoryRecord> historyRecords = FlinkDatabaseHistory.getRegisteredHistoryRecord(this.engineInstanceName);
            if (historyRecords != null) {
                DocumentWriter writer = DocumentWriter.defaultWriter();
                for (HistoryRecord record : historyRecords) {
                    this.historyRecordsState.add((Object)writer.write(record.document()));
                }
            }
        }
    }

    public void run(SourceFunction.SourceContext<T> sourceContext) throws Exception {
        this.properties.setProperty("name", "engine");
        this.properties.setProperty("offset.storage", FlinkOffsetBackingStore.class.getCanonicalName());
        if (this.restoredOffsetState != null) {
            this.properties.setProperty("offset.storage.flink.state.value", this.restoredOffsetState);
        }
        this.properties.setProperty("key.converter.schemas.enable", "false");
        this.properties.setProperty("value.converter.schemas.enable", "false");
        this.properties.setProperty("include.schema.changes", "false");
        this.properties.setProperty("offset.flush.interval.ms", String.valueOf(Long.MAX_VALUE));
        this.properties.setProperty("tombstones.on.delete", "false");
        this.properties.setProperty("database.history", FlinkDatabaseHistory.class.getCanonicalName());
        if (this.engineInstanceName == null) {
            this.engineInstanceName = UUID.randomUUID().toString();
            FlinkDatabaseHistory.registerEmptyHistoryRecord(this.engineInstanceName);
        }
        this.properties.setProperty("database.history.instance.name", this.engineInstanceName);
        String propsString = this.properties.entrySet().stream().map(t -> "\t" + t.getKey().toString() + " = " + t.getValue().toString() + "\n").collect(Collectors.joining());
        LOG.info("Debezium Properties:\n{}", (Object)propsString);
        this.debeziumConsumer = new DebeziumChangeConsumer<T>(sourceContext, this.deserializer, this.restoredOffsetState == null, this::reportError);
        this.engine = DebeziumEngine.create(Connect.class).using(this.properties).notifying(this.debeziumConsumer).using((success, message, error) -> {
            if (!success && error != null) {
                this.reportError(error);
            }
        }).build();
        if (!this.running) {
            return;
        }
        this.executor.execute(this.engine);
        try {
            while (this.running && !this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                if (this.error == null) continue;
                this.running = false;
                this.shutdownEngine();
                ExceptionUtils.rethrow((Throwable)this.error);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void cancel() {
        this.running = false;
        this.shutdownEngine();
    }

    public void close() throws Exception {
        this.cancel();
        if (this.executor != null) {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        super.close();
    }

    private void reportError(Throwable error) {
        LOG.error("Reporting error:", error);
        this.error = error;
    }

    private void shutdownEngine() {
        try {
            if (this.engine != null) {
                this.engine.close();
            }
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        finally {
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializer.getProducedType();
    }
}

