/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.connectors.mysql.table;

import com.alibaba.ververica.cdc.connectors.mysql.table.MySQLTableSource;
import com.alibaba.ververica.cdc.debezium.table.DebeziumOptions;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;

public class MySQLTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "mysql-cdc";
    private static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the MySQL database server.");
    private static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)3306).withDescription("Integer port number of the MySQL database server.");
    private static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the MySQL database to use when connecting to the MySQL database server.");
    private static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the MySQL database server.");
    private static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the MySQL server to monitor.");
    private static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the MySQL database to monitor.");
    private static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    private static final ConfigOption<Integer> SERVER_ID = ConfigOptions.key((String)"server-id").intType().noDefaultValue().withDescription("A numeric ID of this database client, which must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL database cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(HOSTNAME);
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String databaseName = (String)config.get(DATABASE_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        int port = (Integer)config.get(PORT);
        Integer serverId = config.getOptional(SERVER_ID).orElse(null);
        ZoneId serverTimeZone = ZoneId.of((String)config.get(SERVER_TIME_ZONE));
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new MySQLTableSource(physicalSchema, port, hostname, databaseName, tableName, username, password, serverTimeZone, DebeziumOptions.getDebeziumProperties(context.getCatalogTable().getOptions()), serverId);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(HOSTNAME);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(DATABASE_NAME);
        options.add(TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PORT);
        options.add(SERVER_TIME_ZONE);
        options.add(SERVER_ID);
        return options;
    }
}

