/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.connectors.mysql.table;

import com.alibaba.ververica.cdc.connectors.mysql.MySQLSource;
import com.alibaba.ververica.cdc.debezium.DebeziumSourceFunction;
import com.alibaba.ververica.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class MySQLTableSource
implements ScanTableSource {
    private final TableSchema physicalSchema;
    private final int port;
    private final String hostname;
    private final String database;
    private final String username;
    private final String password;
    private final Integer serverId;
    private final String tableName;
    private final ZoneId serverTimeZone;
    private final Properties dbzProperties;

    public MySQLTableSource(TableSchema physicalSchema, int port, String hostname, String database, String tableName, String username, String password, ZoneId serverTimeZone, Properties dbzProperties, @Nullable Integer serverId) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.serverId = serverId;
        this.serverTimeZone = serverTimeZone;
        this.dbzProperties = dbzProperties;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType rowType = (RowType)this.physicalSchema.toRowDataType().getLogicalType();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.physicalSchema.toRowDataType());
        RowDataDebeziumDeserializeSchema deserializer = new RowDataDebeziumDeserializeSchema(rowType, (TypeInformation<RowData>)typeInfo, (rowData, rowKind) -> {}, this.serverTimeZone);
        MySQLSource.Builder<RowData> builder = MySQLSource.builder().hostname(this.hostname).port(this.port).databaseList(this.database).tableList(this.database + "." + this.tableName).username(this.username).password(this.password).serverTimeZone(this.serverTimeZone.toString()).debeziumProperties(this.dbzProperties).deserializer(deserializer);
        Optional.ofNullable(this.serverId).ifPresent(builder::serverId);
        DebeziumSourceFunction<RowData> sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    public DynamicTableSource copy() {
        return new MySQLTableSource(this.physicalSchema, this.port, this.hostname, this.database, this.tableName, this.username, this.password, this.serverTimeZone, this.dbzProperties, this.serverId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MySQLTableSource that = (MySQLTableSource)o;
        return this.port == that.port && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.serverId, that.serverId) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.dbzProperties, that.dbzProperties);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.port, this.hostname, this.database, this.username, this.password, this.serverId, this.tableName, this.serverTimeZone, this.dbzProperties);
    }

    public String asSummaryString() {
        return "MySQL-CDC";
    }
}

