/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.connectors.mysql;

import com.alibaba.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.alibaba.ververica.cdc.debezium.DebeziumSourceFunction;
import io.debezium.connector.mysql.MySqlConnector;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.util.Preconditions;

public class MySQLSource {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private int port = 3306;
        private String hostname;
        private String[] databaseList;
        private String username;
        private String password;
        private Integer serverId;
        private String serverTimeZone;
        private String[] tableList;
        private Properties dbzProperties;
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> databaseList(String ... databaseList) {
            this.databaseList = databaseList;
            return this;
        }

        public Builder<T> tableList(String ... tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> serverTimeZone(String timeZone) {
            this.serverTimeZone = timeZone;
            return this;
        }

        public Builder<T> serverId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder<T> debeziumProperties(Properties properties) {
            this.dbzProperties = properties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", MySqlConnector.class.getCanonicalName());
            props.setProperty("database.server.name", "mysql_binlog_source");
            props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
            props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
            props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
            props.setProperty("database.port", String.valueOf(this.port));
            props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
            if (this.serverId != null) {
                props.setProperty("database.server.id", String.valueOf(this.serverId));
            }
            if (this.databaseList != null) {
                props.setProperty("database.whitelist", String.join((CharSequence)",", this.databaseList));
            }
            if (this.tableList != null) {
                props.setProperty("table.whitelist", String.join((CharSequence)",", this.tableList));
            }
            if (this.serverTimeZone != null) {
                props.setProperty("database.serverTimezone", this.serverTimeZone);
            }
            if (this.dbzProperties != null) {
                this.dbzProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)props::put));
            }
            return new DebeziumSourceFunction<T>(this.deserializer, props);
        }
    }
}

