/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty;

import com.alibaba.otter.canal.protocol.CanalPacket;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class NettyUtils {
    private static int HEADER_LENGTH = 4;
    public static Timer hashedWheelTimer = new HashedWheelTimer();

    public static void write(Channel channel, byte[] body, ChannelFutureListener channelFutureListner) {
        byte[] header = ByteBuffer.allocate(HEADER_LENGTH).putInt(body.length).array();
        if (channelFutureListner == null) {
            Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{header, body}));
        } else {
            Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{header, body})).addListener(channelFutureListner);
        }
    }

    public static void ack(Channel channel, ChannelFutureListener channelFutureListner) {
        NettyUtils.write(channel, CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.ACK).setBody(CanalPacket.Ack.newBuilder().build().toByteString()).build().toByteArray(), channelFutureListner);
    }

    public static void error(int errorCode, String errorMessage, Channel channel, ChannelFutureListener channelFutureListener) {
        if (channelFutureListener == null) {
            channelFutureListener = ChannelFutureListener.CLOSE;
        }
        NettyUtils.write(channel, CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.ACK).setBody(CanalPacket.Ack.newBuilder().setErrorCode(errorCode).setErrorMessage(errorMessage).build().toByteString()).build().toByteArray(), channelFutureListener);
    }
}

