/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.server.CanalServer;
import com.alibaba.otter.canal.server.embeded.CanalServerWithEmbeded;
import com.alibaba.otter.canal.server.netty.handler.ClientAuthenticationHandler;
import com.alibaba.otter.canal.server.netty.handler.FixedHeaderFrameDecoder;
import com.alibaba.otter.canal.server.netty.handler.HandshakeInitializationHandler;
import com.alibaba.otter.canal.server.netty.handler.SessionHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class CanalServerWithNetty
extends AbstractCanalLifeCycle
implements CanalServer {
    private CanalServerWithEmbeded embededServer;
    private String ip;
    private int port;
    private Channel serverChannel = null;
    private ServerBootstrap bootstrap = null;

    public CanalServerWithNetty() {
    }

    public CanalServerWithNetty(CanalServerWithEmbeded embededServer) {
        this.embededServer = embededServer;
    }

    @Override
    public void start() {
        super.start();
        if (!this.embededServer.isStart()) {
            this.embededServer.start();
        }
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipelines = Channels.pipeline();
                pipelines.addLast(FixedHeaderFrameDecoder.class.getName(), (ChannelHandler)new FixedHeaderFrameDecoder());
                pipelines.addLast(HandshakeInitializationHandler.class.getName(), (ChannelHandler)new HandshakeInitializationHandler());
                pipelines.addLast(ClientAuthenticationHandler.class.getName(), (ChannelHandler)new ClientAuthenticationHandler(CanalServerWithNetty.this.embededServer));
                pipelines.addLast(SessionHandler.class.getName(), (ChannelHandler)new SessionHandler(CanalServerWithNetty.this.embededServer));
                return pipelines;
            }
        });
        this.serverChannel = StringUtils.isNotEmpty((String)this.ip) ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.ip, this.port)) : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }

    @Override
    public void stop() {
        super.stop();
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly(1000L);
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
        if (this.embededServer.isStart()) {
            this.embededServer.stop();
        }
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEmbededServer(CanalServerWithEmbeded embededServer) {
        this.embededServer = embededServer;
    }
}

