/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.meta;

import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.meta.MemoryMetaManager;
import com.alibaba.otter.canal.meta.ZooKeeperMetaManager;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.Position;
import com.alibaba.otter.canal.protocol.position.PositionRange;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.util.Assert;

public class MixedMetaManager
extends MemoryMetaManager
implements CanalMetaManager {
    private ExecutorService executor;
    private ZooKeeperMetaManager zooKeeperMetaManager;
    private final Position nullCursor = new Position(){};

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.zooKeeperMetaManager);
        if (!this.zooKeeperMetaManager.isStart()) {
            this.zooKeeperMetaManager.start();
        }
        this.executor = Executors.newFixedThreadPool(1);
        this.destinations = new MapMaker().makeComputingMap((Function)new Function<String, List<ClientIdentity>>(){

            public List<ClientIdentity> apply(String destination) {
                return MixedMetaManager.this.zooKeeperMetaManager.listAllSubscribeInfo(destination);
            }
        });
        this.cursors = new MapMaker().makeComputingMap((Function)new Function<ClientIdentity, Position>(){

            public Position apply(ClientIdentity clientIdentity) {
                Position position = MixedMetaManager.this.zooKeeperMetaManager.getCursor(clientIdentity);
                if (position == null) {
                    return MixedMetaManager.this.nullCursor;
                }
                return position;
            }
        });
        this.batches = new MapMaker().makeComputingMap((Function)new Function<ClientIdentity, MemoryMetaManager.MemoryClientIdentityBatch>(){

            public MemoryMetaManager.MemoryClientIdentityBatch apply(ClientIdentity clientIdentity) {
                MemoryMetaManager.MemoryClientIdentityBatch batches = MemoryMetaManager.MemoryClientIdentityBatch.create(clientIdentity);
                Map<Long, PositionRange> positionRanges = MixedMetaManager.this.zooKeeperMetaManager.listAllBatchs(clientIdentity);
                for (Map.Entry<Long, PositionRange> entry : positionRanges.entrySet()) {
                    batches.addPositionRange(entry.getValue(), entry.getKey());
                }
                return batches;
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        if (this.zooKeeperMetaManager.isStart()) {
            this.zooKeeperMetaManager.stop();
        }
        this.executor.shutdownNow();
        this.destinations.clear();
        this.batches.clear();
    }

    @Override
    public void subscribe(final ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.subscribe(clientIdentity);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.subscribe(clientIdentity);
            }
        });
    }

    @Override
    public void unsubscribe(final ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.unsubscribe(clientIdentity);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.unsubscribe(clientIdentity);
            }
        });
    }

    @Override
    public void updateCursor(final ClientIdentity clientIdentity, final Position position) throws CanalMetaManagerException {
        super.updateCursor(clientIdentity, position);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.updateCursor(clientIdentity, position);
            }
        });
    }

    @Override
    public Position getCursor(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        Position position = super.getCursor(clientIdentity);
        if (position == this.nullCursor) {
            return null;
        }
        return position;
    }

    @Override
    public Long addBatch(final ClientIdentity clientIdentity, final PositionRange positionRange) throws CanalMetaManagerException {
        final Long batchId = super.addBatch(clientIdentity, positionRange);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.addBatch(clientIdentity, positionRange, batchId);
            }
        });
        return batchId;
    }

    @Override
    public void addBatch(final ClientIdentity clientIdentity, final PositionRange positionRange, final Long batchId) throws CanalMetaManagerException {
        super.addBatch(clientIdentity, positionRange, batchId);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.addBatch(clientIdentity, positionRange, batchId);
            }
        });
    }

    @Override
    public PositionRange removeBatch(final ClientIdentity clientIdentity, final Long batchId) throws CanalMetaManagerException {
        PositionRange positionRange = super.removeBatch(clientIdentity, batchId);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.removeBatch(clientIdentity, batchId);
            }
        });
        return positionRange;
    }

    @Override
    public void clearAllBatchs(final ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.clearAllBatchs(clientIdentity);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MixedMetaManager.this.zooKeeperMetaManager.clearAllBatchs(clientIdentity);
            }
        });
    }

    public void setZooKeeperMetaManager(ZooKeeperMetaManager zooKeeperMetaManager) {
        this.zooKeeperMetaManager = zooKeeperMetaManager;
    }
}

