/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.model;

import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private String httpMethod;
    private String path;
    private Map<String, String> headers;
    private Map<String, String> paramValues;
    private String body;

    public HttpRequest(String httpMethod, String path, Map<String, String> headers, Map<String, String> paramValues, String body) {
        this.httpMethod = httpMethod;
        this.path = path;
        this.headers = headers;
        this.paramValues = paramValues;
        this.body = body;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(Map<String, String> paramValues) {
        this.paramValues = paramValues;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public static class Builder {
        private String httpMethod;
        private String path;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> paramValues = new HashMap<String, String>();
        private String body;

        public Builder setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder addHeader(Map<String, String> header) {
            this.headers.putAll(header);
            return this;
        }

        public Builder setParamValue(Map<String, String> params) {
            this.paramValues.putAll(params);
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.httpMethod, this.path, this.headers, this.paramValues, this.body);
        }
    }
}

