/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.util;

import com.alibaba.nacos.shaded.com.google.common.annotations.VisibleForTesting;
import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.alibaba.nacos.shaded.com.google.common.collect.Iterables;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import com.alibaba.nacos.shaded.com.google.common.primitives.UnsignedInts;
import com.alibaba.nacos.shaded.io.grpc.Attributes;
import com.alibaba.nacos.shaded.io.grpc.ConnectivityState;
import com.alibaba.nacos.shaded.io.grpc.EquivalentAddressGroup;
import com.alibaba.nacos.shaded.io.grpc.Internal;
import com.alibaba.nacos.shaded.io.grpc.LoadBalancer;
import com.alibaba.nacos.shaded.io.grpc.LoadBalancerProvider;
import com.alibaba.nacos.shaded.io.grpc.Status;
import com.alibaba.nacos.shaded.io.grpc.internal.PickFirstLoadBalancerProvider;
import com.alibaba.nacos.shaded.io.grpc.util.ForwardingLoadBalancerHelper;
import com.alibaba.nacos.shaded.javax.annotation.Nullable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public abstract class MultiChildLoadBalancer
extends LoadBalancer {
    private static final Logger logger = Logger.getLogger(MultiChildLoadBalancer.class.getName());
    private static final int OFFSET_SEED = new Random().nextInt();
    private List<ChildLbState> childLbStates = new ArrayList<ChildLbState>(0);
    private final LoadBalancer.Helper helper;
    protected boolean resolvingAddresses;
    protected final LoadBalancerProvider pickFirstLbProvider = new PickFirstLoadBalancerProvider();
    protected ConnectivityState currentConnectivityState;

    protected MultiChildLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        logger.log(Level.FINE, "Created");
    }

    protected abstract void updateOverallBalancingState();

    protected Map<Object, LoadBalancer.ResolvedAddresses> createChildAddressesMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        LinkedHashMap<Object, LoadBalancer.ResolvedAddresses> childAddresses = Maps.newLinkedHashMapWithExpectedSize(resolvedAddresses.getAddresses().size());
        for (EquivalentAddressGroup eag : resolvedAddresses.getAddresses()) {
            LoadBalancer.ResolvedAddresses addresses = resolvedAddresses.toBuilder().setAddresses(Collections.singletonList(eag)).setAttributes(Attributes.newBuilder().set(IS_PETIOLE_POLICY, true).build()).setLoadBalancingPolicyConfig(null).build();
            childAddresses.put(new Endpoint(eag), addresses);
        }
        return childAddresses;
    }

    protected ChildLbState createChildLbState(Object key) {
        return new ChildLbState(key, this.pickFirstLbProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        logger.log(Level.FINE, "Received resolution result: {0}", resolvedAddresses);
        try {
            this.resolvingAddresses = true;
            Map<Object, LoadBalancer.ResolvedAddresses> newChildAddresses = this.createChildAddressesMap(resolvedAddresses);
            if (newChildAddresses.isEmpty()) {
                Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. " + resolvedAddresses);
                this.handleNameResolutionError(unavailableStatus);
                Status status = unavailableStatus;
                return status;
            }
            Status status = this.updateChildrenWithResolvedAddresses(newChildAddresses);
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.currentConnectivityState != ConnectivityState.READY) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
        }
    }

    @Override
    public void shutdown() {
        logger.log(Level.FINE, "Shutdown");
        for (ChildLbState state : this.childLbStates) {
            state.shutdown();
        }
        this.childLbStates.clear();
    }

    private Status updateChildrenWithResolvedAddresses(Map<Object, LoadBalancer.ResolvedAddresses> newChildAddresses) {
        LinkedHashMap<Object, ChildLbState> oldStatesMap = Maps.newLinkedHashMapWithExpectedSize(this.childLbStates.size());
        for (ChildLbState state : this.childLbStates) {
            oldStatesMap.put(state.getKey(), state);
        }
        Status status = Status.OK;
        ArrayList<ChildLbState> newChildLbStates = new ArrayList<ChildLbState>(newChildAddresses.size());
        for (Map.Entry<Object, LoadBalancer.ResolvedAddresses> entry : newChildAddresses.entrySet()) {
            ChildLbState childLbState = (ChildLbState)oldStatesMap.remove(entry.getKey());
            if (childLbState == null) {
                childLbState = this.createChildLbState(entry.getKey());
            }
            newChildLbStates.add(childLbState);
        }
        for (ChildLbState childLbState : MultiChildLoadBalancer.offsetIterable(newChildLbStates, OFFSET_SEED)) {
            Status newStatus;
            LoadBalancer.ResolvedAddresses addresses = newChildAddresses.get(childLbState.getKey());
            if (addresses == null || (newStatus = childLbState.lb.acceptResolvedAddresses(addresses)).isOk()) continue;
            status = newStatus;
        }
        this.childLbStates = newChildLbStates;
        this.updateOverallBalancingState();
        for (ChildLbState childLbState : oldStatesMap.values()) {
            childLbState.shutdown();
        }
        return status;
    }

    @VisibleForTesting
    static <T> Iterable<T> offsetIterable(Collection<T> c, int seed) {
        int pos = c.isEmpty() ? 0 : UnsignedInts.remainder(seed, c.size());
        return Iterables.concat(Iterables.skip(c, pos), Iterables.limit(c, pos));
    }

    @Nullable
    protected static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    protected final LoadBalancer.Helper getHelper() {
        return this.helper;
    }

    @VisibleForTesting
    public final Collection<ChildLbState> getChildLbStates() {
        return this.childLbStates;
    }

    protected final List<ChildLbState> getReadyChildren() {
        ArrayList<ChildLbState> activeChildren = new ArrayList<ChildLbState>();
        for (ChildLbState child : this.getChildLbStates()) {
            if (child.getCurrentState() != ConnectivityState.READY) continue;
            activeChildren.add(child);
        }
        return activeChildren;
    }

    protected static class Endpoint {
        final Collection<SocketAddress> addrs;
        final int hashCode;

        public Endpoint(EquivalentAddressGroup eag) {
            Preconditions.checkNotNull(eag, "eag");
            this.addrs = eag.getAddresses().size() < 10 ? eag.getAddresses() : new HashSet<SocketAddress>(eag.getAddresses());
            int sum = 0;
            for (SocketAddress address : eag.getAddresses()) {
                sum += address.hashCode();
            }
            this.hashCode = sum;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Endpoint)) {
                return false;
            }
            Endpoint o = (Endpoint)other;
            if (o.hashCode != this.hashCode || o.addrs.size() != this.addrs.size()) {
                return false;
            }
            return o.addrs.containsAll(this.addrs);
        }

        public String toString() {
            return this.addrs.toString();
        }
    }

    public class ChildLbState {
        private final Object key;
        private final LoadBalancer lb;
        private ConnectivityState currentState;
        private LoadBalancer.SubchannelPicker currentPicker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());

        public ChildLbState(Object key, LoadBalancer.Factory policyFactory) {
            this.key = key;
            this.lb = policyFactory.newLoadBalancer(this.createChildHelper());
            this.currentState = ConnectivityState.CONNECTING;
        }

        protected ChildLbStateHelper createChildHelper() {
            return new ChildLbStateHelper();
        }

        protected void shutdown() {
            this.lb.shutdown();
            this.currentState = ConnectivityState.SHUTDOWN;
            logger.log(Level.FINE, "Child balancer {0} deleted", this.key);
        }

        public String toString() {
            return "Address = " + this.key + ", state = " + (Object)((Object)this.currentState) + ", picker type: " + this.currentPicker.getClass() + ", lb: " + this.lb;
        }

        public final Object getKey() {
            return this.key;
        }

        @VisibleForTesting
        public final LoadBalancer getLb() {
            return this.lb;
        }

        @VisibleForTesting
        public final LoadBalancer.SubchannelPicker getCurrentPicker() {
            return this.currentPicker;
        }

        public final ConnectivityState getCurrentState() {
            return this.currentState;
        }

        protected final void setCurrentState(ConnectivityState newState) {
            this.currentState = newState;
        }

        protected final void setCurrentPicker(LoadBalancer.SubchannelPicker newPicker) {
            this.currentPicker = newPicker;
        }

        protected class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            protected ChildLbStateHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (ChildLbState.this.currentState == ConnectivityState.SHUTDOWN) {
                    return;
                }
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!MultiChildLoadBalancer.this.resolvingAddresses) {
                    MultiChildLoadBalancer.this.updateOverallBalancingState();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return MultiChildLoadBalancer.this.helper;
            }
        }
    }
}

