/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc;

import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchChangeNotifyRequest;
import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchSyncRequest;
import com.alibaba.nacos.api.naming.remote.response.NamingFuzzyWatchChangeNotifyResponse;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.client.naming.cache.NamingFuzzyWatchContext;
import com.alibaba.nacos.client.naming.cache.NamingFuzzyWatchServiceListHolder;
import com.alibaba.nacos.client.naming.event.NamingFuzzyWatchNotifyEvent;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.ServerRequestHandler;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import java.util.Set;

public class NamingFuzzyWatchNotifyRequestHandler
implements ServerRequestHandler {
    NamingFuzzyWatchServiceListHolder namingFuzzyWatchServiceListHolder;

    public NamingFuzzyWatchNotifyRequestHandler(NamingFuzzyWatchServiceListHolder namingFuzzyWatchServiceListHolder) {
        this.namingFuzzyWatchServiceListHolder = namingFuzzyWatchServiceListHolder;
        NotifyCenter.registerToPublisher(NamingFuzzyWatchNotifyEvent.class, 1000);
    }

    @Override
    public Response requestReply(Request request, Connection connection) {
        if (request instanceof NamingFuzzyWatchSyncRequest) {
            NamingFuzzyWatchSyncRequest watchNotifySyncRequest = (NamingFuzzyWatchSyncRequest)request;
            NamingFuzzyWatchContext namingFuzzyWatchContext = this.namingFuzzyWatchServiceListHolder.getFuzzyMatchContextMap().get(watchNotifySyncRequest.getGroupKeyPattern());
            if (namingFuzzyWatchContext != null) {
                Set<NamingFuzzyWatchSyncRequest.Context> serviceKeys = watchNotifySyncRequest.getContexts();
                if (watchNotifySyncRequest.getSyncType().equals("FUZZY_WATCH_INIT_NOTIFY") || watchNotifySyncRequest.getSyncType().equals("FUZZY_WATCH_DIFF_SYNC_NOTIFY")) {
                    for (NamingFuzzyWatchSyncRequest.Context serviceKey : serviceKeys) {
                        if (!namingFuzzyWatchContext.addReceivedServiceKey(serviceKey.getServiceKey())) continue;
                        NotifyCenter.publishEvent(NamingFuzzyWatchNotifyEvent.build(this.namingFuzzyWatchServiceListHolder.getNotifierEventScope(), watchNotifySyncRequest.getGroupKeyPattern(), serviceKey.getServiceKey(), serviceKey.getChangedType(), watchNotifySyncRequest.getSyncType()));
                    }
                } else if (watchNotifySyncRequest.getSyncType().equals("FINISH_FUZZY_WATCH_INIT_NOTIFY")) {
                    namingFuzzyWatchContext.markInitializationComplete();
                }
            }
            return new NamingFuzzyWatchChangeNotifyResponse();
        }
        if (request instanceof NamingFuzzyWatchChangeNotifyRequest) {
            String serviceChangeType;
            NamingFuzzyWatchChangeNotifyRequest notifyChangeRequest = (NamingFuzzyWatchChangeNotifyRequest)request;
            String[] serviceKeyItems = NamingUtils.parseServiceKey(notifyChangeRequest.getServiceKey());
            String namespace = serviceKeyItems[0];
            String groupName = serviceKeyItems[1];
            String serviceName = serviceKeyItems[2];
            Set<String> matchedPattern = FuzzyGroupKeyPattern.filterMatchedPatterns(this.namingFuzzyWatchServiceListHolder.getFuzzyMatchContextMap().keySet(), serviceName, groupName, namespace);
            switch (serviceChangeType = notifyChangeRequest.getChangedType()) {
                case "ADD_SERVICE": 
                case "INSTANCE_CHANGED": {
                    for (String pattern : matchedPattern) {
                        NamingFuzzyWatchContext namingFuzzyWatchContext = this.namingFuzzyWatchServiceListHolder.getFuzzyMatchContextMap().get(pattern);
                        if (namingFuzzyWatchContext == null || !namingFuzzyWatchContext.addReceivedServiceKey(((NamingFuzzyWatchChangeNotifyRequest)request).getServiceKey())) continue;
                        NotifyCenter.publishEvent(NamingFuzzyWatchNotifyEvent.build(this.namingFuzzyWatchServiceListHolder.getNotifierEventScope(), pattern, notifyChangeRequest.getServiceKey(), "ADD_SERVICE", "FUZZY_WATCH_RESOURCE_CHANGED"));
                    }
                    break;
                }
                case "DELETE_SERVICE": {
                    for (String pattern : matchedPattern) {
                        NamingFuzzyWatchContext namingFuzzyWatchContext = this.namingFuzzyWatchServiceListHolder.getFuzzyMatchContextMap().get(pattern);
                        if (namingFuzzyWatchContext == null || !namingFuzzyWatchContext.removeReceivedServiceKey(notifyChangeRequest.getServiceKey())) continue;
                        NotifyCenter.publishEvent(NamingFuzzyWatchNotifyEvent.build(this.namingFuzzyWatchServiceListHolder.getNotifierEventScope(), pattern, notifyChangeRequest.getServiceKey(), "DELETE_SERVICE", "FUZZY_WATCH_RESOURCE_CHANGED"));
                    }
                    break;
                }
            }
            return new NamingFuzzyWatchChangeNotifyResponse();
        }
        return null;
    }
}

