/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.listener.FuzzyWatchChangeEvent;
import com.alibaba.nacos.api.naming.listener.FuzzyWatchEventWatcher;
import com.alibaba.nacos.api.naming.listener.FuzzyWatchLoadWatcher;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.naming.cache.FuzzyWatchEventWatcherWrapper;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class NamingFuzzyWatchContext {
    private static final Logger LOGGER = LogUtils.logger(NamingFuzzyWatchContext.class);
    private String envName;
    private String groupKeyPattern;
    private Set<String> receivedServiceKeys = new ConcurrentHashSet<String>();
    private long syncVersion = 0L;
    private final AtomicBoolean isConsistentWithServer = new AtomicBoolean();
    final AtomicBoolean initializationCompleted = new AtomicBoolean(false);
    private volatile boolean isDiscard = false;
    private final Set<FuzzyWatchEventWatcherWrapper> fuzzyWatchEventWatcherWrappers = new HashSet<FuzzyWatchEventWatcherWrapper>();
    long patternLimitTs = 0L;
    private static final long SUPPRESSED_PERIOD = 60000L;

    boolean patternLimitSuppressed() {
        return this.patternLimitTs > 0L && System.currentTimeMillis() - this.patternLimitTs < 60000L;
    }

    public void clearOverLimitTs() {
        this.patternLimitTs = 0L;
    }

    public void refreshOverLimitTs() {
        this.patternLimitTs = System.currentTimeMillis();
    }

    public void refreshSyncVersion() {
        this.syncVersion = System.currentTimeMillis();
    }

    public NamingFuzzyWatchContext(String envName, String groupKeyPattern) {
        this.envName = envName;
        this.groupKeyPattern = groupKeyPattern;
    }

    private void doNotifyWatcher(String serviceKey, String changedType, String syncType, FuzzyWatchEventWatcherWrapper fuzzyWatchEventWatcherWrapper) {
        if ("ADD_SERVICE".equals(changedType) && fuzzyWatchEventWatcherWrapper.getSyncServiceKeys().contains(serviceKey)) {
            return;
        }
        if ("DELETE_SERVICE".equals(changedType) && !fuzzyWatchEventWatcherWrapper.getSyncServiceKeys().contains(serviceKey)) {
            return;
        }
        String[] serviceKeyItems = NamingUtils.parseServiceKey(serviceKey);
        String namespace = serviceKeyItems[0];
        String groupName = serviceKeyItems[1];
        String serviceName = serviceKeyItems[2];
        String resetSyncType = !this.initializationCompleted.get() ? "FUZZY_WATCH_INIT_NOTIFY" : syncType;
        Runnable job = () -> {
            long start = System.currentTimeMillis();
            FuzzyWatchChangeEvent event = new FuzzyWatchChangeEvent(serviceName, groupName, namespace, changedType, resetSyncType);
            if (fuzzyWatchEventWatcherWrapper != null) {
                fuzzyWatchEventWatcherWrapper.fuzzyWatchEventWatcher.onEvent(event);
            }
            LOGGER.info("[{}] [notify-watcher-ok] serviceName={}, groupName={}, namespace={}, watcher={},changedType={}, job run cost={} millis.", new Object[]{this.envName, serviceName, groupName, namespace, fuzzyWatchEventWatcherWrapper.fuzzyWatchEventWatcher, changedType, System.currentTimeMillis() - start});
            if (changedType.equals("DELETE_SERVICE")) {
                fuzzyWatchEventWatcherWrapper.getSyncServiceKeys().remove(NamingUtils.getServiceKey(namespace, groupName, serviceName));
            } else if (changedType.equals("ADD_SERVICE")) {
                fuzzyWatchEventWatcherWrapper.getSyncServiceKeys().add(NamingUtils.getServiceKey(namespace, groupName, serviceName));
            }
        };
        try {
            if (null != fuzzyWatchEventWatcherWrapper.fuzzyWatchEventWatcher.getExecutor()) {
                LOGGER.info("[{}] [notify-watcher] task submitted to user executor, serviceName={}, groupName={}, namespace={}, listener={}.", new Object[]{this.envName, serviceName, groupName, namespace, fuzzyWatchEventWatcherWrapper});
                fuzzyWatchEventWatcherWrapper.fuzzyWatchEventWatcher.getExecutor().execute(job);
            } else {
                LOGGER.info("[{}] [notify-watcher] task execute in nacos thread, serviceName={}, groupName={}, namespace={}, listener={}.", new Object[]{this.envName, serviceName, groupName, namespace, fuzzyWatchEventWatcherWrapper});
                job.run();
            }
        }
        catch (Throwable t) {
            LOGGER.error("[{}] [notify-watcher-error] serviceName={}, groupName={}, namespace={}, listener={}, throwable={}.", new Object[]{this.envName, serviceName, groupName, namespace, fuzzyWatchEventWatcherWrapper, t.getCause()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markInitializationComplete() {
        LOGGER.info("[{}] [fuzzy-watch] pattern init notify finish pattern={},match service count {}", new Object[]{this.envName, this.groupKeyPattern, this.receivedServiceKeys.size()});
        this.initializationCompleted.set(true);
        NamingFuzzyWatchContext namingFuzzyWatchContext = this;
        synchronized (namingFuzzyWatchContext) {
            this.notifyAll();
        }
    }

    public synchronized void removeWatcher(FuzzyWatchEventWatcher watcher) {
        Iterator<FuzzyWatchEventWatcherWrapper> iterator = this.fuzzyWatchEventWatcherWrappers.iterator();
        while (iterator.hasNext()) {
            FuzzyWatchEventWatcherWrapper next = iterator.next();
            if (!next.fuzzyWatchEventWatcher.equals(watcher)) continue;
            iterator.remove();
            LOGGER.info("[{}] [remove-watcher-ok] groupKeyPattern={}, watcher={},uuid={} ", new Object[]{this.getEnvName(), this.groupKeyPattern, watcher, next.getUuid()});
        }
        if (this.fuzzyWatchEventWatcherWrappers.isEmpty()) {
            this.setConsistentWithServer(false);
            this.setDiscard(true);
        }
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getGroupKeyPattern() {
        return this.groupKeyPattern;
    }

    public boolean isConsistentWithServer() {
        return this.isConsistentWithServer.get();
    }

    public void setConsistentWithServer(boolean isConsistentWithServer) {
        this.isConsistentWithServer.set(isConsistentWithServer);
    }

    public boolean isDiscard() {
        return this.isDiscard;
    }

    public void setDiscard(boolean discard) {
        this.isDiscard = discard;
    }

    public boolean isInitializing() {
        return !this.initializationCompleted.get();
    }

    public Set<String> getReceivedServiceKeys() {
        return Collections.unmodifiableSet(this.receivedServiceKeys);
    }

    public boolean addReceivedServiceKey(String serviceKey) {
        boolean added = this.receivedServiceKeys.add(serviceKey);
        if (added) {
            this.refreshSyncVersion();
        }
        return added;
    }

    public boolean removeReceivedServiceKey(String serviceKey) {
        boolean removed = this.receivedServiceKeys.remove(serviceKey);
        if (removed) {
            this.refreshSyncVersion();
        }
        return removed;
    }

    public Set<FuzzyWatchEventWatcherWrapper> getFuzzyWatchEventWatcherWrappers() {
        return this.fuzzyWatchEventWatcherWrappers;
    }

    void syncFuzzyWatchers() {
        for (FuzzyWatchEventWatcherWrapper namingFuzzyWatcher : this.fuzzyWatchEventWatcherWrappers) {
            Set<String> syncGroupKeys;
            if (namingFuzzyWatcher.syncVersion == this.syncVersion) continue;
            HashSet<String> receivedServiceKeysContext = new HashSet<String>(this.getReceivedServiceKeys());
            List<FuzzyGroupKeyPattern.GroupKeyState> groupKeyStates = FuzzyGroupKeyPattern.diffGroupKeys(receivedServiceKeysContext, syncGroupKeys = namingFuzzyWatcher.getSyncServiceKeys());
            if (CollectionUtils.isEmpty(groupKeyStates)) {
                namingFuzzyWatcher.syncVersion = this.syncVersion;
                continue;
            }
            for (FuzzyGroupKeyPattern.GroupKeyState groupKeyState : groupKeyStates) {
                String changedType = groupKeyState.isExist() ? "ADD_SERVICE" : "DELETE_SERVICE";
                this.doNotifyWatcher(groupKeyState.getGroupKey(), changedType, "FUZZY_WATCH_DIFF_SYNC_NOTIFY", namingFuzzyWatcher);
            }
        }
    }

    void notifyFuzzyWatchers(String serviceKey, String changedType, String syncType, String watcherUuid) {
        for (FuzzyWatchEventWatcherWrapper namingFuzzyWatcher : this.filterWatchers(watcherUuid)) {
            this.doNotifyWatcher(serviceKey, changedType, syncType, namingFuzzyWatcher);
        }
    }

    void notifyOverLimitWatchers(int code) {
        if (this.patternLimitSuppressed()) {
            return;
        }
        boolean notify = false;
        for (FuzzyWatchEventWatcherWrapper namingFuzzyWatcherWrapper : this.filterWatchers(null)) {
            if (!(namingFuzzyWatcherWrapper.fuzzyWatchEventWatcher instanceof FuzzyWatchLoadWatcher)) continue;
            if (ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getCode().equals(code)) {
                ((FuzzyWatchLoadWatcher)((Object)namingFuzzyWatcherWrapper.fuzzyWatchEventWatcher)).onServiceReachUpLimit();
                notify = true;
            }
            if (!ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getCode().equals(code)) continue;
            ((FuzzyWatchLoadWatcher)((Object)namingFuzzyWatcherWrapper.fuzzyWatchEventWatcher)).onPatternOverLimit();
            notify = true;
        }
        if (notify) {
            this.refreshOverLimitTs();
        }
    }

    private Set<FuzzyWatchEventWatcherWrapper> filterWatchers(String uuid) {
        if (StringUtils.isBlank(uuid) || CollectionUtils.isEmpty(this.getFuzzyWatchEventWatcherWrappers())) {
            return this.getFuzzyWatchEventWatcherWrappers();
        }
        return this.getFuzzyWatchEventWatcherWrappers().stream().filter(a -> a.getUuid().equals(uuid)).collect(Collectors.toSet());
    }

    public Future<ListView<String>> createNewFuture() {
        Future<ListView<String>> completableFuture = new Future<ListView<String>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException("not support to cancel fuzzy watch");
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return NamingFuzzyWatchContext.this.initializationCompleted.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListView<String> get() throws InterruptedException {
                NamingFuzzyWatchContext namingFuzzyWatchContext = NamingFuzzyWatchContext.this;
                synchronized (namingFuzzyWatchContext) {
                    while (!NamingFuzzyWatchContext.this.initializationCompleted.get()) {
                        NamingFuzzyWatchContext.this.wait();
                    }
                }
                ListView<String> result = new ListView<String>();
                result.setData(Arrays.asList(NamingFuzzyWatchContext.this.receivedServiceKeys.toArray(new String[0])));
                result.setCount(result.getData().size());
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListView<String> get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
                if (!NamingFuzzyWatchContext.this.initializationCompleted.get()) {
                    NamingFuzzyWatchContext namingFuzzyWatchContext = NamingFuzzyWatchContext.this;
                    synchronized (namingFuzzyWatchContext) {
                        NamingFuzzyWatchContext.this.wait(unit.toMillis(timeout));
                    }
                }
                if (!NamingFuzzyWatchContext.this.initializationCompleted.get()) {
                    throw new TimeoutException("fuzzy watch result future timeout for " + unit.toMillis(timeout) + " millis");
                }
                ListView<String> result = new ListView<String>();
                result.setData(Arrays.asList(NamingFuzzyWatchContext.this.receivedServiceKeys.toArray(new String[0])));
                result.setCount(result.getData().size());
                return result;
            }
        };
        return completableFuture;
    }
}

