/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.model;

import java.io.Serializable;

public class RestResult<T>
implements Serializable {
    private static final long serialVersionUID = 6095433538316185017L;
    private int code;
    private String message;
    private T data;

    public RestResult() {
    }

    public RestResult(int code, String message, T data) {
        this.code = code;
        this.setMessage(message);
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean ok() {
        return this.code == 0 || this.code == 200;
    }

    public boolean isNoRight() {
        return this.code == 403 || this.code == 401;
    }

    public String toString() {
        return "RestResult{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }

    public static <T> ResResultBuilder<T> builder() {
        return new ResResultBuilder();
    }

    public static final class ResResultBuilder<T> {
        private int code;
        private String errMsg;
        private T data;

        private ResResultBuilder() {
        }

        public ResResultBuilder<T> withCode(int code) {
            this.code = code;
            return this;
        }

        public ResResultBuilder<T> withMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }

        public ResResultBuilder<T> withData(T data) {
            this.data = data;
            return this;
        }

        public RestResult<T> build() {
            RestResult<T> restResult = new RestResult<T>();
            restResult.setCode(this.code);
            restResult.setMessage(this.errMsg);
            restResult.setData(this.data);
            return restResult;
        }
    }
}

