/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.holder;

import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.data.DataFormatData;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.IoUtils;
import com.alibaba.excel.util.MapUtils;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.handler.context.WorkbookWriteHandlerContext;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.AbstractWriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteWorkbookHolder
extends AbstractWriteHolder {
    private static final Logger log = LoggerFactory.getLogger(WriteWorkbookHolder.class);
    private Workbook workbook;
    private Workbook cachedWorkbook;
    private WriteWorkbook writeWorkbook;
    private File file;
    private OutputStream outputStream;
    private Charset charset;
    private Boolean withBom;
    private InputStream templateInputStream;
    private File templateFile;
    private InputStream tempTemplateInputStream;
    private Boolean autoCloseStream;
    private ExcelTypeEnum excelType;
    private Boolean mandatoryUseInputStream;
    private Map<Integer, WriteSheetHolder> hasBeenInitializedSheetIndexMap;
    private Map<String, WriteSheetHolder> hasBeenInitializedSheetNameMap;
    private String password;
    private Boolean inMemory;
    private Boolean writeExcelOnException;
    private Map<Short, Map<WriteCellStyle, CellStyle>> cellStyleIndexMap;
    private Map<WriteFont, Font> fontMap;
    private Map<DataFormatData, Short> dataFormatMap;
    private WorkbookWriteHandlerContext workbookWriteHandlerContext;

    public WriteWorkbookHolder(WriteWorkbook writeWorkbook) {
        super(writeWorkbook, null);
        this.writeWorkbook = writeWorkbook;
        this.file = writeWorkbook.getFile();
        if (this.file != null) {
            try {
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ExcelGenerateException("Can not found file.", e);
            }
        } else {
            this.outputStream = writeWorkbook.getOutputStream();
        }
        this.charset = writeWorkbook.getCharset() == null ? Charset.defaultCharset() : writeWorkbook.getCharset();
        this.withBom = writeWorkbook.getWithBom() == null ? Boolean.TRUE : writeWorkbook.getWithBom();
        this.autoCloseStream = writeWorkbook.getAutoCloseStream() == null ? Boolean.TRUE : writeWorkbook.getAutoCloseStream();
        if (writeWorkbook.getExcelType() == null) {
            boolean isXls;
            boolean bl = isXls = this.file != null && this.file.getName().endsWith(ExcelTypeEnum.XLS.getValue()) || writeWorkbook.getTemplateFile() != null && writeWorkbook.getTemplateFile().getName().endsWith(ExcelTypeEnum.XLS.getValue());
            if (isXls) {
                this.excelType = ExcelTypeEnum.XLS;
            } else {
                boolean isCsv;
                boolean bl2 = isCsv = this.file != null && this.file.getName().endsWith(ExcelTypeEnum.CSV.getValue()) || writeWorkbook.getTemplateFile() != null && writeWorkbook.getTemplateFile().getName().endsWith(ExcelTypeEnum.CSV.getValue());
                this.excelType = isCsv ? ExcelTypeEnum.CSV : ExcelTypeEnum.XLSX;
            }
        } else {
            this.excelType = writeWorkbook.getExcelType();
        }
        this.initHandler(writeWorkbook, null);
        try {
            this.copyTemplate();
        }
        catch (IOException e) {
            throw new ExcelGenerateException("Copy template failure.", e);
        }
        this.mandatoryUseInputStream = writeWorkbook.getMandatoryUseInputStream() == null ? Boolean.FALSE : writeWorkbook.getMandatoryUseInputStream();
        this.hasBeenInitializedSheetIndexMap = new HashMap<Integer, WriteSheetHolder>();
        this.hasBeenInitializedSheetNameMap = new HashMap<String, WriteSheetHolder>();
        this.password = writeWorkbook.getPassword();
        this.inMemory = writeWorkbook.getInMemory() == null ? Boolean.FALSE : writeWorkbook.getInMemory();
        this.writeExcelOnException = writeWorkbook.getWriteExcelOnException() == null ? Boolean.FALSE : writeWorkbook.getWriteExcelOnException();
        this.cellStyleIndexMap = MapUtils.newHashMap();
        this.fontMap = MapUtils.newHashMap();
        this.dataFormatMap = MapUtils.newHashMap();
    }

    private void copyTemplate() throws IOException {
        if (this.writeWorkbook.getTemplateFile() == null && this.writeWorkbook.getTemplateInputStream() == null) {
            return;
        }
        if (this.excelType == ExcelTypeEnum.CSV) {
            throw new ExcelGenerateException("csv cannot use template.");
        }
        byte[] templateFileByte = null;
        if (this.writeWorkbook.getTemplateFile() != null) {
            templateFileByte = FileUtils.readFileToByteArray(this.writeWorkbook.getTemplateFile());
        } else if (this.writeWorkbook.getTemplateInputStream() != null) {
            try {
                templateFileByte = IoUtils.toByteArray(this.writeWorkbook.getTemplateInputStream());
            }
            finally {
                if (this.autoCloseStream.booleanValue()) {
                    this.writeWorkbook.getTemplateInputStream().close();
                }
            }
        }
        this.tempTemplateInputStream = new ByteArrayInputStream(templateFileByte);
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.WORKBOOK;
    }

    public CellStyle createCellStyle(WriteCellStyle writeCellStyle, CellStyle originCellStyle) {
        Font font;
        Map cellStyleMap;
        CellStyle cellStyle;
        if (writeCellStyle == null) {
            return originCellStyle;
        }
        short styleIndex = -1;
        XSSFFont originFont = null;
        boolean useCache = true;
        if (originCellStyle != null) {
            styleIndex = originCellStyle.getIndex();
            if (originCellStyle instanceof XSSFCellStyle) {
                originFont = ((XSSFCellStyle)originCellStyle).getFont();
            } else if (originCellStyle instanceof HSSFCellStyle) {
                originFont = ((HSSFCellStyle)originCellStyle).getFont(this.workbook);
            }
            useCache = false;
        }
        if ((cellStyle = (CellStyle)(cellStyleMap = this.cellStyleIndexMap.computeIfAbsent(styleIndex, key -> MapUtils.newHashMap())).get(writeCellStyle)) != null) {
            return cellStyle;
        }
        if (log.isDebugEnabled()) {
            log.info("create new style:{},{}", (Object)writeCellStyle, (Object)originCellStyle);
        }
        WriteCellStyle tempWriteCellStyle = new WriteCellStyle();
        WriteCellStyle.merge(writeCellStyle, tempWriteCellStyle);
        cellStyle = StyleUtil.buildCellStyle(this.workbook, originCellStyle, tempWriteCellStyle);
        Short dataFormat = this.createDataFormat(tempWriteCellStyle.getDataFormatData(), useCache);
        if (dataFormat != null) {
            cellStyle.setDataFormat(dataFormat.shortValue());
        }
        if ((font = this.createFont(tempWriteCellStyle.getWriteFont(), (Font)originFont, useCache)) != null) {
            cellStyle.setFont(font);
        }
        cellStyleMap.put(tempWriteCellStyle, cellStyle);
        return cellStyle;
    }

    public Font createFont(WriteFont writeFont, Font originFont, boolean useCache) {
        if (!useCache) {
            return StyleUtil.buildFont(this.workbook, originFont, writeFont);
        }
        WriteFont tempWriteFont = new WriteFont();
        WriteFont.merge(writeFont, tempWriteFont);
        Font font = this.fontMap.get(tempWriteFont);
        if (font != null) {
            return font;
        }
        font = StyleUtil.buildFont(this.workbook, originFont, tempWriteFont);
        this.fontMap.put(tempWriteFont, font);
        return font;
    }

    public Short createDataFormat(DataFormatData dataFormatData, boolean useCache) {
        if (dataFormatData == null) {
            return null;
        }
        if (!useCache) {
            return StyleUtil.buildDataFormat(this.workbook, dataFormatData);
        }
        DataFormatData tempDataFormatData = new DataFormatData();
        DataFormatData.merge(dataFormatData, tempDataFormatData);
        Short dataFormat = this.dataFormatMap.get(tempDataFormatData);
        if (dataFormat != null) {
            return dataFormat;
        }
        dataFormat = StyleUtil.buildDataFormat(this.workbook, tempDataFormatData);
        this.dataFormatMap.put(tempDataFormatData, dataFormat);
        return dataFormat;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Workbook getCachedWorkbook() {
        return this.cachedWorkbook;
    }

    public WriteWorkbook getWriteWorkbook() {
        return this.writeWorkbook;
    }

    public File getFile() {
        return this.file;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Boolean getWithBom() {
        return this.withBom;
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public InputStream getTempTemplateInputStream() {
        return this.tempTemplateInputStream;
    }

    public Boolean getAutoCloseStream() {
        return this.autoCloseStream;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public Boolean getMandatoryUseInputStream() {
        return this.mandatoryUseInputStream;
    }

    public Map<Integer, WriteSheetHolder> getHasBeenInitializedSheetIndexMap() {
        return this.hasBeenInitializedSheetIndexMap;
    }

    public Map<String, WriteSheetHolder> getHasBeenInitializedSheetNameMap() {
        return this.hasBeenInitializedSheetNameMap;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getInMemory() {
        return this.inMemory;
    }

    public Boolean getWriteExcelOnException() {
        return this.writeExcelOnException;
    }

    public Map<Short, Map<WriteCellStyle, CellStyle>> getCellStyleIndexMap() {
        return this.cellStyleIndexMap;
    }

    public Map<WriteFont, Font> getFontMap() {
        return this.fontMap;
    }

    public Map<DataFormatData, Short> getDataFormatMap() {
        return this.dataFormatMap;
    }

    public WorkbookWriteHandlerContext getWorkbookWriteHandlerContext() {
        return this.workbookWriteHandlerContext;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setCachedWorkbook(Workbook cachedWorkbook) {
        this.cachedWorkbook = cachedWorkbook;
    }

    public void setWriteWorkbook(WriteWorkbook writeWorkbook) {
        this.writeWorkbook = writeWorkbook;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setWithBom(Boolean withBom) {
        this.withBom = withBom;
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.templateInputStream = templateInputStream;
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public void setTempTemplateInputStream(InputStream tempTemplateInputStream) {
        this.tempTemplateInputStream = tempTemplateInputStream;
    }

    public void setAutoCloseStream(Boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    public void setMandatoryUseInputStream(Boolean mandatoryUseInputStream) {
        this.mandatoryUseInputStream = mandatoryUseInputStream;
    }

    public void setHasBeenInitializedSheetIndexMap(Map<Integer, WriteSheetHolder> hasBeenInitializedSheetIndexMap) {
        this.hasBeenInitializedSheetIndexMap = hasBeenInitializedSheetIndexMap;
    }

    public void setHasBeenInitializedSheetNameMap(Map<String, WriteSheetHolder> hasBeenInitializedSheetNameMap) {
        this.hasBeenInitializedSheetNameMap = hasBeenInitializedSheetNameMap;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInMemory(Boolean inMemory) {
        this.inMemory = inMemory;
    }

    public void setWriteExcelOnException(Boolean writeExcelOnException) {
        this.writeExcelOnException = writeExcelOnException;
    }

    public void setCellStyleIndexMap(Map<Short, Map<WriteCellStyle, CellStyle>> cellStyleIndexMap) {
        this.cellStyleIndexMap = cellStyleIndexMap;
    }

    public void setFontMap(Map<WriteFont, Font> fontMap) {
        this.fontMap = fontMap;
    }

    public void setDataFormatMap(Map<DataFormatData, Short> dataFormatMap) {
        this.dataFormatMap = dataFormatMap;
    }

    public void setWorkbookWriteHandlerContext(WorkbookWriteHandlerContext workbookWriteHandlerContext) {
        this.workbookWriteHandlerContext = workbookWriteHandlerContext;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteWorkbookHolder)) {
            return false;
        }
        WriteWorkbookHolder other = (WriteWorkbookHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$withBom = this.getWithBom();
        Boolean other$withBom = other.getWithBom();
        if (this$withBom == null ? other$withBom != null : !((Object)this$withBom).equals(other$withBom)) {
            return false;
        }
        Boolean this$autoCloseStream = this.getAutoCloseStream();
        Boolean other$autoCloseStream = other.getAutoCloseStream();
        if (this$autoCloseStream == null ? other$autoCloseStream != null : !((Object)this$autoCloseStream).equals(other$autoCloseStream)) {
            return false;
        }
        Boolean this$mandatoryUseInputStream = this.getMandatoryUseInputStream();
        Boolean other$mandatoryUseInputStream = other.getMandatoryUseInputStream();
        if (this$mandatoryUseInputStream == null ? other$mandatoryUseInputStream != null : !((Object)this$mandatoryUseInputStream).equals(other$mandatoryUseInputStream)) {
            return false;
        }
        Boolean this$inMemory = this.getInMemory();
        Boolean other$inMemory = other.getInMemory();
        if (this$inMemory == null ? other$inMemory != null : !((Object)this$inMemory).equals(other$inMemory)) {
            return false;
        }
        Boolean this$writeExcelOnException = this.getWriteExcelOnException();
        Boolean other$writeExcelOnException = other.getWriteExcelOnException();
        if (this$writeExcelOnException == null ? other$writeExcelOnException != null : !((Object)this$writeExcelOnException).equals(other$writeExcelOnException)) {
            return false;
        }
        Workbook this$workbook = this.getWorkbook();
        Workbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) {
            return false;
        }
        Workbook this$cachedWorkbook = this.getCachedWorkbook();
        Workbook other$cachedWorkbook = other.getCachedWorkbook();
        if (this$cachedWorkbook == null ? other$cachedWorkbook != null : !this$cachedWorkbook.equals(other$cachedWorkbook)) {
            return false;
        }
        WriteWorkbook this$writeWorkbook = this.getWriteWorkbook();
        WriteWorkbook other$writeWorkbook = other.getWriteWorkbook();
        if (this$writeWorkbook == null ? other$writeWorkbook != null : !((Object)this$writeWorkbook).equals(other$writeWorkbook)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        OutputStream this$outputStream = this.getOutputStream();
        OutputStream other$outputStream = other.getOutputStream();
        if (this$outputStream == null ? other$outputStream != null : !this$outputStream.equals(other$outputStream)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        InputStream this$templateInputStream = this.getTemplateInputStream();
        InputStream other$templateInputStream = other.getTemplateInputStream();
        if (this$templateInputStream == null ? other$templateInputStream != null : !this$templateInputStream.equals(other$templateInputStream)) {
            return false;
        }
        File this$templateFile = this.getTemplateFile();
        File other$templateFile = other.getTemplateFile();
        if (this$templateFile == null ? other$templateFile != null : !((Object)this$templateFile).equals(other$templateFile)) {
            return false;
        }
        InputStream this$tempTemplateInputStream = this.getTempTemplateInputStream();
        InputStream other$tempTemplateInputStream = other.getTempTemplateInputStream();
        if (this$tempTemplateInputStream == null ? other$tempTemplateInputStream != null : !this$tempTemplateInputStream.equals(other$tempTemplateInputStream)) {
            return false;
        }
        ExcelTypeEnum this$excelType = this.getExcelType();
        ExcelTypeEnum other$excelType = other.getExcelType();
        if (this$excelType == null ? other$excelType != null : !((Object)((Object)this$excelType)).equals((Object)other$excelType)) {
            return false;
        }
        Map<Integer, WriteSheetHolder> this$hasBeenInitializedSheetIndexMap = this.getHasBeenInitializedSheetIndexMap();
        Map<Integer, WriteSheetHolder> other$hasBeenInitializedSheetIndexMap = other.getHasBeenInitializedSheetIndexMap();
        if (this$hasBeenInitializedSheetIndexMap == null ? other$hasBeenInitializedSheetIndexMap != null : !((Object)this$hasBeenInitializedSheetIndexMap).equals(other$hasBeenInitializedSheetIndexMap)) {
            return false;
        }
        Map<String, WriteSheetHolder> this$hasBeenInitializedSheetNameMap = this.getHasBeenInitializedSheetNameMap();
        Map<String, WriteSheetHolder> other$hasBeenInitializedSheetNameMap = other.getHasBeenInitializedSheetNameMap();
        if (this$hasBeenInitializedSheetNameMap == null ? other$hasBeenInitializedSheetNameMap != null : !((Object)this$hasBeenInitializedSheetNameMap).equals(other$hasBeenInitializedSheetNameMap)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Map<Short, Map<WriteCellStyle, CellStyle>> this$cellStyleIndexMap = this.getCellStyleIndexMap();
        Map<Short, Map<WriteCellStyle, CellStyle>> other$cellStyleIndexMap = other.getCellStyleIndexMap();
        if (this$cellStyleIndexMap == null ? other$cellStyleIndexMap != null : !((Object)this$cellStyleIndexMap).equals(other$cellStyleIndexMap)) {
            return false;
        }
        Map<WriteFont, Font> this$fontMap = this.getFontMap();
        Map<WriteFont, Font> other$fontMap = other.getFontMap();
        if (this$fontMap == null ? other$fontMap != null : !((Object)this$fontMap).equals(other$fontMap)) {
            return false;
        }
        Map<DataFormatData, Short> this$dataFormatMap = this.getDataFormatMap();
        Map<DataFormatData, Short> other$dataFormatMap = other.getDataFormatMap();
        if (this$dataFormatMap == null ? other$dataFormatMap != null : !((Object)this$dataFormatMap).equals(other$dataFormatMap)) {
            return false;
        }
        WorkbookWriteHandlerContext this$workbookWriteHandlerContext = this.getWorkbookWriteHandlerContext();
        WorkbookWriteHandlerContext other$workbookWriteHandlerContext = other.getWorkbookWriteHandlerContext();
        return !(this$workbookWriteHandlerContext == null ? other$workbookWriteHandlerContext != null : !((Object)this$workbookWriteHandlerContext).equals(other$workbookWriteHandlerContext));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WriteWorkbookHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $withBom = this.getWithBom();
        result = result * 59 + ($withBom == null ? 43 : ((Object)$withBom).hashCode());
        Boolean $autoCloseStream = this.getAutoCloseStream();
        result = result * 59 + ($autoCloseStream == null ? 43 : ((Object)$autoCloseStream).hashCode());
        Boolean $mandatoryUseInputStream = this.getMandatoryUseInputStream();
        result = result * 59 + ($mandatoryUseInputStream == null ? 43 : ((Object)$mandatoryUseInputStream).hashCode());
        Boolean $inMemory = this.getInMemory();
        result = result * 59 + ($inMemory == null ? 43 : ((Object)$inMemory).hashCode());
        Boolean $writeExcelOnException = this.getWriteExcelOnException();
        result = result * 59 + ($writeExcelOnException == null ? 43 : ((Object)$writeExcelOnException).hashCode());
        Workbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        Workbook $cachedWorkbook = this.getCachedWorkbook();
        result = result * 59 + ($cachedWorkbook == null ? 43 : $cachedWorkbook.hashCode());
        WriteWorkbook $writeWorkbook = this.getWriteWorkbook();
        result = result * 59 + ($writeWorkbook == null ? 43 : ((Object)$writeWorkbook).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        OutputStream $outputStream = this.getOutputStream();
        result = result * 59 + ($outputStream == null ? 43 : $outputStream.hashCode());
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        InputStream $templateInputStream = this.getTemplateInputStream();
        result = result * 59 + ($templateInputStream == null ? 43 : $templateInputStream.hashCode());
        File $templateFile = this.getTemplateFile();
        result = result * 59 + ($templateFile == null ? 43 : ((Object)$templateFile).hashCode());
        InputStream $tempTemplateInputStream = this.getTempTemplateInputStream();
        result = result * 59 + ($tempTemplateInputStream == null ? 43 : $tempTemplateInputStream.hashCode());
        ExcelTypeEnum $excelType = this.getExcelType();
        result = result * 59 + ($excelType == null ? 43 : ((Object)((Object)$excelType)).hashCode());
        Map<Integer, WriteSheetHolder> $hasBeenInitializedSheetIndexMap = this.getHasBeenInitializedSheetIndexMap();
        result = result * 59 + ($hasBeenInitializedSheetIndexMap == null ? 43 : ((Object)$hasBeenInitializedSheetIndexMap).hashCode());
        Map<String, WriteSheetHolder> $hasBeenInitializedSheetNameMap = this.getHasBeenInitializedSheetNameMap();
        result = result * 59 + ($hasBeenInitializedSheetNameMap == null ? 43 : ((Object)$hasBeenInitializedSheetNameMap).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Map<Short, Map<WriteCellStyle, CellStyle>> $cellStyleIndexMap = this.getCellStyleIndexMap();
        result = result * 59 + ($cellStyleIndexMap == null ? 43 : ((Object)$cellStyleIndexMap).hashCode());
        Map<WriteFont, Font> $fontMap = this.getFontMap();
        result = result * 59 + ($fontMap == null ? 43 : ((Object)$fontMap).hashCode());
        Map<DataFormatData, Short> $dataFormatMap = this.getDataFormatMap();
        result = result * 59 + ($dataFormatMap == null ? 43 : ((Object)$dataFormatMap).hashCode());
        WorkbookWriteHandlerContext $workbookWriteHandlerContext = this.getWorkbookWriteHandlerContext();
        result = result * 59 + ($workbookWriteHandlerContext == null ? 43 : ((Object)$workbookWriteHandlerContext).hashCode());
        return result;
    }
}

