/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.dynamic.server.tools;

import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.callback.DynamicNacosToolCallback;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.config.NacosMcpDynamicProperties;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.definition.DynamicNacosToolDefinition;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpTool;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

public class DynamicToolsInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DynamicToolsInitializer.class);
    private final NacosMcpOperationService nacosMcpOperationService;
    private final NacosMcpDynamicProperties nacosMcpDynamicProperties;

    public DynamicToolsInitializer(NacosMcpOperationService nacosMcpOperationService, NacosMcpDynamicProperties nacosMcpDynamicProperties) {
        this.nacosMcpOperationService = nacosMcpOperationService;
        this.nacosMcpDynamicProperties = nacosMcpDynamicProperties;
    }

    public List<ToolCallback> initializeTools() {
        List<String> serviceNames = this.nacosMcpDynamicProperties.getServerNames();
        if (CollectionUtils.isEmpty(serviceNames)) {
            logger.warn("No service names configured, no tools will be initialized");
            return new ArrayList<ToolCallback>();
        }
        ArrayList<ToolCallback> allTools = new ArrayList<ToolCallback>();
        for (String serviceName : serviceNames) {
            try {
                boolean isProtocolSupported;
                McpServerDetailInfo mcpServerDetailInfo = this.nacosMcpOperationService.getServerDetail(serviceName);
                if (mcpServerDetailInfo == null) {
                    logger.warn("No service detail info found for service: {}", (Object)serviceName);
                    continue;
                }
                boolean bl = isProtocolSupported = StringUtils.equals((CharSequence)mcpServerDetailInfo.getProtocol(), (CharSequence)"http") || StringUtils.equals((CharSequence)mcpServerDetailInfo.getProtocol(), (CharSequence)"https");
                if (!isProtocolSupported) {
                    logger.warn("Protocol {} is not supported, no tools will be initialized for service: {}", (Object)mcpServerDetailInfo.getProtocol(), (Object)serviceName);
                    continue;
                }
                List<ToolCallback> tools = this.parseToolsFromMcpServerDetailInfo(mcpServerDetailInfo);
                if (!CollectionUtils.isNotEmpty(tools)) continue;
                allTools.addAll(tools);
            }
            catch (Exception e) {
                logger.error("Failed to initialize tools for service: {}", (Object)serviceName, (Object)e);
            }
        }
        logger.info("Initial dynamic tools loading completed from nacos - Found {} tools", (Object)allTools.size());
        return allTools;
    }

    private List<ToolCallback> parseToolsFromMcpServerDetailInfo(McpServerDetailInfo mcpServerDetailInfo) {
        try {
            McpToolSpecification toolSpecification = mcpServerDetailInfo.getToolSpec();
            String protocol = mcpServerDetailInfo.getProtocol();
            McpServerRemoteServiceConfig mcpServerRemoteServiceConfig = mcpServerDetailInfo.getRemoteServerConfig();
            ArrayList<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
            if (toolSpecification != null) {
                List toolsList = toolSpecification.getTools();
                Map toolsMeta = toolSpecification.getToolsMeta();
                if (toolsList == null || toolsMeta == null) {
                    return new ArrayList<ToolCallback>();
                }
                for (McpTool tool : toolsList) {
                    boolean enabled;
                    String toolName = tool.getName();
                    String toolDescription = tool.getDescription();
                    Map inputSchema = tool.getInputSchema();
                    McpToolMeta metaInfo = (McpToolMeta)toolsMeta.get(toolName);
                    boolean bl = enabled = metaInfo == null || metaInfo.isEnabled();
                    if (!enabled) {
                        logger.info("Tool {} is disabled by metaInfo, skipping.", (Object)toolName);
                        continue;
                    }
                    DynamicNacosToolDefinition toolDefinition = DynamicNacosToolDefinition.builder().name(mcpServerDetailInfo.getName() + "_tools_" + toolName).description(toolDescription).inputSchema(inputSchema).protocol(protocol).remoteServerConfig(mcpServerRemoteServiceConfig).toolsMeta(metaInfo).build();
                    toolCallbacks.add(new DynamicNacosToolCallback(toolDefinition));
                }
            }
            return toolCallbacks;
        }
        catch (Exception e) {
            logger.warn("Failed to get or parse nacos mcp service tools info (mcpName {})", (Object)(mcpServerDetailInfo.getName() + mcpServerDetailInfo.getVersionDetail().getVersion()), (Object)e);
            return null;
        }
    }
}

