/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.dynamic.server.jsontemplate;

import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.jsontemplate.RequestTemplateInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;

public class RequestTemplateParser {
    public static RequestTemplateInfo parseRequestTemplate(JsonNode requestTemplate) {
        String url = requestTemplate.path("url").asText();
        String method = requestTemplate.path("method").asText();
        boolean argsToUrlParam = requestTemplate.path("argsToUrlParam").asBoolean(false);
        boolean argsToJsonBody = requestTemplate.path("argsToJsonBody").asBoolean(false);
        boolean argsToFormBody = requestTemplate.path("argsToFormBody").asBoolean(false);
        JsonNode headers = requestTemplate.path("headers");
        JsonNode body = requestTemplate.path("body");
        return new RequestTemplateInfo(url, method, argsToUrlParam, argsToJsonBody, argsToFormBody, headers, body, requestTemplate);
    }

    public static URI buildUri(UriBuilder builder, String processedUrl, RequestTemplateInfo info, Map<String, Object> args) {
        builder.path(processedUrl);
        if (info.argsToUrlParam) {
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    for (Object item : collection) {
                        builder.queryParam(key, new Object[]{item});
                    }
                    continue;
                }
                builder.queryParam(key, new Object[]{value});
            }
        }
        return builder.build(new Object[0]);
    }

    public static void addHeaders(WebClient.RequestBodySpec requestSpec, JsonNode headersNode, Map<String, Object> args, BiFunction<String, Map<String, Object>, String> templateProcessor) {
        if (headersNode != null && headersNode.isArray()) {
            for (JsonNode header : headersNode) {
                String key = header.path("key").asText();
                String valueTemplate = header.path("value").asText();
                String value = templateProcessor.apply(valueTemplate, args);
                requestSpec.header(key, new String[]{value});
            }
        }
    }

    public static WebClient.RequestHeadersSpec<?> addRequestBody(WebClient.RequestBodySpec requestSpec, RequestTemplateInfo info, Map<String, Object> args, BiFunction<String, Map<String, Object>, String> templateProcessor, ObjectMapper objectMapper, Logger logger) {
        boolean hasBody = info.body != null && !info.body.asText().isEmpty();
        int optionCount = (hasBody ? 1 : 0) + (info.argsToJsonBody ? 1 : 0) + (info.argsToFormBody ? 1 : 0) + (info.argsToUrlParam ? 1 : 0);
        if (optionCount > 1) {
            throw new IllegalArgumentException("Only one of body, argsToJsonBody, argsToFormBody, or argsToUrlParam should be specified");
        }
        if (hasBody) {
            String bodyTemplate = info.body.asText();
            String processedBody = templateProcessor.apply(bodyTemplate, args);
            return requestSpec.contentType(MediaType.APPLICATION_JSON).bodyValue((Object)processedBody);
        }
        if (info.argsToJsonBody) {
            try {
                String jsonBody = objectMapper.writeValueAsString(args);
                return requestSpec.contentType(MediaType.APPLICATION_JSON).bodyValue((Object)jsonBody);
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to create JSON request body", (Throwable)e);
                return requestSpec;
            }
        }
        if (info.argsToFormBody) {
            LinkedMultiValueMap formData = new LinkedMultiValueMap();
            args.forEach((arg_0, arg_1) -> RequestTemplateParser.lambda$addRequestBody$0((MultiValueMap)formData, arg_0, arg_1));
            return requestSpec.contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData));
        }
        return requestSpec;
    }

    private static /* synthetic */ void lambda$addRequestBody$0(MultiValueMap formData, String key, Object value) {
        if (value != null) {
            formData.add((Object)key, (Object)value.toString());
        }
    }
}

