/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.client.tool;

import com.alibaba.cloud.ai.mcp.nacos.client.tool.LoadbalancedSyncMcpToolCallback;
import com.alibaba.cloud.ai.mcp.nacos.client.transport.LoadbalancedMcpSyncClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.util.Assert;

public class LoadbalancedSyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<LoadbalancedMcpSyncClient> mcpClients;
    private final BiPredicate<McpSyncClient, McpSchema.Tool> toolFilter;

    public LoadbalancedSyncMcpToolCallbackProvider(BiPredicate<McpSyncClient, McpSchema.Tool> toolFilter, List<LoadbalancedMcpSyncClient> mcpClients) {
        Assert.notNull(mcpClients, (String)"MCP clients must not be null");
        Assert.notNull(toolFilter, (String)"Tool filter must not be null");
        this.mcpClients = mcpClients;
        this.toolFilter = toolFilter;
    }

    public LoadbalancedSyncMcpToolCallbackProvider(List<LoadbalancedMcpSyncClient> mcpClients) {
        this((mcpClient, tool) -> true, mcpClients);
    }

    public ToolCallback[] getToolCallbacks() {
        ArrayList toolCallbacks = new ArrayList();
        this.mcpClients.stream().forEach(mcpClient -> toolCallbacks.addAll(mcpClient.listTools().tools().stream().filter(tool -> this.toolFilter.test(mcpClient.getMcpSyncClient(), (McpSchema.Tool)tool)).map(tool -> new LoadbalancedSyncMcpToolCallback((LoadbalancedMcpSyncClient)mcpClient, (McpSchema.Tool)tool)).toList()));
        ToolCallback[] array = toolCallbacks.toArray(new ToolCallback[0]);
        this.validateToolCallbacks(array);
        return array;
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((ToolCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }
}

