/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.a2a.registry.nacos;

import com.alibaba.cloud.ai.a2a.registry.nacos.discovery.NacosAgentCardProvider;
import com.alibaba.cloud.ai.a2a.registry.nacos.properties.NacosA2aProperties;
import com.alibaba.cloud.ai.autoconfigure.a2a.client.A2aClientAgentCardProviderAutoConfiguration;
import com.alibaba.nacos.api.ai.A2aService;
import com.alibaba.nacos.api.ai.AiFactory;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Properties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={A2aClientAgentCardProviderAutoConfiguration.class})
@ConditionalOnClass(value={A2aClientAgentCardProviderAutoConfiguration.class})
@EnableConfigurationProperties(value={NacosA2aProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.a2a.nacos", value={"discovery.enabled"}, havingValue="true", matchIfMissing=true)
public class NacosA2aDiscoveryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public A2aService a2aService(NacosA2aProperties nacosA2aProperties) throws NacosException {
        return AiFactory.createAiService((Properties)nacosA2aProperties.getNacosProperties());
    }

    @Bean
    public NacosAgentCardProvider nacosAgentCardProvider(A2aService a2aService) throws Exception {
        return new NacosAgentCardProvider(a2aService);
    }
}

