/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.registry.nacos.utils;

import com.alibaba.nacos.api.ai.model.a2a.AgentCapabilities;
import com.alibaba.nacos.api.ai.model.a2a.AgentInterface;
import com.alibaba.nacos.api.ai.model.a2a.AgentProvider;
import com.alibaba.nacos.api.ai.model.a2a.SecurityScheme;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentSkill;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AgentCardConverterUtil {
    public static AgentCard convertToA2aAgentCard(com.alibaba.nacos.api.ai.model.a2a.AgentCard agentCard) {
        if (agentCard == null) {
            return null;
        }
        return new AgentCard.Builder().protocolVersion(agentCard.getProtocolVersion()).name(agentCard.getName()).description(agentCard.getDescription()).version(agentCard.getVersion()).iconUrl(agentCard.getIconUrl()).capabilities(AgentCardConverterUtil.convertToA2aAgentCapabilities(agentCard.getCapabilities())).skills(AgentCardConverterUtil.convertToA2aAgentSkills(agentCard.getSkills())).url(agentCard.getUrl()).preferredTransport(agentCard.getPreferredTransport()).additionalInterfaces(AgentCardConverterUtil.convertToA2aAgentInterfaces(agentCard.getAdditionalInterfaces())).provider(AgentCardConverterUtil.convertToA2aAgentProvider(agentCard.getProvider())).documentationUrl(agentCard.getDocumentationUrl()).securitySchemes(AgentCardConverterUtil.convertToA2aAgentSecuritySchemes(agentCard.getSecuritySchemes())).security(agentCard.getSecurity()).defaultInputModes(agentCard.getDefaultInputModes()).defaultOutputModes(agentCard.getDefaultOutputModes()).supportsAuthenticatedExtendedCard(agentCard.getSupportsAuthenticatedExtendedCard().booleanValue()).build();
    }

    private static Map<String, io.a2a.spec.SecurityScheme> convertToA2aAgentSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        if (null == securitySchemes) {
            return null;
        }
        String securitySchemesJson = JacksonUtils.toJson(securitySchemes);
        return (Map)JacksonUtils.toObj((String)securitySchemesJson, (TypeReference)new TypeReference<Map<String, io.a2a.spec.SecurityScheme>>(){});
    }

    private static io.a2a.spec.AgentProvider convertToA2aAgentProvider(AgentProvider provider) {
        if (null == provider) {
            return null;
        }
        return new io.a2a.spec.AgentProvider(provider.getOrganization(), provider.getUrl());
    }

    private static List<io.a2a.spec.AgentInterface> convertToA2aAgentInterfaces(List<AgentInterface> nacosInterfaces) {
        if (nacosInterfaces == null) {
            return List.of();
        }
        return nacosInterfaces.stream().map(AgentCardConverterUtil::transferAgentInterface).collect(Collectors.toList());
    }

    private static io.a2a.spec.AgentInterface transferAgentInterface(AgentInterface agentInterface) {
        if (null == agentInterface) {
            return null;
        }
        return new io.a2a.spec.AgentInterface(agentInterface.getTransport(), agentInterface.getUrl());
    }

    private static io.a2a.spec.AgentCapabilities convertToA2aAgentCapabilities(AgentCapabilities nacosCapabilities) {
        if (nacosCapabilities == null) {
            return null;
        }
        return new AgentCapabilities.Builder().streaming(nacosCapabilities.getStreaming().booleanValue()).pushNotifications(nacosCapabilities.getPushNotifications().booleanValue()).stateTransitionHistory(nacosCapabilities.getStateTransitionHistory().booleanValue()).build();
    }

    private static List<AgentSkill> convertToA2aAgentSkills(List<com.alibaba.nacos.api.ai.model.a2a.AgentSkill> nacosSkills) {
        if (nacosSkills == null) {
            return null;
        }
        return nacosSkills.stream().map(AgentCardConverterUtil::transferAgentSkill).collect(Collectors.toList());
    }

    private static AgentSkill transferAgentSkill(com.alibaba.nacos.api.ai.model.a2a.AgentSkill nacosSkill) {
        return new AgentSkill.Builder().id(nacosSkill.getId()).tags(nacosSkill.getTags()).examples(nacosSkill.getExamples()).name(nacosSkill.getName()).description(nacosSkill.getDescription()).inputModes(nacosSkill.getInputModes()).outputModes(nacosSkill.getOutputModes()).build();
    }

    public static com.alibaba.nacos.api.ai.model.a2a.AgentCard convertToNacosAgentCard(AgentCard agentCard) {
        com.alibaba.nacos.api.ai.model.a2a.AgentCard card = new com.alibaba.nacos.api.ai.model.a2a.AgentCard();
        card.setProtocolVersion(agentCard.protocolVersion());
        card.setName(agentCard.name());
        card.setDescription(agentCard.description());
        card.setVersion(agentCard.version());
        card.setIconUrl(agentCard.iconUrl());
        card.setCapabilities(AgentCardConverterUtil.convertToNacosAgentCapabilities(agentCard.capabilities()));
        card.setSkills(agentCard.skills().stream().map(AgentCardConverterUtil::convertToNacosAgentSkill).toList());
        card.setUrl(agentCard.url());
        card.setPreferredTransport(agentCard.preferredTransport());
        card.setAdditionalInterfaces(AgentCardConverterUtil.convertToNacosAgentInterfaces(agentCard.additionalInterfaces()));
        card.setProvider(AgentCardConverterUtil.convertToNacosAgentProvider(agentCard.provider()));
        card.setDocumentationUrl(agentCard.documentationUrl());
        card.setSecuritySchemes(AgentCardConverterUtil.convertToNacosSecuritySchemes(agentCard.securitySchemes()));
        card.setSecurity(agentCard.security());
        card.setDefaultInputModes(agentCard.defaultInputModes());
        card.setDefaultOutputModes(agentCard.defaultOutputModes());
        card.setSupportsAuthenticatedExtendedCard(Boolean.valueOf(agentCard.supportsAuthenticatedExtendedCard()));
        return card;
    }

    private static AgentCapabilities convertToNacosAgentCapabilities(io.a2a.spec.AgentCapabilities capabilities) {
        AgentCapabilities nacosCapabilities = new AgentCapabilities();
        nacosCapabilities.setStreaming(Boolean.valueOf(capabilities.streaming()));
        nacosCapabilities.setPushNotifications(Boolean.valueOf(capabilities.pushNotifications()));
        nacosCapabilities.setStateTransitionHistory(Boolean.valueOf(capabilities.stateTransitionHistory()));
        return nacosCapabilities;
    }

    private static com.alibaba.nacos.api.ai.model.a2a.AgentSkill convertToNacosAgentSkill(AgentSkill agentSkill) {
        com.alibaba.nacos.api.ai.model.a2a.AgentSkill skill = new com.alibaba.nacos.api.ai.model.a2a.AgentSkill();
        skill.setId(agentSkill.id());
        skill.setName(agentSkill.name());
        skill.setDescription(agentSkill.description());
        skill.setTags(agentSkill.tags());
        skill.setExamples(agentSkill.examples());
        skill.setInputModes(agentSkill.inputModes());
        skill.setOutputModes(agentSkill.outputModes());
        return skill;
    }

    private static List<AgentInterface> convertToNacosAgentInterfaces(List<io.a2a.spec.AgentInterface> agentInterfaces) {
        if (agentInterfaces == null) {
            return List.of();
        }
        return agentInterfaces.stream().map(AgentCardConverterUtil::convertToNacosAgentInterface).collect(Collectors.toList());
    }

    private static AgentInterface convertToNacosAgentInterface(io.a2a.spec.AgentInterface agentInterface) {
        AgentInterface nacosAgentInterface = new AgentInterface();
        nacosAgentInterface.setUrl(agentInterface.url());
        nacosAgentInterface.setTransport(agentInterface.transport());
        return nacosAgentInterface;
    }

    private static AgentProvider convertToNacosAgentProvider(io.a2a.spec.AgentProvider agentProvider) {
        if (null == agentProvider) {
            return null;
        }
        AgentProvider nacosAgentProvider = new AgentProvider();
        nacosAgentProvider.setOrganization(agentProvider.organization());
        nacosAgentProvider.setUrl(agentProvider.url());
        return nacosAgentProvider;
    }

    private static Map<String, SecurityScheme> convertToNacosSecuritySchemes(Map<String, io.a2a.spec.SecurityScheme> securitySchemes) {
        if (securitySchemes == null) {
            return null;
        }
        String originalJson = JacksonUtils.toJson(securitySchemes);
        return (Map)JacksonUtils.toObj((String)originalJson, (TypeReference)new TypeReference<Map<String, SecurityScheme>>(){});
    }
}

