/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.registry.nacos.service;

import com.alibaba.cloud.ai.a2a.A2aServerProperties;
import com.alibaba.cloud.ai.a2a.registry.nacos.properties.NacosA2aProperties;
import com.alibaba.cloud.ai.a2a.registry.nacos.register.NacosA2aRegistryProperties;
import com.alibaba.cloud.ai.a2a.registry.nacos.utils.AgentCardConverterUtil;
import com.alibaba.nacos.api.ai.A2aService;
import com.alibaba.nacos.api.ai.model.a2a.AgentEndpoint;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import io.a2a.spec.AgentCard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosA2aOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosA2aOperationService.class);
    private final A2aService a2aService;
    private final NacosA2aProperties nacosA2aProperties;
    private final A2aServerProperties a2aServerProperties;
    private final NacosA2aRegistryProperties nacosA2aRegistryProperties;

    public NacosA2aOperationService(A2aService a2aService, NacosA2aProperties nacosA2aProperties, A2aServerProperties a2aServerProperties, NacosA2aRegistryProperties nacosA2aRegistryProperties) {
        this.a2aService = a2aService;
        this.nacosA2aProperties = nacosA2aProperties;
        this.a2aServerProperties = a2aServerProperties;
        this.nacosA2aRegistryProperties = nacosA2aRegistryProperties;
    }

    public void registerAgent(AgentCard agentCard) {
        com.alibaba.nacos.api.ai.model.a2a.AgentCard nacosAgentCard = AgentCardConverterUtil.convertToNacosAgentCard(agentCard);
        try {
            this.tryReleaseAgentCard(nacosAgentCard);
            this.registerEndpoint(nacosAgentCard);
        }
        catch (NacosException e) {
            LOGGER.error("Register agent card {} to Nacos failed,", (Object)agentCard.name(), (Object)e);
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
    }

    private void tryReleaseAgentCard(com.alibaba.nacos.api.ai.model.a2a.AgentCard agentCard) throws NacosException {
        LOGGER.info("Register agent card {} to Nacos namespace {}. ", (Object)agentCard.getName(), (Object)this.nacosA2aProperties.getNamespace());
        this.a2aService.releaseAgentCard(agentCard, "SERVICE", this.nacosA2aRegistryProperties.isRegisterAsLatest());
        LOGGER.info("Register agent card {} to Nacos namespace {} successfully. ", (Object)agentCard.getName(), (Object)this.nacosA2aProperties.getNamespace());
    }

    private void registerEndpoint(com.alibaba.nacos.api.ai.model.a2a.AgentCard agentCard) throws NacosException {
        AgentEndpoint endpoint = new AgentEndpoint();
        endpoint.setVersion(agentCard.getVersion());
        endpoint.setPath(this.a2aServerProperties.getMessageUrl());
        endpoint.setTransport(agentCard.getPreferredTransport());
        endpoint.setAddress(this.a2aServerProperties.getAddress());
        endpoint.setPort(this.a2aServerProperties.getPort().intValue());
        this.a2aService.registerAgentEndpoint(agentCard.getName(), endpoint);
    }
}

