/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.registry.nacos.discovery;

import com.alibaba.cloud.ai.a2a.registry.nacos.discovery.NacosAgentCardWrapper;
import com.alibaba.cloud.ai.a2a.registry.nacos.utils.AgentCardConverterUtil;
import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardProvider;
import com.alibaba.cloud.ai.graph.agent.a2a.AgentCardWrapper;
import com.alibaba.nacos.api.ai.A2aService;
import com.alibaba.nacos.api.ai.listener.AbstractNacosAgentCardListener;
import com.alibaba.nacos.api.ai.listener.NacosAgentCardEvent;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosAgentCardProvider
implements AgentCardProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosAgentCardProvider.class);
    private final A2aService a2aService;
    private AgentCardWrapper agentCard;

    public NacosAgentCardProvider(A2aService a2aService) {
        this.a2aService = a2aService;
    }

    public AgentCardWrapper getAgentCard() {
        if (null == this.agentCard) {
            throw new IllegalStateException("Please use getAgentCard(agentName) first.");
        }
        return this.agentCard;
    }

    public AgentCardWrapper getAgentCard(String agentName) {
        try {
            AgentCardDetailInfo nacosAgentCard = this.a2aService.getAgentCard(agentName);
            this.agentCard = new NacosAgentCardWrapper(AgentCardConverterUtil.convertToA2aAgentCard((AgentCard)nacosAgentCard));
            this.a2aService.subscribeAgentCard(agentName, new AbstractNacosAgentCardListener(){

                public void onEvent(NacosAgentCardEvent event) {
                    AgentCardDetailInfo newAgentCard = event.getAgentCard();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received new Agent Card: {}", (Object)JacksonUtils.toJson((Object)newAgentCard));
                    }
                    NacosAgentCardProvider.this.agentCard.setAgentCard(AgentCardConverterUtil.convertToA2aAgentCard((AgentCard)newAgentCard));
                }
            });
            return this.agentCard;
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
    }

    public boolean supportGetAgentCardByName() {
        return true;
    }
}

