/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.route;

import com.alibaba.cloud.ai.a2a.route.A2aRouterProvider;
import com.alibaba.cloud.ai.a2a.server.JsonRpcA2aRequestHandler;
import io.a2a.spec.JSONRPCResponse;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.util.Utils;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Flux;

public class JsonRpcA2aRouterProvider
implements A2aRouterProvider<JsonRpcA2aRequestHandler> {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcA2aRouterProvider.class);
    public static final String DEFAULT_WELL_KNOWN_URL = "/.well-known/agent.json";
    public static final String DEFAULT_MESSAGE_URL = "/a2a";
    private final String messageUrl;
    private final String wellKnownUrl;

    public JsonRpcA2aRouterProvider() {
        this(DEFAULT_WELL_KNOWN_URL, DEFAULT_MESSAGE_URL);
    }

    public JsonRpcA2aRouterProvider(String wellKnownUrl, String messageUrl) {
        this.wellKnownUrl = wellKnownUrl;
        this.messageUrl = messageUrl;
    }

    @Override
    public RouterFunction<ServerResponse> getRouter(JsonRpcA2aRequestHandler a2aRequestHandler) {
        return RouterFunctions.route().GET(this.wellKnownUrl, (HandlerFunction)new AgentCardHandler(a2aRequestHandler)).POST(this.messageUrl, (HandlerFunction)new MessageHandler(a2aRequestHandler)).build();
    }

    private class AgentCardHandler
    implements HandlerFunction<ServerResponse> {
        private final JsonRpcA2aRequestHandler a2aRequestHandler;

        public AgentCardHandler(JsonRpcA2aRequestHandler a2aRequestHandler) {
            this.a2aRequestHandler = a2aRequestHandler;
        }

        public ServerResponse handle(ServerRequest request) throws Exception {
            try {
                return ServerResponse.ok().body((Object)this.a2aRequestHandler.getAgentCard());
            }
            catch (Exception e) {
                log.error("Failed to get Agent Card: {}", (Object)e.getMessage());
                return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        }
    }

    private class MessageHandler
    implements HandlerFunction<ServerResponse> {
        private final JsonRpcA2aRequestHandler a2aRequestHandler;

        private MessageHandler(JsonRpcA2aRequestHandler a2aRequestHandler) {
            this.a2aRequestHandler = a2aRequestHandler;
        }

        public ServerResponse handle(ServerRequest request) throws Exception {
            try {
                String bodyString = (String)request.body(String.class);
                Object result = this.a2aRequestHandler.onHandler(bodyString, request.headers());
                if (result instanceof Flux) {
                    return this.buildSseResponse((Flux)result);
                }
                return this.buildJsonRpcResponse(result);
            }
            catch (Exception e) {
                log.error("Failed to handle request: {}", (Object)e.getMessage());
                return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        }

        private ServerResponse buildJsonRpcResponse(Object result) {
            return ServerResponse.ok().body(result);
        }

        private ServerResponse buildSseResponse(Flux<?> result) {
            return ServerResponse.sse(sseBuilder -> {
                sseBuilder.onComplete(() -> log.debug("Agent SSE connection completed."));
                sseBuilder.onTimeout(() -> log.debug("Agent SSE connection timeout."));
                result.subscribe(o -> {
                    if (o instanceof JSONRPCResponse) {
                        try {
                            TaskStatusUpdateEvent event;
                            String sseBody = Utils.OBJECT_MAPPER.writeValueAsString(o);
                            if (log.isDebugEnabled()) {
                                log.debug("send sse body to agent: {}", (Object)sseBody);
                            }
                            sseBuilder.data((Object)sseBody);
                            if (((JSONRPCResponse)o).getResult() instanceof TaskStatusUpdateEvent && (event = (TaskStatusUpdateEvent)((JSONRPCResponse)o).getResult()).isFinal()) {
                                sseBuilder.complete();
                            }
                        }
                        catch (IOException e) {
                            sseBuilder.error((Throwable)e);
                        }
                    }
                });
            }, (Duration)Duration.ZERO);
        }
    }
}

