/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.registry;

import com.alibaba.cloud.ai.a2a.registry.AgentRegistry;
import io.a2a.spec.AgentCard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

public class AgentRegistryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentRegistryService.class);
    private final AgentRegistry agentRegistry;
    private final AgentCard agentCard;

    public AgentRegistryService(AgentRegistry agentRegistry, AgentCard agentCard) {
        this.agentRegistry = agentRegistry;
        this.agentCard = agentCard;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void register() {
        LOGGER.info("Auto register agent {} into Registry {}.", (Object)this.agentCard.name(), (Object)this.agentRegistry.registryName());
        try {
            this.agentRegistry.register(this.agentCard);
            LOGGER.info("Auto register agent {} into Registry {} successfully.", (Object)this.agentCard.name(), (Object)this.agentRegistry.registryName());
        }
        catch (Exception e) {
            LOGGER.error("Auto register agent {} into Registry {} failed.", new Object[]{this.agentCard.name(), this.agentRegistry.registryName(), e});
        }
    }
}

