/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.terminal.security;

import com.adyen.enums.Environment;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TerminalCommonNameValidator {
    private static final Pattern TERMINAL_API_CN_TEST = Pattern.compile("[a-zA-Z0-9]{3,}-[a-zA-Z0-9]{9,15}\\.test\\.terminal\\.adyen\\.com");
    private static final Pattern TERMINAL_API_CN_LIVE = Pattern.compile("[a-zA-Z0-9]{3,}-[a-zA-Z0-9]{9,15}\\.live\\.terminal\\.adyen\\.com");
    private static final String TERMINAL_API_LEGACY_TEST = "legacy-terminal-certificate.test.terminal.adyen.com";
    private static final String TERMINAL_API_LEGACY_LIVE = "legacy-terminal-certificate.live.terminal.adyen.com";
    private static final Pattern SUBJECT_ATTRIBUTE_PATTERN = Pattern.compile("(?:^|,\\s?)([A-Z]+)=((?:\"[^\"]+\")|[^,]+)");

    private TerminalCommonNameValidator() {
    }

    public static boolean validateCertificate(X509Certificate certificate, Environment environment) {
        String name = certificate.getSubjectX500Principal().getName();
        Matcher matcher = SUBJECT_ATTRIBUTE_PATTERN.matcher(name);
        while (matcher.find()) {
            String groupName = matcher.group(1);
            if (!"CN".equals(groupName)) continue;
            String commonName = matcher.group(2);
            return TerminalCommonNameValidator.isValidCommonName(commonName, environment);
        }
        return false;
    }

    private static boolean isValidCommonName(String commonName, Environment environment) {
        if (commonName == null) {
            return false;
        }
        switch (environment) {
            case LIVE: {
                return TERMINAL_API_CN_LIVE.matcher(commonName).matches() || TERMINAL_API_LEGACY_LIVE.equals(commonName);
            }
            case TEST: {
                return TERMINAL_API_CN_TEST.matcher(commonName).matches() || TERMINAL_API_LEGACY_TEST.equals(commonName);
            }
        }
        return false;
    }
}

