/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.TransactionIdentification;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OriginalPOITransaction", propOrder={"poiTransactionID", "approvalCode", "hostTransactionID"})
public class OriginalPOITransaction {
    @XmlElement(name="POITransactionID")
    @Schema(description="Unique identification of a POI transaction for a POI --Rule: Absent if SaleReferenceID is sufficient to identify the transaction, or for some reversal cases.")
    protected TransactionIdentification poiTransactionID;
    @XmlElement(name="ApprovalCode")
    @Schema(description="Code assigned to a transaction approval by the Acquirer. --Rule: If referral")
    protected String approvalCode;
    @XmlElement(name="HostTransactionID")
    @Schema(description="Identification of the transaction by the host in charge of the stored value transaction --Rule: If POITransactionID not present")
    protected TransactionIdentification hostTransactionID;
    @XmlElement(name="SaleID")
    @Schema(description="Identification of a Sale System or a Sale Terminal for the Sale to POI protocol")
    protected String saleID;
    @XmlElement(name="POIID")
    @Schema(description="Identification of a POI System or a POI Terminal for the Sale to POI protocol --Rule: If original transaction is coming from another POI")
    protected String poiid;
    @XmlElement(name="ReuseCardDataFlag")
    @Schema(description="Indicate if the card data has to be got from a previous transaction.")
    protected Boolean reuseCardDataFlag;
    @XmlElement(name="CustomerLanguage")
    @Schema(description="Language of the Customer --Rule: Optional for Reversal, otherwise absent.")
    protected String customerLanguage;
    @XmlElement(name="AcquirerID")
    @Schema(description="Identification of the Acquirer --Rule: Optional for Reversal, otherwise absent.")
    protected String acquirerID;

    public TransactionIdentification getPOITransactionID() {
        return this.poiTransactionID;
    }

    public void setPOITransactionID(TransactionIdentification value) {
        this.poiTransactionID = value;
    }

    public String getApprovalCode() {
        return this.approvalCode;
    }

    public void setApprovalCode(String value) {
        this.approvalCode = value;
    }

    public TransactionIdentification getHostTransactionID() {
        return this.hostTransactionID;
    }

    public void setHostTransactionID(TransactionIdentification value) {
        this.hostTransactionID = value;
    }

    public String getSaleID() {
        return this.saleID;
    }

    public void setSaleID(String value) {
        this.saleID = value;
    }

    public String getPOIID() {
        return this.poiid;
    }

    public void setPOIID(String value) {
        this.poiid = value;
    }

    public boolean isReuseCardDataFlag() {
        if (this.reuseCardDataFlag == null) {
            return true;
        }
        return this.reuseCardDataFlag;
    }

    public void setReuseCardDataFlag(Boolean value) {
        this.reuseCardDataFlag = value;
    }

    public String getCustomerLanguage() {
        return this.customerLanguage;
    }

    public void setCustomerLanguage(String value) {
        this.customerLanguage = value;
    }

    public String getAcquirerID() {
        return this.acquirerID;
    }

    public void setAcquirerID(String value) {
        this.acquirerID = value;
    }
}

