/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"plans", "preselectedValue", "values"})
public class CheckoutSessionInstallmentOption {
    public static final String JSON_PROPERTY_PLANS = "plans";
    private List<PlansEnum> plans;
    public static final String JSON_PROPERTY_PRESELECTED_VALUE = "preselectedValue";
    private Integer preselectedValue;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<Integer> values;

    public CheckoutSessionInstallmentOption plans(List<PlansEnum> plans) {
        this.plans = plans;
        return this;
    }

    public CheckoutSessionInstallmentOption addPlansItem(PlansEnum plansItem) {
        if (this.plans == null) {
            this.plans = new ArrayList<PlansEnum>();
        }
        this.plans.add(plansItem);
        return this;
    }

    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PlansEnum> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlans(List<PlansEnum> plans) {
        this.plans = plans;
    }

    public CheckoutSessionInstallmentOption preselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
        return this;
    }

    @JsonProperty(value="preselectedValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPreselectedValue() {
        return this.preselectedValue;
    }

    @JsonProperty(value="preselectedValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
    }

    public CheckoutSessionInstallmentOption values(List<Integer> values) {
        this.values = values;
        return this;
    }

    public CheckoutSessionInstallmentOption addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutSessionInstallmentOption checkoutSessionInstallmentOption = (CheckoutSessionInstallmentOption)o;
        return Objects.equals(this.plans, checkoutSessionInstallmentOption.plans) && Objects.equals(this.preselectedValue, checkoutSessionInstallmentOption.preselectedValue) && Objects.equals(this.values, checkoutSessionInstallmentOption.values);
    }

    public int hashCode() {
        return Objects.hash(this.plans, this.preselectedValue, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutSessionInstallmentOption {\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("    preselectedValue: ").append(this.toIndentedString(this.preselectedValue)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CheckoutSessionInstallmentOption fromJson(String jsonString) throws JsonProcessingException {
        return (CheckoutSessionInstallmentOption)JSON.getMapper().readValue(jsonString, CheckoutSessionInstallmentOption.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PlansEnum {
        BONUS(String.valueOf("bonus")),
        BUYNOW_PAYLATER(String.valueOf("buynow_paylater")),
        INTERES_REFUND_PRCTG(String.valueOf("interes_refund_prctg")),
        INTEREST_BONUS(String.valueOf("interest_bonus")),
        NOINTERES_REFUND_PRCTG(String.valueOf("nointeres_refund_prctg")),
        NOINTEREST_BONUS(String.valueOf("nointerest_bonus")),
        REFUND_PRCTG(String.valueOf("refund_prctg")),
        REGULAR(String.valueOf("regular")),
        REVOLVING(String.valueOf("revolving")),
        WITH_INTEREST(String.valueOf("with_interest"));

        private static final Logger LOG;
        private String value;

        private PlansEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlansEnum fromValue(String value) {
            for (PlansEnum b : PlansEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PlansEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PlansEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PlansEnum.class.getName());
        }
    }
}

