/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.PayoutScheduleResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "bankAccountUUID", "beneficiaryAccount", "beneficiaryMerchantReference", "description", "metadata", "payoutMethodCode", "payoutSchedule", "payoutSpeed", "status"})
public class Account {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_BENEFICIARY_ACCOUNT = "beneficiaryAccount";
    private String beneficiaryAccount;
    public static final String JSON_PROPERTY_BENEFICIARY_MERCHANT_REFERENCE = "beneficiaryMerchantReference";
    private String beneficiaryMerchantReference;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_PAYOUT_SCHEDULE = "payoutSchedule";
    private PayoutScheduleResponse payoutSchedule;
    public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
    private PayoutSpeedEnum payoutSpeed;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public Account accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Account bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(value="The bankAccountUUID of the bank account held by the account holder to couple the account with. Scheduled payouts in currencies matching the currency of this bank account will be sent to this bank account. Payouts in different currencies will be sent to a matching bank account of the account holder.")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public Account beneficiaryAccount(String beneficiaryAccount) {
        this.beneficiaryAccount = beneficiaryAccount;
        return this;
    }

    @ApiModelProperty(value="The beneficiary of the account.")
    @JsonProperty(value="beneficiaryAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBeneficiaryAccount() {
        return this.beneficiaryAccount;
    }

    @JsonProperty(value="beneficiaryAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeneficiaryAccount(String beneficiaryAccount) {
        this.beneficiaryAccount = beneficiaryAccount;
    }

    public Account beneficiaryMerchantReference(String beneficiaryMerchantReference) {
        this.beneficiaryMerchantReference = beneficiaryMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The reason that a beneficiary has been set up for this account. This may have been supplied during the setup of a beneficiary at the discretion of the executing user.")
    @JsonProperty(value="beneficiaryMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBeneficiaryMerchantReference() {
        return this.beneficiaryMerchantReference;
    }

    @JsonProperty(value="beneficiaryMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeneficiaryMerchantReference(String beneficiaryMerchantReference) {
        this.beneficiaryMerchantReference = beneficiaryMerchantReference;
    }

    public Account description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the account.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Account metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Account putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Account payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The payout method code held by the account holder to couple the account with. Scheduled card payouts will be sent using this payout method code.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public Account payoutSchedule(PayoutScheduleResponse payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutScheduleResponse getPayoutSchedule() {
        return this.payoutSchedule;
    }

    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSchedule(PayoutScheduleResponse payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    public Account payoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
        return this;
    }

    @ApiModelProperty(value="Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutSpeedEnum getPayoutSpeed() {
        return this.payoutSpeed;
    }

    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
    }

    public Account status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the account. Possible values: `Active`, `Inactive`, `Suspended`, `Closed`.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.accountCode, account.accountCode) && Objects.equals(this.bankAccountUUID, account.bankAccountUUID) && Objects.equals(this.beneficiaryAccount, account.beneficiaryAccount) && Objects.equals(this.beneficiaryMerchantReference, account.beneficiaryMerchantReference) && Objects.equals(this.description, account.description) && Objects.equals(this.metadata, account.metadata) && Objects.equals(this.payoutMethodCode, account.payoutMethodCode) && Objects.equals(this.payoutSchedule, account.payoutSchedule) && Objects.equals((Object)this.payoutSpeed, (Object)account.payoutSpeed) && Objects.equals(this.status, account.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountCode, this.bankAccountUUID, this.beneficiaryAccount, this.beneficiaryMerchantReference, this.description, this.metadata, this.payoutMethodCode, this.payoutSchedule, this.payoutSpeed, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    beneficiaryAccount: ").append(this.toIndentedString(this.beneficiaryAccount)).append("\n");
        sb.append("    beneficiaryMerchantReference: ").append(this.toIndentedString(this.beneficiaryMerchantReference)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    payoutSchedule: ").append(this.toIndentedString(this.payoutSchedule)).append("\n");
        sb.append("    payoutSpeed: ").append(this.toIndentedString((Object)this.payoutSpeed)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Account fromJson(String jsonString) throws JsonProcessingException {
        return (Account)JSON.getMapper().readValue(jsonString, Account.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PayoutSpeedEnum {
        INSTANT("INSTANT"),
        SAME_DAY("SAME_DAY"),
        STANDARD("STANDARD");

        private String value;

        private PayoutSpeedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutSpeedEnum fromValue(String value) {
            for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

