/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.acswebhooks;

import com.adyen.model.acswebhooks.AuthenticationInfo;
import com.adyen.model.acswebhooks.JSON;
import com.adyen.model.acswebhooks.PurchaseInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"authentication", "balancePlatform", "id", "paymentInstrumentId", "purchase", "status"})
public class AuthenticationNotificationData {
    public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
    private AuthenticationInfo authentication;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_PURCHASE = "purchase";
    private PurchaseInfo purchase;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public AuthenticationNotificationData authentication(AuthenticationInfo authentication) {
        this.authentication = authentication;
        return this;
    }

    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticationInfo getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthentication(AuthenticationInfo authentication) {
        this.authentication = authentication;
    }

    public AuthenticationNotificationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public AuthenticationNotificationData id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AuthenticationNotificationData paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public AuthenticationNotificationData purchase(PurchaseInfo purchase) {
        this.purchase = purchase;
        return this;
    }

    @JsonProperty(value="purchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PurchaseInfo getPurchase() {
        return this.purchase;
    }

    @JsonProperty(value="purchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurchase(PurchaseInfo purchase) {
        this.purchase = purchase;
    }

    public AuthenticationNotificationData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationNotificationData authenticationNotificationData = (AuthenticationNotificationData)o;
        return Objects.equals(this.authentication, authenticationNotificationData.authentication) && Objects.equals(this.balancePlatform, authenticationNotificationData.balancePlatform) && Objects.equals(this.id, authenticationNotificationData.id) && Objects.equals(this.paymentInstrumentId, authenticationNotificationData.paymentInstrumentId) && Objects.equals(this.purchase, authenticationNotificationData.purchase) && Objects.equals((Object)this.status, (Object)authenticationNotificationData.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authentication, this.balancePlatform, this.id, this.paymentInstrumentId, this.purchase, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationNotificationData {\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    purchase: ").append(this.toIndentedString(this.purchase)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AuthenticationNotificationData fromJson(String jsonString) throws JsonProcessingException {
        return (AuthenticationNotificationData)JSON.getMapper().readValue(jsonString, AuthenticationNotificationData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        AUTHENTICATED(String.valueOf("authenticated")),
        REJECTED(String.valueOf("rejected")),
        ERROR(String.valueOf("error"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }
}

