/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"companyAccount", "merchantAccount", "merchantInventory", "store", "terminals"})
public class AssignTerminalsRequest {
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_INVENTORY = "merchantInventory";
    private Boolean merchantInventory;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_TERMINALS = "terminals";
    private List<String> terminals = new ArrayList<String>();

    public AssignTerminalsRequest companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your company account. To return terminals to the company inventory, specify only this parameter and the `terminals`.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public AssignTerminalsRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="Name of the merchant account. Specify this parameter to assign terminals to this merchant account or to a store under this merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public AssignTerminalsRequest merchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
        return this;
    }

    @ApiModelProperty(value="Boolean that indicates if you are assigning the terminals to the merchant inventory. Do not use when assigning terminals to a store. Required when assigning the terminal to a merchant account.  - Set this to **true** to assign the terminals to the merchant inventory. This also means that the terminals cannot be boarded.  - Set this to **false** to assign the terminals to the merchant account as in-store terminals. This makes the terminals ready to be boarded and to process payments through the specified merchant account.")
    @JsonProperty(value="merchantInventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMerchantInventory() {
        return this.merchantInventory;
    }

    @JsonProperty(value="merchantInventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
    }

    public AssignTerminalsRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store that you want to assign the terminals to.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public AssignTerminalsRequest terminals(List<String> terminals) {
        this.terminals = terminals;
        return this;
    }

    public AssignTerminalsRequest addTerminalsItem(String terminalsItem) {
        this.terminals.add(terminalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array containing a list of terminal IDs that you want to assign or reassign to the merchant account or store, or that you want to return to the company inventory.  For example, `[\"V400m-324689776\",\"P400Plus-329127412\"]`.")
    @JsonProperty(value="terminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTerminals() {
        return this.terminals;
    }

    @JsonProperty(value="terminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminals(List<String> terminals) {
        this.terminals = terminals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignTerminalsRequest assignTerminalsRequest = (AssignTerminalsRequest)o;
        return Objects.equals(this.companyAccount, assignTerminalsRequest.companyAccount) && Objects.equals(this.merchantAccount, assignTerminalsRequest.merchantAccount) && Objects.equals(this.merchantInventory, assignTerminalsRequest.merchantInventory) && Objects.equals(this.store, assignTerminalsRequest.store) && Objects.equals(this.terminals, assignTerminalsRequest.terminals);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.merchantAccount, this.merchantInventory, this.store, this.terminals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssignTerminalsRequest {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantInventory: ").append(this.toIndentedString(this.merchantInventory)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    terminals: ").append(this.toIndentedString(this.terminals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AssignTerminalsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (AssignTerminalsRequest)JSON.getMapper().readValue(jsonString, AssignTerminalsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

