/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.AmountsResp;
import com.adyen.model.nexo.AuthenticationMethodType;
import com.adyen.model.nexo.CapturedSignature;
import com.adyen.model.nexo.ContentInformation;
import com.adyen.model.nexo.CurrencyConversion;
import com.adyen.model.nexo.Instalment;
import com.adyen.model.nexo.PaymentAcquirerData;
import com.adyen.model.nexo.PaymentInstrumentData;
import com.adyen.model.nexo.PaymentType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PaymentResult", propOrder={"paymentInstrumentData", "amountsResp", "instalment", "currencyConversion", "capturedSignature", "protectedSignature", "paymentAcquirerData"})
public class PaymentResult {
    @XmlElement(name="PaymentInstrumentData")
    @Schema(description="Data related to the instrument of payment for the transaction. --Rule: If a payment instrument is analysed by the POI")
    protected PaymentInstrumentData paymentInstrumentData;
    @XmlElement(name="AmountsResp")
    @Schema(description="Various amounts related to the payment response from the POI System. --Rule: If Result is Success or Partial")
    protected AmountsResp amountsResp;
    @XmlElement(name="Instalment")
    @Schema(description="Information related an instalment transaction. --Rule: Absent if PaymentType is not \"IssuerInstalment\"")
    protected Instalment instalment;
    @XmlElement(name="CurrencyConversion")
    @Schema(description="Information related to a currency conversion --Rule: If currency conversion the Sale needs to know")
    protected List<CurrencyConversion> currencyConversion;
    @XmlElement(name="CapturedSignature")
    @Schema(description="Numeric value of a handwritten signature. --Rule: If handwritten signature is captured on the POI by a signature capture device.")
    protected CapturedSignature capturedSignature;
    @XmlElement(name="ProtectedSignature")
    @Schema(description="Numeric value of a handwritten signature. --Rule: Encrypted handwritten signature captured on the POI by a signature capture device.")
    protected ContentInformation protectedSignature;
    @XmlElement(name="PaymentAcquirerData")
    @Schema(description="Data related to the response from the payment Acquirer. --Rule: If a card is analysed and data available")
    protected PaymentAcquirerData paymentAcquirerData;
    @XmlElement(name="PaymentType")
    @Schema(description="Type of payment transaction. --Rule: Copy")
    protected PaymentType paymentType;
    @XmlElement(name="MerchantOverrideFlag")
    @Schema(description="Indicate that the Merchant forced the result of the payment to successfull. --Rule: If payment forced by the Cashier")
    protected Boolean merchantOverrideFlag;
    @XmlElement(name="CustomerLanguage")
    @Schema(description="Language of the Customer --Rule: If the customer language is different from the default language or different from the CustomerLanguage of the")
    protected String customerLanguage;
    @XmlElement(name="OnlineFlag")
    @Schema(description="Indicate that the payment transaction processing has required the approval of a host. --Rule: \"True\" if the payment transaction processing has required the approval of a host.")
    protected Boolean onlineFlag;
    @XmlElement(name="AuthenticationMethod")
    @Schema(description="Method for customer authentication. --Rule: Method for customer authentication.")
    protected List<AuthenticationMethodType> authenticationMethod;
    @XmlElement(name="ValidityDate")
    @Schema(description="End of the validity period for the reservation. --Rule: if OneTimeReservation, FirstReservation or UpdateReservation")
    protected String validityDate;

    public PaymentInstrumentData getPaymentInstrumentData() {
        return this.paymentInstrumentData;
    }

    public void setPaymentInstrumentData(PaymentInstrumentData value) {
        this.paymentInstrumentData = value;
    }

    public AmountsResp getAmountsResp() {
        return this.amountsResp;
    }

    public void setAmountsResp(AmountsResp value) {
        this.amountsResp = value;
    }

    public Instalment getInstalment() {
        return this.instalment;
    }

    public void setInstalment(Instalment value) {
        this.instalment = value;
    }

    public List<CurrencyConversion> getCurrencyConversion() {
        if (this.currencyConversion == null) {
            this.currencyConversion = new ArrayList<CurrencyConversion>();
        }
        return this.currencyConversion;
    }

    public CapturedSignature getCapturedSignature() {
        return this.capturedSignature;
    }

    public void setCapturedSignature(CapturedSignature value) {
        this.capturedSignature = value;
    }

    public ContentInformation getProtectedSignature() {
        return this.protectedSignature;
    }

    public void setProtectedSignature(ContentInformation value) {
        this.protectedSignature = value;
    }

    public PaymentAcquirerData getPaymentAcquirerData() {
        return this.paymentAcquirerData;
    }

    public void setPaymentAcquirerData(PaymentAcquirerData value) {
        this.paymentAcquirerData = value;
    }

    public PaymentType getPaymentType() {
        if (this.paymentType == null) {
            return PaymentType.NORMAL;
        }
        return this.paymentType;
    }

    public void setPaymentType(PaymentType value) {
        this.paymentType = value;
    }

    public boolean isMerchantOverrideFlag() {
        if (this.merchantOverrideFlag == null) {
            return false;
        }
        return this.merchantOverrideFlag;
    }

    public void setMerchantOverrideFlag(Boolean value) {
        this.merchantOverrideFlag = value;
    }

    public String getCustomerLanguage() {
        return this.customerLanguage;
    }

    public void setCustomerLanguage(String value) {
        this.customerLanguage = value;
    }

    public boolean isOnlineFlag() {
        if (this.onlineFlag == null) {
            return true;
        }
        return this.onlineFlag;
    }

    public void setOnlineFlag(Boolean value) {
        this.onlineFlag = value;
    }

    public List<AuthenticationMethodType> getAuthenticationMethod() {
        if (this.authenticationMethod == null) {
            this.authenticationMethod = new ArrayList<AuthenticationMethodType>();
        }
        return this.authenticationMethod;
    }

    public String getValidityDate() {
        return this.validityDate;
    }

    public void setValidityDate(String value) {
        this.validityDate = value;
    }
}

