/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.Device;
import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"accountScore", "device", "deviceScore", "provisioningMethod", "recommendationReasons", "type"})
public class Wallet {
    public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
    private String accountScore;
    public static final String JSON_PROPERTY_DEVICE = "device";
    private Device device;
    public static final String JSON_PROPERTY_DEVICE_SCORE = "deviceScore";
    private String deviceScore;
    public static final String JSON_PROPERTY_PROVISIONING_METHOD = "provisioningMethod";
    private String provisioningMethod;
    public static final String JSON_PROPERTY_RECOMMENDATION_REASONS = "recommendationReasons";
    private List<RecommendationReasonsEnum> recommendationReasons;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Deprecated
    private String type;

    public Wallet accountScore(String accountScore) {
        this.accountScore = accountScore;
        return this;
    }

    @JsonProperty(value="accountScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountScore() {
        return this.accountScore;
    }

    @JsonProperty(value="accountScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountScore(String accountScore) {
        this.accountScore = accountScore;
    }

    public Wallet device(Device device) {
        this.device = device;
        return this;
    }

    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Device getDevice() {
        return this.device;
    }

    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDevice(Device device) {
        this.device = device;
    }

    public Wallet deviceScore(String deviceScore) {
        this.deviceScore = deviceScore;
        return this;
    }

    @JsonProperty(value="deviceScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceScore() {
        return this.deviceScore;
    }

    @JsonProperty(value="deviceScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceScore(String deviceScore) {
        this.deviceScore = deviceScore;
    }

    public Wallet provisioningMethod(String provisioningMethod) {
        this.provisioningMethod = provisioningMethod;
        return this;
    }

    @JsonProperty(value="provisioningMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProvisioningMethod() {
        return this.provisioningMethod;
    }

    @JsonProperty(value="provisioningMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvisioningMethod(String provisioningMethod) {
        this.provisioningMethod = provisioningMethod;
    }

    public Wallet recommendationReasons(List<RecommendationReasonsEnum> recommendationReasons) {
        this.recommendationReasons = recommendationReasons;
        return this;
    }

    public Wallet addRecommendationReasonsItem(RecommendationReasonsEnum recommendationReasonsItem) {
        if (this.recommendationReasons == null) {
            this.recommendationReasons = new ArrayList<RecommendationReasonsEnum>();
        }
        this.recommendationReasons.add(recommendationReasonsItem);
        return this;
    }

    @JsonProperty(value="recommendationReasons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RecommendationReasonsEnum> getRecommendationReasons() {
        return this.recommendationReasons;
    }

    @JsonProperty(value="recommendationReasons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecommendationReasons(List<RecommendationReasonsEnum> recommendationReasons) {
        this.recommendationReasons = recommendationReasons;
    }

    @Deprecated
    public Wallet type(String type) {
        this.type = type;
        return this;
    }

    @Deprecated
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Deprecated
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wallet wallet = (Wallet)o;
        return Objects.equals(this.accountScore, wallet.accountScore) && Objects.equals(this.device, wallet.device) && Objects.equals(this.deviceScore, wallet.deviceScore) && Objects.equals(this.provisioningMethod, wallet.provisioningMethod) && Objects.equals(this.recommendationReasons, wallet.recommendationReasons) && Objects.equals(this.type, wallet.type);
    }

    public int hashCode() {
        return Objects.hash(this.accountScore, this.device, this.deviceScore, this.provisioningMethod, this.recommendationReasons, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Wallet {\n");
        sb.append("    accountScore: ").append(this.toIndentedString(this.accountScore)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    deviceScore: ").append(this.toIndentedString(this.deviceScore)).append("\n");
        sb.append("    provisioningMethod: ").append(this.toIndentedString(this.provisioningMethod)).append("\n");
        sb.append("    recommendationReasons: ").append(this.toIndentedString(this.recommendationReasons)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Wallet fromJson(String jsonString) throws JsonProcessingException {
        return (Wallet)JSON.getMapper().readValue(jsonString, Wallet.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum RecommendationReasonsEnum {
        ACCOUNTCARDTOONEW(String.valueOf("accountCardTooNew")),
        ACCOUNTHIGHRISK(String.valueOf("accountHighRisk")),
        ACCOUNTRECENTLYCHANGED(String.valueOf("accountRecentlyChanged")),
        ACCOUNTTOONEW(String.valueOf("accountTooNew")),
        ACCOUNTTOONEWSINCELAUNCH(String.valueOf("accountTooNewSinceLaunch")),
        CARDHOLDERPANASSOCIATEDTOACCOUNTWITHINTHRESHOLDDAYS(String.valueOf("cardholderPanAssociatedToAccountWithinThresholdDays")),
        CHANGESMADETOACCOUNTDATAWITHINTHRESHOLDDAYS(String.valueOf("changesMadeToAccountDataWithinThresholdDays")),
        DEVICEPROVISIONINGLOCATIONOUTSIDEOFCARDHOLDERSWALLETACCOUNTHOMECOUNTRY(String.valueOf("deviceProvisioningLocationOutsideOfCardholdersWalletAccountHomeCountry")),
        DEVICERECENTLYLOST(String.valueOf("deviceRecentlyLost")),
        ENCRYPTEDPAYMENTINSTRUMENTDATAISBEINGPUSHEDBYTHEISSUERTOTHESAMEDEVICETHATISSUERAPPLICATIONAUTHENTICATEDBUTWITHSUCCESSFULUPFRONTAUTHENTICATION(String.valueOf("encryptedPaymentInstrumentDataIsBeingPushedByTheIssuerToTheSameDeviceThatIssuerApplicationAuthenticatedButWithSuccessfulUpfrontAuthentication")),
        ENCRYPTEDPAYMENTINSTRUMENTDATAISBEINGPUSHEDBYTHEISSUERTOTHESAMEDEVICETHATISSUERAPPLICATIONAUTHENTICATEDBUTWITHOUTANYUPFRONTAUTHENTICATION(String.valueOf("encryptedPaymentInstrumentDataIsBeingPushedByTheIssuerToTheSameDeviceThatIssuerApplicationAuthenticatedButWithoutAnyUpfrontAuthentication")),
        ENCRYPTEDPAYMENTINSTRUMENTDATAISPUSHEDTOADIFFERENTDEVICETHANTHEONETHATISSUERAPPLICATIONAUTHENTICATED(String.valueOf("encryptedPaymentInstrumentDataIsPushedToADifferentDeviceThanTheOneThatIssuerApplicationAuthenticated")),
        ENCRYPTEDPAYMENTINSTRUMENTDATAISPUSHEDTOADIFFERENTUSERTHANTHECARDHOLDER(String.valueOf("encryptedPaymentInstrumentDataIsPushedToADifferentUserThanTheCardHolder")),
        HASSUSPENDEDTOKENS(String.valueOf("hasSuspendedTokens")),
        INACTIVEACCOUNT(String.valueOf("inactiveAccount")),
        ISSUERDEFERREDIDVDECISION(String.valueOf("issuerDeferredIDVDecision")),
        ISSUERENCRYPTEDPAYMENTINSTRUMENTDATAEXPIRED(String.valueOf("issuerEncryptedPaymentInstrumentDataExpired")),
        LOWACCOUNTSCORE(String.valueOf("lowAccountScore")),
        LOWDEVICESCORE(String.valueOf("lowDeviceScore")),
        LOWPHONENUMBERSCORE(String.valueOf("lowPhoneNumberScore")),
        NUMBEROFACTIVETOKENSGREATERTHANTHRESHOLD(String.valueOf("numberOfActiveTokensGreaterThanThreshold")),
        NUMBEROFACTIVETOKENSONALLDEVICESISGREATERTHANTHRESHOLD(String.valueOf("numberOfActiveTokensOnAllDevicesIsGreaterThanThreshold")),
        NUMBEROFDAYSSINCEDEVICEWASLASTREPORTEDLOSTISLESSTHANTHRESHOLDDAYS(String.valueOf("numberOfDaysSinceDeviceWasLastReportedLostIsLessThanThresholdDays")),
        NUMBEROFDEVICESWITHSAMEUSERIDWITHTOKENISGREATERTHANTHRESHOLD(String.valueOf("numberOfDevicesWithSameUseridWithTokenIsGreaterThanThreshold")),
        NUMBEROFTRANSACTIONSINLAST12MONTHSLESSTHANTHRESHOLDNUMBER(String.valueOf("numberOfTransactionsInLast12MonthsLessThanThresholdNumber")),
        OUTSIDEHOMETERRITORY(String.valueOf("outSideHomeTerritory")),
        SUSPENDEDCARDSINTHEWALLETACCOUNTISGREATERTHANTHRESHOLD(String.valueOf("suspendedCardsInTheWALLETAccountIsGreaterThanThreshold")),
        SUSPICIOUSACTIVITY(String.valueOf("suspiciousActivity")),
        THENUMBEROFPROVISIONINGATTEMPTSACROSSALLCARDSONTHISDEVICEINTHELAST24HOURSEXCEEDSTHETHRESHOLD(String.valueOf("theNumberOfProvisioningAttemptsAcrossAllCardsOnThisDeviceInTheLast24HoursExceedsTheThreshold")),
        THEWALLETACCOUNTINTOWHICHTHECARDISBEINGPROVISIONEDCONTAINDISTINCTNAMESGREATERTHANTHRESHOLD(String.valueOf("theWALLETAccountIntoWhichTheCardIsBeingProvisionedContainDistinctNamesGreaterThanThreshold")),
        THISACCOUNTHASNOTHADACTIVITYWITHINTHRESHOLDPERIOD(String.valueOf("thisAccountHasNotHadActivityWithinThresholdPeriod")),
        TOOMANYDIFFERENTCARDHOLDERS(String.valueOf("tooManyDifferentCardholders")),
        TOOMANYRECENTATTEMPTS(String.valueOf("tooManyRecentAttempts")),
        TOOMANYRECENTTOKENS(String.valueOf("tooManyRecentTokens")),
        UNABLETOASSESS(String.valueOf("unableToAssess")),
        UNKNOWN(String.valueOf("unknown")),
        USERACCOUNTWASCREATEDWITHINTHRESHOLDDAYS(String.valueOf("userAccountWasCreatedWithinThresholdDays")),
        USERDEVICERECEIVINGENCRYPTEDPAYMENTINSTRUMENTDATAISDIFFERENTTHANTHEONETHATISPROVISIONINGTHETOKEN(String.valueOf("userDeviceReceivingEncryptedPaymentInstrumentDataIsDifferentThanTheOneThatIsProvisioningTheToken")),
        USERSACCOUNTONDEVICELESSTHANTHRESHOLDDAYS(String.valueOf("usersAccountOnDeviceLessThanThresholdDays")),
        WALLETACCOUNTCREATEDWITHINTHRESHOLDDAYS(String.valueOf("walletAccountCreatedWithinThresholdDays")),
        WALLETACCOUNTHOLDERNAMEONFILEDOESNOTMATCHCARDHOLDERENTEREDNAME(String.valueOf("walletAccountHolderNameOnFileDoesNotMatchCardholderEnteredName"));

        private static final Logger LOG;
        private String value;

        private RecommendationReasonsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecommendationReasonsEnum fromValue(String value) {
            for (RecommendationReasonsEnum b : RecommendationReasonsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("RecommendationReasonsEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])RecommendationReasonsEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(RecommendationReasonsEnum.class.getName());
        }
    }
}

