/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopySource;
import com.adobe.testing.s3mock.dto.Delete;
import com.adobe.testing.s3mock.dto.DeleteResult;
import com.adobe.testing.s3mock.dto.GetObjectAttributesOutput;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.ObjectAttributes;
import com.adobe.testing.s3mock.dto.ObjectKey;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.dto.TagSet;
import com.adobe.testing.s3mock.dto.Tagging;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.service.ObjectService;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.AwsHttpHeaders;
import com.adobe.testing.s3mock.util.HeaderUtil;
import com.adobe.testing.s3mock.util.XmlUtil;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@CrossOrigin(origins={"*"}, exposedHeaders={"*"})
@Controller
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class ObjectController {
    private static final String RANGES_BYTES = "bytes";
    private final BucketService bucketService;
    private final ObjectService objectService;

    public ObjectController(BucketService bucketService, ObjectService objectService) {
        this.bucketService = bucketService;
        this.objectService = objectService;
    }

    @PostMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"delete"}, produces={"application/xml"})
    public ResponseEntity<DeleteResult> deleteObjects(@PathVariable String bucketName, @RequestBody Delete body) {
        this.bucketService.verifyBucketExists(bucketName);
        return ResponseEntity.ok((Object)this.objectService.deleteObjects(bucketName, body));
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> headObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key());
        if (s3ObjectMetadata != null) {
            this.objectService.verifyObjectMatching(match, noneMatch, s3ObjectMetadata);
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).header("Accept-Ranges", new String[]{RANGES_BYTES})).headers(headers -> headers.setAll(s3ObjectMetadata.storeHeaders()))).headers(headers -> headers.setAll(HeaderUtil.userMetadataHeadersFrom(s3ObjectMetadata)))).headers(headers -> headers.setAll(s3ObjectMetadata.encryptionHeaders()))).headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata)))).lastModified(s3ObjectMetadata.lastModified())).contentLength(Long.parseLong(s3ObjectMetadata.size())).contentType(HeaderUtil.mediaTypeFrom(s3ObjectMetadata.contentType())).build();
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
    }

    @DeleteMapping(value={"/{bucketName:.+}/{*key}"}, params={"!lifecycle"})
    public ResponseEntity<Void> deleteObject(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        boolean deleted = this.objectService.deleteObject(bucketName, key.key());
        return ResponseEntity.noContent().header("x-amz-delete-marker", new String[]{String.valueOf(deleted)}).build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"!uploads", "!uploadId", "!tagging", "!legal-hold", "!retention", "!acl", "!attributes"})
    public ResponseEntity<StreamingResponseBody> getObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="Range", required=false) HttpRange range, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch, @RequestParam Map<String, String> queryParams) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key());
        this.objectService.verifyObjectMatching(match, noneMatch, s3ObjectMetadata);
        if (range != null) {
            return this.getObjectWithRange(range, s3ObjectMetadata);
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).header("Accept-Ranges", new String[]{RANGES_BYTES})).headers(headers -> headers.setAll(s3ObjectMetadata.storeHeaders()))).headers(headers -> headers.setAll(HeaderUtil.userMetadataHeadersFrom(s3ObjectMetadata)))).headers(headers -> headers.setAll(s3ObjectMetadata.encryptionHeaders()))).headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata)))).lastModified(s3ObjectMetadata.lastModified())).contentLength(Long.parseLong(s3ObjectMetadata.size())).contentType(HeaderUtil.mediaTypeFrom(s3ObjectMetadata.contentType())).headers(headers -> headers.setAll(HeaderUtil.overrideHeadersFrom(queryParams)))).body(outputStream -> Files.copy(s3ObjectMetadata.dataPath(), outputStream));
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"acl"}, consumes={"application/xml"})
    public ResponseEntity<Void> putObjectAcl(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody String body) throws XMLStreamException, JAXBException {
        this.bucketService.verifyBucketExists(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.key());
        AccessControlPolicy policy = XmlUtil.deserializeJaxb(body);
        this.objectService.setAcl(bucketName, key.key(), policy);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"acl"}, produces={"application/xml"})
    public ResponseEntity<String> getObjectAcl(@PathVariable String bucketName, @PathVariable ObjectKey key) throws JAXBException {
        this.bucketService.verifyBucketExists(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.key());
        AccessControlPolicy acl = this.objectService.getAcl(bucketName, key.key());
        return ResponseEntity.ok((Object)XmlUtil.serializeJaxb(acl));
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"}, produces={"application/xml", "application/xml;charset=UTF-8"})
    public ResponseEntity<Tagging> getObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).lastModified(s3ObjectMetadata.lastModified())).body((Object)new Tagging(new TagSet(s3ObjectMetadata.tags())));
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"}, consumes={"application/xml"})
    public ResponseEntity<Void> putObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody Tagging body) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key());
        this.objectService.setObjectTags(bucketName, key.key(), body.tagSet().tags());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).lastModified(s3ObjectMetadata.lastModified())).build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"legal-hold"}, produces={"application/xml"})
    public ResponseEntity<LegalHold> getLegalHold(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectLockConfiguration(bucketName, key.key());
        return ResponseEntity.ok().body((Object)s3ObjectMetadata.legalHold());
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"legal-hold"}, consumes={"application/xml"})
    public ResponseEntity<Void> putLegalHold(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody LegalHold body) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.key());
        this.objectService.setLegalHold(bucketName, key.key(), body);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"retention"}, produces={"application/xml"})
    public ResponseEntity<Retention> getObjectRetention(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectLockConfiguration(bucketName, key.key());
        return ResponseEntity.ok().body((Object)s3ObjectMetadata.retention());
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"retention"}, consumes={"application/xml"})
    public ResponseEntity<Void> putObjectRetention(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody Retention body) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.key());
        this.objectService.verifyRetention(body);
        this.objectService.setRetention(bucketName, key.key(), body);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/{bucketName:[a-z0-9.-]+}/{*key}"}, params={"attributes"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<GetObjectAttributesOutput> getObjectAttributes(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch, @RequestHeader(value="x-amz-object-attributes") List<String> objectAttributes) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key());
        this.objectService.verifyObjectMatching(match, noneMatch, s3ObjectMetadata);
        GetObjectAttributesOutput response = new GetObjectAttributesOutput(ObjectService.getChecksum(s3ObjectMetadata), objectAttributes.contains(ObjectAttributes.ETAG.toString()) ? s3ObjectMetadata.etag() : null, null, objectAttributes.contains(ObjectAttributes.OBJECT_SIZE.toString()) ? Long.valueOf(Long.parseLong(s3ObjectMetadata.size())) : null, objectAttributes.contains(ObjectAttributes.STORAGE_CLASS.toString()) ? StorageClass.STANDARD : null);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().lastModified(s3ObjectMetadata.lastModified())).body((Object)response);
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, headers={"!x-amz-copy-source"})
    public ResponseEntity<Void> putObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(name="x-amz-tagging", required=false) List<Tag> tags, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Content-MD5", required=false) String contentMd5, @RequestHeader(value="x-amz-content-sha256", required=false) String sha256Header, @RequestHeader HttpHeaders httpHeaders, InputStream inputStream) {
        this.bucketService.verifyBucketExists(bucketName);
        InputStream stream = this.objectService.verifyMd5(inputStream, contentMd5, sha256Header);
        Owner owner = Owner.DEFAULT_OWNER;
        S3ObjectMetadata s3ObjectMetadata = this.objectService.putS3Object(bucketName, key.key(), HeaderUtil.mediaTypeFrom(contentType).toString(), HeaderUtil.storeHeadersFrom(httpHeaders), stream, HeaderUtil.isV4ChunkedWithSigningEnabled(sha256Header), HeaderUtil.userMetadataFrom(httpHeaders), HeaderUtil.encryptionHeadersFrom(httpHeaders), tags, HeaderUtil.checksumAlgorithmFrom(httpHeaders), HeaderUtil.checksumFrom(httpHeaders), owner);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata)))).headers(h -> h.setAll(s3ObjectMetadata.encryptionHeaders()))).lastModified(s3ObjectMetadata.lastModified())).eTag(s3ObjectMetadata.etag())).build();
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, headers={"x-amz-copy-source"}, params={"!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, produces={"application/xml"})
    public ResponseEntity<CopyObjectResult> copyObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-copy-source") CopySource copySource, @RequestHeader(value="x-amz-metadata-directive", defaultValue="COPY") AwsHttpHeaders.MetadataDirective metadataDirective, @RequestHeader(value="x-amz-copy-source-if-match", required=false) List<String> match, @RequestHeader(value="x-amz-copy-source-if-none-match", required=false) List<String> noneMatch, @RequestHeader HttpHeaders httpHeaders) {
        CopyObjectResult copyObjectResult;
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(copySource.bucket(), copySource.key());
        this.objectService.verifyObjectMatchingForCopy(match, noneMatch, s3ObjectMetadata);
        Map<String, String> metadata = Collections.emptyMap();
        if (AwsHttpHeaders.MetadataDirective.REPLACE == metadataDirective) {
            metadata = HeaderUtil.userMetadataFrom(httpHeaders);
        }
        if ((copyObjectResult = this.objectService.copyS3Object(copySource.bucket(), copySource.key(), bucketName, key.key(), HeaderUtil.encryptionHeadersFrom(httpHeaders), metadata)) == null) {
            return ResponseEntity.notFound().headers(headers -> headers.setAll(s3ObjectMetadata.encryptionHeaders())).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers -> headers.setAll(s3ObjectMetadata.encryptionHeaders()))).body((Object)copyObjectResult);
    }

    private ResponseEntity<StreamingResponseBody> getObjectWithRange(HttpRange range, S3ObjectMetadata s3ObjectMetadata) {
        long fileSize = s3ObjectMetadata.dataPath().toFile().length();
        long bytesToRead = Math.min(fileSize - 1L, range.getRangeEnd(fileSize)) - range.getRangeStart(fileSize) + 1L;
        if (bytesToRead < 0L || fileSize < range.getRangeStart(fileSize)) {
            return ResponseEntity.status((int)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value()).build();
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((int)HttpStatus.PARTIAL_CONTENT.value()).headers(headers -> headers.setAll(HeaderUtil.userMetadataHeadersFrom(s3ObjectMetadata)))).headers(headers -> headers.setAll(s3ObjectMetadata.storeHeaders()))).headers(headers -> headers.setAll(s3ObjectMetadata.encryptionHeaders()))).header("Accept-Ranges", new String[]{RANGES_BYTES})).header("Content-Range", new String[]{String.format("bytes %s-%s/%s", range.getRangeStart(fileSize), bytesToRead + range.getRangeStart(fileSize) - 1L, s3ObjectMetadata.size())})).eTag(s3ObjectMetadata.etag())).contentType(HeaderUtil.mediaTypeFrom(s3ObjectMetadata.contentType())).lastModified(s3ObjectMetadata.lastModified())).contentLength(bytesToRead).body(outputStream -> ObjectController.extractBytesToOutputStream(range, s3ObjectMetadata, outputStream, fileSize, bytesToRead));
    }

    private static void extractBytesToOutputStream(HttpRange range, S3ObjectMetadata s3ObjectMetadata, OutputStream outputStream, long fileSize, long bytesToRead) throws IOException {
        block7: {
            try (InputStream fis = Files.newInputStream(s3ObjectMetadata.dataPath(), new OpenOption[0]);){
                long skip = fis.skip(range.getRangeStart(fileSize));
                if (skip == range.getRangeStart(fileSize)) {
                    IOUtils.copy((InputStream)new BoundedInputStream(fis, bytesToRead), (OutputStream)outputStream);
                    break block7;
                }
                throw new IllegalStateException("Could not skip exact byte range");
            }
        }
    }
}

