/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;

public final class HeaderUtil {
    private static final String RESPONSE_HEADER_CONTENT_TYPE = "response-content-type";
    private static final String RESPONSE_HEADER_CONTENT_LANGUAGE = "response-content-language";
    private static final String RESPONSE_HEADER_EXPIRES = "response-expires";
    private static final String RESPONSE_HEADER_CACHE_CONTROL = "response-cache-control";
    private static final String RESPONSE_HEADER_CONTENT_DISPOSITION = "response-content-disposition";
    private static final String RESPONSE_HEADER_CONTENT_ENCODING = "response-content-encoding";
    private static final String HEADER_X_AMZ_META_PREFIX = "x-amz-meta-";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD_TRAILER = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD-TRAILER";
    private static final MediaType FALLBACK_MEDIA_TYPE = new MediaType("binary", "octet-stream");

    public static Map<String, String> userMetadataHeadersFrom(S3ObjectMetadata s3ObjectMetadata) {
        HashMap<String, String> metadataHeaders = new HashMap<String, String>();
        if (s3ObjectMetadata.getUserMetadata() != null) {
            s3ObjectMetadata.getUserMetadata().forEach((key, value) -> {
                if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)HEADER_X_AMZ_META_PREFIX)) {
                    metadataHeaders.put((String)key, (String)value);
                } else {
                    metadataHeaders.put(HEADER_X_AMZ_META_PREFIX + key, (String)value);
                }
            });
        }
        return metadataHeaders;
    }

    public static Map<String, String> userMetadataFrom(HttpHeaders headers) {
        return HeaderUtil.parseHeadersToMap(headers, header -> StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)HEADER_X_AMZ_META_PREFIX));
    }

    public static Map<String, String> storeHeadersFrom(HttpHeaders headers) {
        return HeaderUtil.parseHeadersToMap(headers, header -> StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Expires") || StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Content-Language") || StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Content-Disposition") || StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Content-Encoding") || StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Cache-Control"));
    }

    public static Map<String, String> encryptionHeadersFrom(HttpHeaders headers) {
        return HeaderUtil.parseHeadersToMap(headers, header -> StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)"x-amz-server-side-encryption"));
    }

    private static Map<String, String> parseHeadersToMap(HttpHeaders headers, Predicate<String> matcher) {
        return headers.entrySet().stream().map(entry -> {
            if (matcher.test((String)entry.getKey()) && entry.getValue() != null && !((List)entry.getValue()).isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)((List)entry.getValue()).get(0)))) {
                return new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public static boolean isV4ChunkedWithSigningEnabled(String sha256Header) {
        return sha256Header != null && (sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD) || sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD_TRAILER));
    }

    public static MediaType mediaTypeFrom(String contentType) {
        try {
            return MediaType.parseMediaType((String)contentType);
        }
        catch (InvalidMediaTypeException e) {
            return FALLBACK_MEDIA_TYPE;
        }
    }

    public static Map<String, String> overrideHeadersFrom(Map<String, String> queryParams) {
        return queryParams.entrySet().stream().map(entry -> {
            if (StringUtils.isNotBlank((CharSequence)HeaderUtil.mapHeaderName((String)entry.getKey()))) {
                return new AbstractMap.SimpleEntry<String, String>(HeaderUtil.mapHeaderName((String)entry.getKey()), (String)entry.getValue());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public static Map<String, String> checksumHeaderFrom(S3ObjectMetadata s3ObjectMetadata) {
        HashMap<String, String> headers = new HashMap<String, String>();
        ChecksumAlgorithm checksumAlgorithm = s3ObjectMetadata.getChecksumAlgorithm();
        if (checksumAlgorithm != null) {
            headers.put(HeaderUtil.mapChecksumToHeader(checksumAlgorithm), s3ObjectMetadata.getChecksum());
        }
        return headers;
    }

    public static ChecksumAlgorithm checksumAlgorithmFrom(HttpHeaders headers) {
        if (headers.containsKey((Object)"x-amz-sdk-checksum-algorithm")) {
            return ChecksumAlgorithm.fromString(headers.getFirst("x-amz-sdk-checksum-algorithm"));
        }
        if (headers.containsKey((Object)"x-amz-checksum-sha256")) {
            return ChecksumAlgorithm.SHA256;
        }
        if (headers.containsKey((Object)"x-amz-checksum-sha1")) {
            return ChecksumAlgorithm.SHA1;
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32")) {
            return ChecksumAlgorithm.CRC32;
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32c")) {
            return ChecksumAlgorithm.CRC32C;
        }
        return null;
    }

    public static String checksumFrom(HttpHeaders headers) {
        if (headers.containsKey((Object)"x-amz-checksum-sha256")) {
            return headers.getFirst("x-amz-checksum-sha256");
        }
        if (headers.containsKey((Object)"x-amz-checksum-sha1")) {
            return headers.getFirst("x-amz-checksum-sha1");
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32")) {
            return headers.getFirst("x-amz-checksum-crc32");
        }
        if (headers.containsKey((Object)"x-amz-checksum-crc32c")) {
            return headers.getFirst("x-amz-checksum-crc32c");
        }
        return null;
    }

    private static String mapChecksumToHeader(ChecksumAlgorithm checksumAlgorithm) {
        switch (checksumAlgorithm) {
            case SHA256: {
                return "x-amz-checksum-sha256";
            }
            case SHA1: {
                return "x-amz-checksum-sha1";
            }
            case CRC32: {
                return "x-amz-checksum-crc32";
            }
            case CRC32C: {
                return "x-amz-checksum-crc32c";
            }
        }
        return null;
    }

    private static String mapHeaderName(String name) {
        switch (name) {
            case "response-cache-control": {
                return "Cache-Control";
            }
            case "response-content-disposition": {
                return "Content-Disposition";
            }
            case "response-content-encoding": {
                return "Content-Encoding";
            }
            case "response-content-language": {
                return "Content-Language";
            }
            case "response-content-type": {
                return "Content-Type";
            }
            case "response-expires": {
                return "Expires";
            }
        }
        return "";
    }
}

