/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

abstract class AbstractAwsInputStream
extends InputStream {
    protected static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    protected static final byte[] DELIMITER = ";".getBytes(StandardCharsets.UTF_8);
    protected final InputStream source;
    protected long payloadLength = 0L;
    private static final int MAX_CHUNK_SIZE = 262144;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(262144);

    protected AbstractAwsInputStream(InputStream source) {
        this.source = new BufferedInputStream(source);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    protected byte[] readUntil(byte[] endSequence) throws IOException {
        this.byteBuffer.clear();
        while (!this.endsWith(this.byteBuffer.asReadOnlyBuffer(), endSequence)) {
            int c = this.source.read();
            if (c < 0) {
                return new byte[0];
            }
            byte unsigned = (byte)(c & 0xFF);
            this.byteBuffer.put(unsigned);
        }
        byte[] result = new byte[this.byteBuffer.position() - endSequence.length];
        this.byteBuffer.rewind();
        this.byteBuffer.get(result);
        return result;
    }

    protected boolean endsWith(ByteBuffer buffer, byte[] endSequence) {
        int pos = buffer.position();
        if (pos >= endSequence.length) {
            for (int i = 0; i < endSequence.length; ++i) {
                if (buffer.get(pos - endSequence.length + i) == endSequence[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setPayloadLength(byte[] hexLengthBytes) {
        this.payloadLength = Long.parseLong(new String(hexLengthBytes, StandardCharsets.UTF_8).trim(), 16);
    }
}

