/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.CompletedPart;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.MultipartUploadInfo;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.DigestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRange;

public class MultipartStore {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartStore.class);
    private static final String PART_SUFFIX = ".part";
    private final Map<String, MultipartUploadInfo> uploadIdToInfo = new ConcurrentHashMap<String, MultipartUploadInfo>();
    private final boolean retainFilesOnExit;
    private final ObjectStore objectStore;

    public MultipartStore(boolean retainFilesOnExit, ObjectStore objectStore) {
        this.retainFilesOnExit = retainFilesOnExit;
        this.objectStore = objectStore;
    }

    public MultipartUpload prepareMultipartUpload(BucketMetadata bucket, String key, UUID id, String contentType, Map<String, String> storeHeaders, String uploadId, Owner owner, Owner initiator, Map<String, String> userMetadata, Map<String, String> encryptionHeaders) {
        if (!this.createPartsFolder(bucket, id, uploadId)) {
            LOG.error("Directories for storing multipart uploads couldn't be created. bucket={}, key={}, id={}, uploadId={}", new Object[]{bucket, key, id, uploadId});
            throw new IllegalStateException("Directories for storing multipart uploads couldn't be created.");
        }
        MultipartUpload upload = new MultipartUpload(key, uploadId, owner, initiator, new Date());
        this.uploadIdToInfo.put(uploadId, new MultipartUploadInfo(upload, contentType, storeHeaders, userMetadata, bucket.getName(), encryptionHeaders));
        return upload;
    }

    public List<MultipartUpload> listMultipartUploads(String bucketName, String prefix) {
        return this.uploadIdToInfo.values().stream().filter(info -> bucketName == null || bucketName.equals(info.bucket)).filter(info -> StringUtils.isBlank((CharSequence)prefix) || info.upload.getKey().startsWith(prefix)).map(info -> info.upload).collect(Collectors.toList());
    }

    public MultipartUpload getMultipartUpload(String uploadId) {
        return this.uploadIdToInfo.values().stream().filter(info -> uploadId.equals(info.upload.getUploadId())).map(info -> info.upload).findFirst().orElseThrow(() -> new IllegalArgumentException("No MultipartUpload found with uploadId: " + uploadId));
    }

    public void abortMultipartUpload(BucketMetadata bucket, UUID id, String uploadId) {
        this.synchronizedUpload(uploadId, uploadInfo -> {
            try {
                File partFolder = this.getPartsFolderPath(bucket, id, uploadId).toFile();
                FileUtils.deleteDirectory((File)partFolder);
                File dataFile = this.objectStore.getDataFilePath(bucket, id).toFile();
                FileUtils.deleteQuietly((File)dataFile);
                this.uploadIdToInfo.remove(uploadId);
                return null;
            }
            catch (IOException e) {
                LOG.error("Could not delete multipart upload tmp data. bucket={}, id={}, uploadId={}", new Object[]{bucket, id, uploadId, e});
                throw new IllegalStateException("Could not delete multipart upload tmp data.", e);
            }
        });
    }

    public String putPart(BucketMetadata bucket, UUID id, String uploadId, String partNumber, InputStream inputStream, boolean useV4ChunkedWithSigningFormat, Map<String, String> encryptionHeaders) {
        File file = this.objectStore.inputStreamToFile(this.objectStore.wrapStream(inputStream, useV4ChunkedWithSigningFormat, false), this.getPartPath(bucket, id, uploadId, partNumber));
        return DigestUtil.hexDigest(encryptionHeaders.get("x-amz-server-side-encryption-aws-kms-key-id"), file);
    }

    public String completeMultipartUpload(BucketMetadata bucket, String key, UUID id, String uploadId, List<CompletedPart> parts, Map<String, String> encryptionHeaders) {
        return this.synchronizedUpload(uploadId, uploadInfo -> {
            String string;
            block8: {
                Path partFolder = this.getPartsFolderPath(bucket, id, uploadId);
                List<Path> partsPaths = parts.stream().map(part -> Paths.get(partFolder.toString(), part.getPartNumber() + PART_SUFFIX)).collect(Collectors.toList());
                InputStream inputStream = MultipartStore.toInputStream(partsPaths);
                try {
                    String etag = DigestUtil.hexDigestMultipart(partsPaths);
                    this.objectStore.storeS3ObjectMetadata(bucket, id, key, uploadInfo.contentType, uploadInfo.storeHeaders, inputStream, false, uploadInfo.userMetadata, encryptionHeaders, etag, Collections.emptyList(), null, null, Owner.DEFAULT_OWNER);
                    this.uploadIdToInfo.remove(uploadId);
                    FileUtils.deleteDirectory((File)partFolder.toFile());
                    string = etag;
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error("Error finishing multipart upload bucket={}, key={}, id={}, uploadId={}", new Object[]{bucket, key, id, uploadId, e});
                        throw new IllegalStateException("Error finishing multipart upload.", e);
                    }
                }
                inputStream.close();
            }
            return string;
        });
    }

    public List<Part> getMultipartUploadParts(BucketMetadata bucket, UUID id, String uploadId) {
        List<Part> list;
        block8: {
            Path partsPath = this.getPartsFolderPath(bucket, id, uploadId);
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(partsPath, path -> path.getFileName().toString().endsWith(PART_SUFFIX));
            try {
                list = StreamSupport.stream(directoryStream.spliterator(), false).map(path -> {
                    String name = path.getFileName().toString();
                    String prefix = name.substring(0, name.indexOf(46));
                    int partNumber = Integer.parseInt(prefix);
                    String partMd5 = DigestUtil.hexDigest(path.toFile());
                    Date lastModified = new Date(path.toFile().lastModified());
                    return new Part(partNumber, partMd5, lastModified, path.toFile().length());
                }).sorted(Comparator.comparing(CompletedPart::getPartNumber)).collect(Collectors.toList());
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Could not read all parts. bucket={}, id={}, uploadId={}", new Object[]{bucket, id, uploadId, e});
                    throw new IllegalStateException("Could not read all parts.", e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    public String copyPart(BucketMetadata bucket, UUID id, HttpRange copyRange, String partNumber, BucketMetadata destinationBucket, UUID destinationId, String uploadId, Map<String, String> encryptionHeaders) {
        this.verifyMultipartUploadPreparation(destinationBucket, destinationId, uploadId);
        return this.copyPartToFile(bucket, id, copyRange, this.createPartFile(destinationBucket, destinationId, uploadId, partNumber));
    }

    private static InputStream toInputStream(List<Path> paths) {
        Vector<InputStream> result = new Vector<InputStream>();
        for (Path path : paths) {
            try {
                result.add(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't access path " + path, e);
            }
        }
        return new SequenceInputStream(result.elements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T synchronizedUpload(String uploadId, Function<MultipartUploadInfo, T> callback) {
        MultipartUploadInfo uploadInfo = this.uploadIdToInfo.get(uploadId);
        if (uploadInfo == null) {
            throw new IllegalArgumentException("Unknown upload " + uploadId);
        }
        MultipartUploadInfo multipartUploadInfo = uploadInfo;
        synchronized (multipartUploadInfo) {
            if (!this.uploadIdToInfo.containsKey(uploadId)) {
                LOG.error("Upload was aborted or completed concurrently. uploadId={}", (Object)uploadId);
                throw new IllegalStateException("Upload was aborted or completed concurrently. uploadId=" + uploadId);
            }
            return callback.apply(uploadInfo);
        }
    }

    private String copyPartToFile(BucketMetadata bucket, UUID id, HttpRange copyRange, File partFile) {
        block16: {
            long from = 0L;
            S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucket, id);
            long len = s3ObjectMetadata.getDataPath().toFile().length();
            if (copyRange != null) {
                from = copyRange.getRangeStart(len);
                len = copyRange.getRangeEnd(len) - copyRange.getRangeStart(len) + 1L;
            }
            try (FileInputStream sourceStream = FileUtils.openInputStream((File)s3ObjectMetadata.getDataPath().toFile());
                 OutputStream targetStream = Files.newOutputStream(partFile.toPath(), new OpenOption[0]);){
                long skip = ((InputStream)sourceStream).skip(from);
                if (skip == from) {
                    IOUtils.copy((InputStream)new BoundedInputStream((InputStream)sourceStream, len), (OutputStream)targetStream);
                    break block16;
                }
                throw new IllegalStateException("Could not skip exact byte range");
            }
            catch (IOException e) {
                LOG.error("Could not copy object. bucket={}, id={}, range={}, partFile={}", new Object[]{bucket, id, copyRange, partFile, e});
                throw new IllegalStateException("Could not copy object", e);
            }
        }
        return DigestUtil.hexDigest(partFile);
    }

    private File createPartFile(BucketMetadata bucket, UUID id, String uploadId, String partNumber) {
        if (id == null) {
            return null;
        }
        File partFile = this.getPartPath(bucket, id, uploadId, partNumber).toFile();
        try {
            if (!partFile.exists() && !partFile.createNewFile()) {
                LOG.error("Could not create buffer file. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucket, id, uploadId, partNumber});
                throw new IllegalStateException("Could not create buffer file.");
            }
        }
        catch (IOException e) {
            LOG.error("Could not create buffer file. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucket, id, uploadId, partNumber, e});
            throw new IllegalStateException("Could not create buffer file.", e);
        }
        return partFile;
    }

    private void verifyMultipartUploadPreparation(BucketMetadata bucket, UUID id, String uploadId) {
        Path partsFolder = null;
        MultipartUploadInfo multipartUploadInfo = this.uploadIdToInfo.get(uploadId);
        if (id != null) {
            partsFolder = this.getPartsFolderPath(bucket, id, uploadId);
        }
        if (multipartUploadInfo == null || partsFolder == null || !partsFolder.toFile().exists() || !partsFolder.toFile().isDirectory()) {
            LOG.error("Multipart Request was not prepared. bucket={}, id={}, uploadId={}, partsFolder={}", new Object[]{bucket, id, uploadId, partsFolder});
            throw new IllegalStateException("Missed preparing Multipart Request.");
        }
    }

    private boolean createPartsFolder(BucketMetadata bucket, UUID id, String uploadId) {
        File partsFolder = this.getPartsFolderPath(bucket, id, uploadId).toFile();
        if (!this.retainFilesOnExit) {
            partsFolder.deleteOnExit();
        }
        return partsFolder.mkdirs();
    }

    private Path getPartsFolderPath(BucketMetadata bucket, UUID id, String uploadId) {
        return Paths.get(bucket.getPath().toString(), id.toString(), uploadId);
    }

    private Path getPartPath(BucketMetadata bucket, UUID id, String uploadId, String partNumber) {
        return Paths.get(this.getPartsFolderPath(bucket, id, uploadId).toString(), partNumber + PART_SUFFIX);
    }
}

