/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont1;
import flash.swf.tags.DefineFont2;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineFont4;
import flash.swf.tags.DefineSound;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.util.Trace;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.NetworkFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class AbstractTranscoder
implements Transcoder {
    private static final String CODEGEN_TEMPLATE_PATH = "flex2/compiler/as3/";
    public static final String SCALE9TOP = "scaleGridTop";
    public static final String SCALE9LEFT = "scaleGridLeft";
    public static final String SCALE9BOTTOM = "scaleGridBottom";
    public static final String SCALE9RIGHT = "scaleGridRight";
    public static final String FONTSTYLE = "fontStyle";
    public static final String FONTWEIGHT = "fontWeight";
    public static final String FONTNAME = "fontName";
    public static final String FONTFAMILY = "fontFamily";
    protected String[] mimeTypes;
    protected Class defineTag;
    protected boolean cacheTags;
    protected Map transcodingCache = new HashMap();
    private static Map associatedClasses = new HashMap();
    public static final String SKIN_SPRITE = "mx.core.SpriteAsset";
    public static final String SKIN_MOVIECLIP = "mx.core.MovieClipAsset";
    public static final String SKIN_BITMAP = "mx.core.BitmapAsset";
    public static final String SKIN_BUTTON = "mx.core.ButtonAsset";
    public static final String SKIN_TEXTFIELD = "mx.core.TextFieldAsset";
    public static final String FONT = "mx.core.FontAsset";
    public static final String SOUND = "mx.core.SoundAsset";
    public static final String ASSET_TYPE = "flash.display.DisplayObject";

    public AbstractTranscoder(String[] mimeTypes, Class defineTag, boolean cacheTags) {
        this.mimeTypes = mimeTypes;
        this.defineTag = defineTag;
        this.cacheTags = cacheTags;
    }

    public boolean isSupported(String mimeType) {
        for (int i = 0; i < this.mimeTypes.length; ++i) {
            if (!this.mimeTypes[i].equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    public Transcoder.TranscodingResults transcode(PathResolver context, SymbolTable symbolTable, Map args, String className, boolean generateSource) throws TranscoderException {
        Iterator it = args.keySet().iterator();
        while (it.hasNext()) {
            String attr = (String)it.next();
            if (attr.startsWith("_") || "source".equalsIgnoreCase(attr) || "mimeType".equalsIgnoreCase(attr) || "exportSymbol".equalsIgnoreCase(attr) || "original".equals(attr) || this.isSupportedAttribute(attr)) continue;
            throw new UnsupportedAttribute(attr, this.getClass().getName());
        }
        String cacheKey = null;
        Transcoder.TranscodingResults results = null;
        if (this.cacheTags) {
            cacheKey = this.getCacheKey(args);
            results = (Transcoder.TranscodingResults)this.transcodingCache.get(cacheKey);
        }
        if (results == null) {
            results = this.doTranscode(context, symbolTable, args, className, generateSource);
            if (this.cacheTags) {
                cacheKey = this.getCacheKey(args);
                this.transcodingCache.put(cacheKey, results);
            }
        } else if (Trace.embed) {
            Trace.trace((String)("Found cached DefineTag for " + cacheKey));
        }
        return results;
    }

    private String getCacheKey(Map args) {
        TreeMap m = new TreeMap(args);
        String key = "" + m.hashCode();
        if (Trace.embed) {
            key = key + "_" + m.toString();
        }
        return key;
    }

    public VirtualFile resolve(PathResolver context, String path) throws TranscoderException {
        VirtualFile f;
        String p = path;
        if (path.startsWith("file:")) {
            p = p.substring("file:".length());
        }
        if ((f = context.resolve(p)) == null) {
            throw new UnableToResolve(path);
        }
        if (f instanceof NetworkFile) {
            throw new NetworkTranscodingSource(path);
        }
        return f;
    }

    public VirtualFile resolveSource(PathResolver context, Map args) throws TranscoderException {
        VirtualFile result = null;
        String resolvedSource = (String)args.get("_resolvedSource");
        if (resolvedSource != null) {
            result = ThreadLocalToolkit.getResolvedPath(resolvedSource);
        }
        if (result == null) {
            String source = (String)args.get("source");
            if (source == null) {
                throw new MissingSource();
            }
            result = this.resolve(context, source);
        }
        return result;
    }

    public abstract Transcoder.TranscodingResults doTranscode(PathResolver var1, SymbolTable var2, Map var3, String var4, boolean var5) throws TranscoderException;

    public abstract boolean isSupportedAttribute(String var1);

    public String getAssociatedClass(DefineTag tag) {
        if (tag == null) {
            return null;
        }
        String cls = (String)associatedClasses.get(tag.getClass().getName());
        if (cls != null && (this.defineTag == null || this.defineTag.isAssignableFrom(tag.getClass()))) {
            if (tag instanceof DefineSprite && ((DefineSprite)tag).framecount > 1 && cls.equals(SKIN_SPRITE)) {
                cls = SKIN_MOVIECLIP;
            }
            return cls;
        }
        if (this.defineTag == null) {
            if (Trace.embed) {
                Trace.trace((String)("Couldn't find a matching class, so associating " + tag + " with " + SKIN_SPRITE));
            }
            return SKIN_SPRITE;
        }
        return null;
    }

    public void clear() {
        if (this.transcodingCache.size() != 0) {
            this.transcodingCache = new HashMap();
        }
    }

    public void generateSource(Transcoder.TranscodingResults asset, String fullClassName, Map embedMap) throws TranscoderException {
        this.generateSource(asset, fullClassName, embedMap, new HashMap());
    }

    public void generateSource(Transcoder.TranscodingResults asset, String fullClassName, Map embedMap, Map embedProps) throws TranscoderException {
        String baseClassName = this.getAssociatedClass(asset.defineTag);
        String packageName = "";
        String className = fullClassName;
        int dot = fullClassName.lastIndexOf(46);
        if (dot != -1) {
            packageName = fullClassName.substring(0, dot);
            className = fullClassName.substring(dot + 1);
        }
        if (asset.assetSource != null) {
            String path = asset.assetSource.getName().replace('\\', '/');
            embedMap.put("_resolvedSource", path);
            ThreadLocalToolkit.addResolvedPath(path, asset.assetSource);
        }
        try {
            String templateName = "EmbedClass.vm";
            Template template = VelocityManager.getTemplate(CODEGEN_TEMPLATE_PATH + templateName);
            if (template == null) {
                throw new TemplateException(templateName);
            }
            VelocityContext velocityContext = VelocityManager.getCodeGenContext();
            velocityContext.put("packageName", (Object)packageName);
            velocityContext.put("baseClass", (Object)baseClassName);
            if (embedProps.size() != 0) {
                velocityContext.put("assetType", (Object)ASSET_TYPE);
            }
            velocityContext.put("embedClass", (Object)className);
            velocityContext.put("embedMap", (Object)embedMap);
            velocityContext.put("embedProps", (Object)embedProps);
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            asset.generatedCode = stringWriter.toString();
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            throw new UnableToGenerateSource(fullClassName);
        }
    }

    static {
        associatedClasses.put(DefineSprite.class.getName(), SKIN_SPRITE);
        associatedClasses.put(DefineBits.class.getName(), SKIN_BITMAP);
        associatedClasses.put(DefineBitsLossless.class.getName(), SKIN_BITMAP);
        associatedClasses.put(DefineFont.class.getName(), FONT);
        associatedClasses.put(DefineFont1.class.getName(), FONT);
        associatedClasses.put(DefineFont2.class.getName(), FONT);
        associatedClasses.put(DefineFont3.class.getName(), FONT);
        associatedClasses.put(DefineFont4.class.getName(), FONT);
        associatedClasses.put(DefineSound.class.getName(), SOUND);
        associatedClasses.put(DefineButton.class.getName(), SKIN_BUTTON);
        associatedClasses.put(DefineText.class.getName(), SKIN_TEXTFIELD);
    }

    public static final class IncompatibleTranscoderParameters
    extends TranscoderException {
        public String param1;
        public String param2;

        public IncompatibleTranscoderParameters(String param1, String param2) {
            this.param1 = param1;
            this.param2 = param2;
        }
    }

    public static class EmbedRequiresCodegen
    extends TranscoderException {
        public String source;
        public String className;

        public EmbedRequiresCodegen(String source, String className) {
            this.source = source;
            this.className = className;
        }
    }

    public static class ExceptionWhileTranscoding
    extends TranscoderException {
        public String exception;

        public ExceptionWhileTranscoding(Exception exception) {
            this.exception = exception.getMessage();
        }
    }

    public static class UnableToReadSource
    extends TranscoderException {
        public String source;

        public UnableToReadSource(String source) {
            this.source = source;
        }
    }

    public static class UnableToGenerateSource
    extends TranscoderException {
        public String className;

        public UnableToGenerateSource(String className) {
            this.className = className;
        }
    }

    public static class MissingSource
    extends TranscoderException {
    }

    public static class NetworkTranscodingSource
    extends TranscoderException {
        public String url;

        public NetworkTranscodingSource(String url) {
            this.url = url;
        }
    }

    public static class UnableToResolve
    extends TranscoderException {
        public String source;

        public UnableToResolve(String source) {
            this.source = source;
        }
    }

    public static class UnsupportedAttribute
    extends TranscoderException {
        public String attribute;
        public String mimeType;
        public String className;

        public UnsupportedAttribute(String attribute, String className) {
            this.attribute = attribute;
            this.className = className;
        }
    }

    public static class SourceException
    extends TranscoderException {
        public String className;

        public SourceException(String className) {
            this.className = className;
        }
    }

    public static class TemplateException
    extends TranscoderException {
        public String templateName;

        public TemplateException(String templateName) {
            this.templateName = templateName;
        }
    }
}

