/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.InProgressException;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import flash.util.IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoCache
implements Comparator<SourceFile> {
    Session m_session;
    IntMap m_byInt = new IntMap();
    SourceFile[] m_files = null;
    SwfInfo m_swfFilter = null;
    int m_swfsLoaded = 0;
    boolean m_dirty = false;

    public void bind(Session s) {
        this.setSession(s);
    }

    public void unbind() {
        this.m_session = null;
    }

    public SourceFile getFile(int i) {
        this.populate();
        return (SourceFile)this.m_byInt.get(i);
    }

    public SourceFile[] getFileList() {
        this.populate();
        return this.m_files;
    }

    public Iterator getAllFiles() {
        this.populate();
        return this.m_byInt.iterator();
    }

    public SwfInfo getSwfFilter() {
        return this.m_swfFilter;
    }

    public boolean isSwfFilterOn() {
        return this.m_swfFilter != null;
    }

    public void setDirty() {
        this.m_dirty = true;
    }

    void setSession(Session s) {
        this.m_session = s;
        this.m_swfFilter = null;
        this.clear();
    }

    void populate() {
        if (this.m_session != null && (this.m_dirty || this.getSwfs().length > this.m_swfsLoaded)) {
            this.reloadCache();
        }
    }

    void reloadCache() {
        this.clear();
        this.loadCache();
        this.m_dirty = false;
    }

    void clear() {
        this.m_byInt.clear();
        this.m_files = null;
    }

    public boolean inFileList(SourceFile f) {
        boolean isIt = false;
        SourceFile[] files = this.getFileList();
        for (int i = 0; i < files.length && !isIt; ++i) {
            if (files[i] != f) continue;
            isIt = true;
        }
        return isIt;
    }

    void loadCache() {
        boolean worked = true;
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        SwfInfo[] swfs = this.getSwfs();
        for (int i = 0; i < swfs.length; ++i) {
            if (swfs[i] == null) continue;
            worked = this.loadSwfFiles(files, swfs[i]) ? worked : false;
        }
        ArrayList<SourceFile> fa = this.trimFileList(files);
        this.m_files = fa.toArray(new SourceFile[fa.size()]);
        Arrays.sort(this.m_files, this);
        if (worked) {
            this.m_swfsLoaded = swfs.length;
        }
    }

    boolean loadSwfFiles(ArrayList<SourceFile> ar, SwfInfo swf) {
        boolean worked = true;
        try {
            SourceFile[] files = swf.getSourceList(this.m_session);
            ar.ensureCapacity(ar.size() + files.length);
            for (int i = 0; i < files.length; ++i) {
                this.putFile(files[i]);
                ar.add(files[i]);
            }
        }
        catch (InProgressException ipe) {
            worked = false;
        }
        return worked;
    }

    ArrayList<SourceFile> trimFileList(ArrayList<SourceFile> files) {
        HashMap<String, String> names = new HashMap<String, String>();
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            boolean addIt = false;
            SourceFile fi = files.get(i);
            String fName = fi.getRawName();
            if (this.m_swfFilter == null) {
                if (names.get(fName) == null) {
                    addIt = true;
                }
            } else {
                addIt = this.m_swfFilter.containsSource(fi);
            }
            if (!addIt) continue;
            names.put(fName, fName);
            list.add(fi);
        }
        return list;
    }

    void putFile(SourceFile s) {
        int i = s.getId();
        this.m_byInt.put(i, (Object)s);
    }

    public boolean setSwfFilter(String swfName) {
        boolean worked = false;
        if (swfName == null) {
            this.m_swfFilter = null;
            worked = true;
        } else {
            SwfInfo[] swfs = this.getSwfs();
            for (int i = 0; i < swfs.length; ++i) {
                SwfInfo e = swfs[i];
                if (e == null || !FileInfoCache.nameOfSwf(e).equalsIgnoreCase(swfName)) continue;
                worked = true;
                this.m_swfFilter = e;
                break;
            }
        }
        if (worked) {
            this.reloadCache();
        }
        return worked;
    }

    public SwfInfo[] getSwfs() {
        SwfInfo[] swfs = null;
        try {
            swfs = this.m_session.getSwfs();
        }
        catch (NoResponseException nre) {
            swfs = new SwfInfo[]{};
        }
        return swfs;
    }

    public SwfInfo swfForFile(SourceFile f) {
        int id = f.getId();
        SwfInfo info = null;
        SwfInfo[] swfs = this.getSwfs();
        for (int i = 0; i < swfs.length && info == null; ++i) {
            if (swfs[i] == null || !swfs[i].containsSource(f)) continue;
            info = swfs[i];
        }
        return info;
    }

    public static String nameOfSwf(SwfInfo e) {
        int at = -1;
        String name = e.getUrl();
        at = e.getUrl().lastIndexOf(47);
        if (at > -1) {
            name = e.getUrl().substring(at + 1);
        }
        if ((at = e.getUrl().lastIndexOf(92)) > -1) {
            name = e.getUrl().substring(at + 1);
        } else {
            at = e.getPath().lastIndexOf(92);
            if (at > -1) {
                name = e.getPath().substring(at + 1);
            } else {
                at = e.getPath().lastIndexOf(47);
                if (at > -1) {
                    name = e.getPath().substring(at + 1);
                }
            }
        }
        at = name.lastIndexOf(63);
        name = at > -1 ? name.substring(0, at) : name;
        return name;
    }

    public static String shortNameOfSwf(SwfInfo e) {
        String name = FileInfoCache.nameOfSwf(e);
        int at = -1;
        at = name.lastIndexOf(47);
        if (at > -1) {
            name = name.substring(at + 1);
        } else {
            at = name.lastIndexOf(92);
            if (at > -1) {
                name = name.substring(at + 1);
            }
        }
        return name;
    }

    public SourceFile similarFileInSwf(SwfInfo info, SourceFile f) throws InProgressException {
        SourceFile hit = null;
        SourceFile[] files = info.getSourceList(this.m_session);
        if (!info.isProcessingComplete()) {
            throw new InProgressException();
        }
        for (int i = 0; i < files.length; ++i) {
            if (!this.filesMatch(f, files[i])) continue;
            hit = files[i];
        }
        return hit;
    }

    @Override
    public int compare(SourceFile o1, SourceFile o2) {
        String n1 = o1.getName();
        String n2 = o2.getName();
        return n1.compareTo(n2);
    }

    public boolean filesMatch(SourceFile a, SourceFile b) {
        boolean yes = true;
        if (a == null || b == null) {
            yes = false;
        } else if (a.getPackageName().compareTo(b.getPackageName()) != 0) {
            yes = false;
        } else if (a.getName().compareTo(b.getName()) != 0) {
            yes = false;
        } else if (a.getLineCount() != b.getLineCount()) {
            yes = false;
        }
        return yes;
    }

    public SourceFile[] getFiles(String matchString) {
        boolean usePath;
        boolean doStartsWith = false;
        boolean doIndexOf = false;
        boolean doEndsWith = false;
        boolean leadingAsterisk = matchString.startsWith("*") && matchString.length() > 1;
        boolean trailingAsterisk = matchString.endsWith("*");
        boolean bl = usePath = matchString.indexOf(46) > -1;
        if (leadingAsterisk && trailingAsterisk) {
            matchString = matchString.substring(1, matchString.length() - 1);
            doIndexOf = true;
        } else if (leadingAsterisk) {
            matchString = matchString.substring(1);
            doEndsWith = true;
        } else if (trailingAsterisk) {
            matchString = matchString.substring(0, matchString.length() - 1);
            doStartsWith = true;
        } else if (usePath) {
            doIndexOf = true;
        } else {
            doStartsWith = true;
        }
        SourceFile[] files = this.getFileList();
        ArrayList<SourceFile> fileList = new ArrayList<SourceFile>();
        int n = files.length;
        int exactHitAt = -1;
        String dotMatchString = matchString.startsWith(".") ? matchString : "." + matchString;
        for (int i = 0; i < n; ++i) {
            SourceFile sourceFile = files[i];
            boolean pathExists = usePath && sourceFile.getFullPath().matches(".*[/\\\\].*");
            String name = pathExists ? sourceFile.getFullPath() : sourceFile.getName();
            String match = usePath && pathExists ? dotMatchString : matchString;
            name = name.replace('/', '.');
            if ((name = name.replace('\\', '.')).equals(match)) {
                exactHitAt = i;
                break;
            }
            if (doStartsWith && name.startsWith(match)) {
                fileList.add(sourceFile);
                continue;
            }
            if (doEndsWith && name.endsWith(match)) {
                fileList.add(sourceFile);
                continue;
            }
            if (!doIndexOf || name.indexOf(match) <= -1) continue;
            fileList.add(sourceFile);
        }
        if (exactHitAt > -1) {
            fileList.clear();
            fileList.add(files[exactHitAt]);
        }
        SourceFile[] fileArray = fileList.toArray(new SourceFile[fileList.size()]);
        Arrays.sort(fileArray, this);
        return fileArray;
    }
}

