/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.ProxyMap;

public class MapUtils {
    public static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    public static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    private static int debugIndent = 0;

    public static Object getObject(Map map, Object key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static String getString(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return new Boolean((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException e) {
                    MapUtils.logInfo(e);
                }
            }
        }
        return null;
    }

    public static Byte getByte(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Byte) {
            return (Byte)answer;
        }
        return new Byte(answer.byteValue());
    }

    public static Short getShort(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Short) {
            return (Short)answer;
        }
        return new Short(answer.shortValue());
    }

    public static Integer getInteger(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return new Integer(answer.intValue());
    }

    public static Long getLong(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return new Long(answer.longValue());
    }

    public static Float getFloat(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Float) {
            return (Float)answer;
        }
        return new Float(answer.floatValue());
    }

    public static Double getDouble(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return new Double(answer.doubleValue());
    }

    public static Map getMap(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null && answer instanceof Map) {
            return (Map)answer;
        }
        return null;
    }

    public static Object getObject(Map map, Object key, Object defaultValue) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer;
        }
        return defaultValue;
    }

    public static String getString(Map map, Object key, String defaultValue) {
        String answer = MapUtils.getString(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Boolean getBoolean(Map map, Object key, Boolean defaultValue) {
        Boolean answer = MapUtils.getBoolean(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Number getNumber(Map map, Object key, Number defaultValue) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Byte getByte(Map map, Object key, Byte defaultValue) {
        Byte answer = MapUtils.getByte(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Short getShort(Map map, Object key, Short defaultValue) {
        Short answer = MapUtils.getShort(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Integer getInteger(Map map, Object key, Integer defaultValue) {
        Integer answer = MapUtils.getInteger(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Long getLong(Map map, Object key, Long defaultValue) {
        Long answer = MapUtils.getLong(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Float getFloat(Map map, Object key, Float defaultValue) {
        Float answer = MapUtils.getFloat(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Double getDouble(Map map, Object key, Double defaultValue) {
        Double answer = MapUtils.getDouble(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Map getMap(Map map, Object key, Map defaultValue) {
        Map answer = MapUtils.getMap(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Properties toProperties(Map map) {
        Properties answer = new Properties();
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                answer.put(key, value);
            }
        }
        return answer;
    }

    public static synchronized void verbosePrint(PrintStream out, Object key, Map map) {
        MapUtils.debugPrintIndent(out);
        out.println(key + " = ");
        MapUtils.debugPrintIndent(out);
        out.println("{");
        ++debugIndent;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String childKey = (String)entry.getKey();
            Object childValue = entry.getValue();
            if (childValue instanceof Map) {
                MapUtils.verbosePrint(out, childKey, (Map)childValue);
                continue;
            }
            MapUtils.debugPrintIndent(out);
            out.println(childKey + " = " + childValue);
        }
        --debugIndent;
        MapUtils.debugPrintIndent(out);
        out.println("}");
    }

    public static synchronized void debugPrint(PrintStream out, Object key, Map map) {
        MapUtils.debugPrintIndent(out);
        out.println(key + " = ");
        MapUtils.debugPrintIndent(out);
        out.println("{");
        ++debugIndent;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String childKey = (String)entry.getKey();
            Object childValue = entry.getValue();
            if (childValue instanceof Map) {
                MapUtils.verbosePrint(out, childKey, (Map)childValue);
                continue;
            }
            MapUtils.debugPrintIndent(out);
            String typeName = childValue != null ? childValue.getClass().getName() : null;
            out.println(childKey + " = " + childValue + " class: " + typeName);
        }
        --debugIndent;
        MapUtils.debugPrintIndent(out);
        out.println("}");
    }

    protected static void debugPrintIndent(PrintStream out) {
        int i = 0;
        while (i < debugIndent) {
            out.print("    ");
            ++i;
        }
    }

    protected static void logInfo(Exception e) {
        System.out.println("INFO: Exception: " + e);
    }

    public static final void safeAddToMap(Map map, Object key, Object value) throws NullPointerException {
        if (value == null) {
            map.put(key, "");
        } else {
            map.put(key, value);
        }
    }

    public static Map synchronizedMap(Map map) {
        return Collections.synchronizedMap(map);
    }

    public static Map unmodifiableMap(Map map) {
        return Collections.unmodifiableMap(map);
    }

    public static Map predicatedMap(Map map, Predicate keyPred, Predicate valuePred) {
        return new PredicatedMap(map, keyPred, valuePred);
    }

    public static Map fixedSizeMap(Map map) {
        return new FixedSizeMap(map);
    }

    public static Map lazyMap(Map map, Factory factory) {
        return new LazyMap(map, factory);
    }

    public static Map synchronizedSortedMap(SortedMap map) {
        return Collections.synchronizedSortedMap(map);
    }

    public static Map unmodifiableSortedMap(SortedMap map) {
        return Collections.unmodifiableSortedMap(map);
    }

    public static SortedMap predicatedSortedMap(SortedMap map, Predicate keyPred, Predicate valuePred) {
        return new PredicatedSortedMap(map, keyPred, valuePred);
    }

    public static SortedMap fixedSizeSortedMap(SortedMap map) {
        return new FixedSizeSortedMap(map);
    }

    public static SortedMap lazySortedMap(SortedMap map, Factory factory) {
        return new LazySortedMap(map, factory);
    }

    static class LazySortedMap
    extends LazyMap
    implements SortedMap {
        public LazySortedMap(SortedMap m, Factory factory) {
            super(m, factory);
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object o1, Object o2) {
            return new LazySortedMap(this.getSortedMap().subMap(o1, o2), this.factory);
        }

        public SortedMap headMap(Object o1) {
            return new LazySortedMap(this.getSortedMap().headMap(o1), this.factory);
        }

        public SortedMap tailMap(Object o1) {
            return new LazySortedMap(this.getSortedMap().tailMap(o1), this.factory);
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }
    }

    static class FixedSizeSortedMap
    extends FixedSizeMap
    implements SortedMap {
        public FixedSizeSortedMap(SortedMap m) {
            super(m);
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object o1, Object o2) {
            return new FixedSizeSortedMap(this.getSortedMap().subMap(o1, o2));
        }

        public SortedMap headMap(Object o1) {
            return new FixedSizeSortedMap(this.getSortedMap().headMap(o1));
        }

        public SortedMap tailMap(Object o1) {
            return new FixedSizeSortedMap(this.getSortedMap().tailMap(o1));
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }
    }

    static class PredicatedSortedMap
    extends PredicatedMap
    implements SortedMap {
        public PredicatedSortedMap(SortedMap map, Predicate k, Predicate v) {
            super(map, k, v);
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object o1, Object o2) {
            SortedMap sub = this.getSortedMap().subMap(o1, o2);
            return new PredicatedSortedMap(sub, this.keyPredicate, this.valuePredicate);
        }

        public SortedMap headMap(Object o1) {
            SortedMap sub = this.getSortedMap().headMap(o1);
            return new PredicatedSortedMap(sub, this.keyPredicate, this.valuePredicate);
        }

        public SortedMap tailMap(Object o1) {
            SortedMap sub = this.getSortedMap().tailMap(o1);
            return new PredicatedSortedMap(sub, this.keyPredicate, this.valuePredicate);
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }
    }

    static class LazyMap
    extends ProxyMap {
        protected final Factory factory;

        public LazyMap(Map map, Factory factory) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
            if (factory == null) {
                throw new IllegalArgumentException("Factory must not be null");
            }
            this.factory = factory;
        }

        public Object get(Object key) {
            if (!this.map.containsKey(key)) {
                Object value = this.factory.create();
                this.map.put(key, value);
                return value;
            }
            return this.map.get(key);
        }
    }

    static class FixedSizeMap
    extends ProxyMap {
        public FixedSizeMap(Map map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
        }

        public Object put(Object key, Object value) {
            if (!this.map.containsKey(key)) {
                throw new IllegalArgumentException("Cannot put new key/value pair - List is fixed size");
            }
            return this.map.put(key, value);
        }

        public void putAll(Map m) {
            Iterator iter = m.keySet().iterator();
            while (iter.hasNext()) {
                if (this.map.containsKey(iter.next())) continue;
                throw new IllegalArgumentException("Cannot put new key/value pair - List is fixed size");
            }
            this.map.putAll(m);
        }
    }

    static class PredicatedMapEntry
    implements Map.Entry {
        private final Map.Entry entry;
        private final Predicate predicate;

        public PredicatedMapEntry(Map.Entry entry, Predicate p) {
            if (entry == null) {
                throw new IllegalArgumentException("Map.Entry must not be null");
            }
            if (p == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.entry = entry;
            this.predicate = p;
        }

        public boolean equals(Object o) {
            return this.entry.equals(o);
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public String toString() {
            return this.entry.toString();
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object o) {
            if (!this.predicate.evaluate(o)) {
                throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
            }
            return this.entry.setValue(o);
        }
    }

    static class PredicatedMapEntrySet
    extends CollectionUtils.CollectionWrapper
    implements Set {
        private final Predicate predicate;

        public PredicatedMapEntrySet(Set set, Predicate p) {
            super(set);
            this.predicate = p;
        }

        public Iterator iterator() {
            Iterator iterator = this.collection.iterator();
            return new Iterator(this, iterator){
                private final /* synthetic */ Iterator val$iterator;
                private final /* synthetic */ PredicatedMapEntrySet this$0;
                {
                    this.this$0 = this$0;
                    this.val$iterator = val$iterator;
                }

                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                public Object next() {
                    Map.Entry entry = (Map.Entry)this.val$iterator.next();
                    return new PredicatedMapEntry(entry, PredicatedMapEntrySet.access$000(this.this$0));
                }

                public void remove() {
                    this.val$iterator.remove();
                }
            };
        }

        static /* synthetic */ Predicate access$000(PredicatedMapEntrySet x0) {
            return x0.predicate;
        }
    }

    static class PredicatedMap
    extends ProxyMap {
        protected final Predicate keyPredicate;
        protected final Predicate valuePredicate;

        public PredicatedMap(Map map, Predicate keyPred, Predicate valuePred) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
            if (keyPred == null) {
                throw new IllegalArgumentException("Key Predicate must not be null");
            }
            if (valuePred == null) {
                throw new IllegalArgumentException("Value Predicate must not be null");
            }
            this.keyPredicate = keyPred;
            this.valuePredicate = valuePred;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.validate(key, value);
            }
        }

        public Object put(Object key, Object value) {
            this.validate(key, value);
            return this.map.put(key, value);
        }

        public void putAll(Map m) {
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.validate(key, value);
            }
            this.map.putAll(m);
        }

        public Set entrySet() {
            return new PredicatedMapEntrySet(this.map.entrySet(), this.valuePredicate);
        }

        private void validate(Object key, Object value) {
            if (!this.keyPredicate.evaluate(key)) {
                throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
            }
            if (!this.valuePredicate.evaluate(value)) {
                throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
            }
        }
    }
}

