/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGTransformList;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGTransformList;

public class SVGOMAnimatedTransformList
implements SVGAnimatedTransformList,
LiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean changing;
    protected AbstractSVGTransformList transformList;
    protected String defaultValue;

    public SVGOMAnimatedTransformList(AbstractElement elt, String ns, String ln, String defaultValue) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
        this.defaultValue = defaultValue;
    }

    public SVGTransformList getBaseVal() {
        if (this.transformList == null) {
            this.transformList = new SVGOMTransformList();
        }
        return this.transformList;
    }

    public SVGTransformList getAnimVal() {
        throw new RuntimeException("TODO :  getAnimVal() !!");
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.transformList != null) {
            this.transformList.invalidate();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.transformList != null) {
            this.transformList.invalidate();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.transformList != null) {
            this.transformList.invalidate();
        }
    }

    public class SVGOMTransformList
    extends AbstractSVGTransformList {
        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(type, key, args);
        }

        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(type, key, args);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedTransformList.this.element.getAttributeNodeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedTransformList.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAttributeValue(String value) {
            try {
                SVGOMAnimatedTransformList.this.changing = true;
                SVGOMAnimatedTransformList.this.element.setAttributeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName, value);
            }
            finally {
                SVGOMAnimatedTransformList.this.changing = false;
            }
        }
    }
}

