/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedPathData;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGOMAnimatedPathData
implements SVGAnimatedPathData,
LiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean changing;
    protected AbstractSVGPathSegList pathSegs;
    protected String defaultValue;

    public SVGOMAnimatedPathData(AbstractElement elt, String ns, String ln, String defaultValue) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
        this.defaultValue = defaultValue;
    }

    public SVGPathSegList getAnimatedNormalizedPathSegList() {
        throw new RuntimeException("TODO :  getAnimatedNormalizedPathSegList() !!");
    }

    public SVGPathSegList getAnimatedPathSegList() {
        throw new RuntimeException("TODO :  getAnimatedPathSegList() !!");
    }

    public SVGPathSegList getNormalizedPathSegList() {
        throw new RuntimeException("TODO :  getNormalizedPathSegList() !!");
    }

    public SVGPathSegList getPathSegList() {
        if (this.pathSegs == null) {
            this.pathSegs = new SVGOMPathSegList();
        }
        return this.pathSegs;
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.pathSegs != null) {
            this.pathSegs.invalidate();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.pathSegs != null) {
            this.pathSegs.invalidate();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.pathSegs != null) {
            this.pathSegs.invalidate();
        }
    }

    public class SVGOMPathSegList
    extends AbstractSVGPathSegList {
        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedPathData.this.element.createDOMException(type, key, args);
        }

        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(type, key, args);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPathData.this.element.getAttributeNodeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPathData.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAttributeValue(String value) {
            try {
                SVGOMAnimatedPathData.this.changing = true;
                SVGOMAnimatedPathData.this.element.setAttributeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName, value);
            }
            finally {
                SVGOMAnimatedPathData.this.changing = false;
            }
        }
    }
}

