/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class ColorProfileManager
extends AbstractValueManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "color-profile";
    }

    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String s = lu.getStringValue().toLowerCase();
                if (s.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (s.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, s);
            }
            case 24: {
                return new URIValue(lu.getStringValue(), ColorProfileManager.resolveURI(engine.getCSSBaseURI(), lu.getStringValue()));
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    public Value createStringValue(short type, String value, CSSEngine engine) throws DOMException {
        switch (type) {
            case 21: {
                String s = value.toLowerCase();
                if (s.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (s.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, s);
            }
            case 20: {
                return new URIValue(value, ColorProfileManager.resolveURI(engine.getCSSBaseURI(), value));
            }
        }
        throw this.createInvalidStringTypeDOMException(type);
    }
}

