/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.CSSImportNode;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected List fontFaces = new LinkedList();
    CSSEngineUserAgent userAgent = null;
    protected CSSContext cssContext;
    protected Document document;
    protected URL documentURI;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected URL cssBaseURI;
    protected String alternateStyleSheet;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public List getFontFaces() {
        return this.fontFaces;
    }

    public static CSSStylableElement getParentCSSStylableElement(Element elt) {
        Element e = CSSEngine.getParentElement(elt);
        while (e != null) {
            if (e instanceof CSSStylableElement) {
                return (CSSStylableElement)e;
            }
            e = CSSEngine.getParentElement(e);
        }
        return null;
    }

    public static Element getParentElement(Element elt) {
        for (Node n = elt.getParentNode(); n != null; n = n.getParentNode()) {
            if ((n = CSSEngine.getLogicalParentNode(n)).getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Node getLogicalParentNode(Node parent) {
        Node node = parent;
        if (node != null) {
            if (node instanceof CSSImportedElementRoot) {
                return ((CSSImportedElementRoot)node).getCSSParentElement();
            }
            return node;
        }
        return null;
    }

    public static CSSImportedElementRoot getImportedChild(Node node) {
        if (node instanceof CSSImportNode) {
            CSSImportNode inode = (CSSImportNode)node;
            CSSImportedElementRoot r = inode.getCSSImportedElementRoot();
            return r;
        }
        return null;
    }

    protected CSSEngine(Document doc, URL uri, ExtendedParser p, ValueManager[] vm, ShorthandManager[] sm, String[] pe, String sns, String sln, String cns, String cln, boolean hints, String hintsNS, CSSContext ctx) {
        String pn;
        int i;
        this.document = doc;
        this.documentURI = uri;
        this.parser = p;
        this.pseudoElementNames = pe;
        this.styleNamespaceURI = sns;
        this.styleLocalName = sln;
        this.classNamespaceURI = cns;
        this.classLocalName = cln;
        this.cssContext = ctx;
        this.cssConditionFactory = new CSSConditionFactory(cns, cln, null, "id");
        int len = vm.length;
        this.indexes = new StringIntMap(len);
        this.valueManagers = vm;
        for (i = len - 1; i >= 0; --i) {
            pn = vm[i].getPropertyName();
            this.indexes.put(pn, i);
            if (this.fontSizeIndex == -1 && pn.equals("font-size")) {
                this.fontSizeIndex = i;
            }
            if (this.lineHeightIndex == -1 && pn.equals("line-height")) {
                this.lineHeightIndex = i;
            }
            if (this.colorIndex != -1 || !pn.equals("color")) continue;
            this.colorIndex = i;
        }
        len = sm.length;
        this.shorthandIndexes = new StringIntMap(len);
        this.shorthandManagers = sm;
        for (i = len - 1; i >= 0; --i) {
            this.shorthandIndexes.put(sm[i].getPropertyName(), i);
        }
        if (hints) {
            this.nonCSSPresentationalHints = new HashSet(vm.length + sm.length);
            this.nonCSSPresentationalHintsNamespaceURI = hintsNS;
            len = vm.length;
            for (i = 0; i < len; ++i) {
                pn = vm[i].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
            }
            len = sm.length;
            for (i = 0; i < len; ++i) {
                pn = sm[i].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            EventTarget et = (EventTarget)((Object)this.document);
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            et.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            et.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            et.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            et.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            et.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (int i2 = this.getNumberOfProperties() - 1; i2 >= 0; --i2) {
            this.ALL_PROPERTIES[i2] = i2;
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            EventTarget et = (EventTarget)((Object)this.document);
            et.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            et.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            et.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            et.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            et.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    private void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            CSSImportedElementRoot c;
            if (n.getNodeType() == 1) {
                this.disposeStyleMaps(n);
            }
            if ((c = CSSEngine.getImportedChild(n)) == null) continue;
            this.disposeStyleMaps(c);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String name) {
        return this.indexes.get(name);
    }

    public int getShorthandIndex(String name) {
        return this.shorthandIndexes.get(name);
    }

    public String getPropertyName(int idx) {
        return this.valueManagers[idx].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet ss) {
        this.userAgentStyleSheet = ss;
    }

    public void setUserStyleSheet(StyleSheet ss) {
        this.userStyleSheet = ss;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public void setMedia(String str) {
        try {
            this.media = this.parser.parseMedia(str);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String s = Messages.formatMessage("media.error", new Object[]{str, m});
            throw new DOMException(12, s);
        }
    }

    public void setAlternateStyleSheet(String str) {
        this.alternateStyleSheet = str;
    }

    public void importCascadedStyleMaps(Element src, CSSEngine srceng, Element dest) {
        if (src instanceof CSSStylableElement) {
            CSSStylableElement csrc = (CSSStylableElement)src;
            CSSStylableElement cdest = (CSSStylableElement)dest;
            StyleMap sm = srceng.getCascadedStyleMap(csrc, null);
            sm.setFixedCascadedStyle(true);
            cdest.setComputedStyleMap(null, sm);
            if (this.pseudoElementNames != null) {
                int len = this.pseudoElementNames.length;
                for (int i = 0; i < len; ++i) {
                    String pe = this.pseudoElementNames[i];
                    sm = srceng.getCascadedStyleMap(csrc, pe);
                    cdest.setComputedStyleMap(pe, sm);
                }
            }
        }
        Node dn = dest.getFirstChild();
        Node sn = src.getFirstChild();
        while (dn != null) {
            if (sn.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)sn, srceng, (Element)dn);
            }
            dn = dn.getNextSibling();
            sn = sn.getNextSibling();
        }
    }

    public URL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap getCascadedStyleMap(CSSStylableElement elt, String pseudo) {
        ArrayList rules;
        int props = this.getNumberOfProperties();
        final StyleMap result = new StyleMap(props);
        if (this.userAgentStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userAgentStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)0);
        }
        if (this.userStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)8192);
        }
        this.element = elt;
        try {
            String style;
            List snodes;
            int slen;
            ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                public void property(String pname, LexicalUnit lu, boolean important) {
                    int idx = CSSEngine.this.getPropertyIndex(pname);
                    if (idx != -1) {
                        ValueManager vm = CSSEngine.this.valueManagers[idx];
                        Value v = vm.createValue(lu, CSSEngine.this);
                        CSSEngine.this.putAuthorProperty(result, idx, v, important, (short)16384);
                        return;
                    }
                    idx = CSSEngine.this.getShorthandIndex(pname);
                    if (idx == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                }
            };
            if (this.nonCSSPresentationalHints != null) {
                NamedNodeMap attrs = elt.getAttributes();
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    Node attr = attrs.item(i);
                    String an = attr.getNodeName();
                    if (!this.nonCSSPresentationalHints.contains(an)) continue;
                    try {
                        LexicalUnit lu = this.parser.parsePropertyValue(attr.getNodeValue());
                        ph.property(an, lu, false);
                        continue;
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        if (m == null) {
                            m = "";
                        }
                        String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, an, attr.getNodeValue(), m});
                        DOMException de = new DOMException(12, s);
                        if (this.userAgent == null) {
                            throw de;
                        }
                        this.userAgent.displayError(de);
                    }
                }
            }
            if ((slen = (snodes = this.getStyleSheetNodes()).size()) > 0) {
                ArrayList rules2 = new ArrayList();
                for (int i = 0; i < slen; ++i) {
                    CSSStyleSheetNode ssn = (CSSStyleSheetNode)snodes.get(i);
                    StyleSheet ss = ssn.getCSSStyleSheet();
                    if (ss == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                    this.addMatchingRules(rules2, ss, elt, pseudo);
                }
                this.addRules(elt, pseudo, result, rules2, (short)24576);
            }
            if (this.styleLocalName != null && (style = elt.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                    this.parser.setConditionFactory(this.cssConditionFactory);
                    this.styleDeclarationDocumentHandler.styleMap = result;
                    this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration(style);
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) {
                        m = "";
                    }
                    String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, style, m});
                    DOMException de = new DOMException(12, s);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                }
            }
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return result;
    }

    public Value getComputedStyle(CSSStylableElement elt, String pseudo, int propidx) {
        StyleMap sm = elt.getComputedStyleMap(pseudo);
        if (sm == null) {
            sm = this.getCascadedStyleMap(elt, pseudo);
            elt.setComputedStyleMap(pseudo, sm);
        }
        Value value = sm.getValue(propidx);
        if (sm.isComputed(propidx)) {
            return value;
        }
        Value result = value;
        ValueManager vm = this.valueManagers[propidx];
        CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
        if (value == null) {
            if (p == null || !vm.isInheritedProperty()) {
                result = vm.getDefaultValue();
            }
        } else if (p != null && value == InheritValue.INSTANCE) {
            result = null;
        }
        if (result == null) {
            result = this.getComputedStyle(p, null, propidx);
            sm.putParentRelative(propidx, true);
            sm.putInherited(propidx, true);
        } else {
            result = vm.computeValue(elt, pseudo, this, propidx, sm, result);
        }
        if (value == null) {
            sm.putValue(propidx, result);
            sm.putNullCascaded(propidx, true);
        } else if (result != value) {
            ComputedValue cv = new ComputedValue(value);
            cv.setComputedValue(result);
            sm.putValue(propidx, cv);
            result = cv;
        }
        sm.putComputed(propidx, true);
        return result;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int len = this.styleSheetNodes.size();
            for (int i = 0; i < len; ++i) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)this.styleSheetNodes.get(i);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss == null) continue;
                this.findSelectorAttributes(this.selectorAttributes, ss);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node n) {
        if (n instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(n);
        }
        for (Node nd = n.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            this.findStyleSheetNodes(nd);
        }
    }

    protected void findSelectorAttributes(Set attrs, StyleSheet ss) {
        int len = ss.getSize();
        block4: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        s.fillAttributeSet(attrs);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) continue block4;
                    this.findSelectorAttributes(attrs, mr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProperties(CSSStylableElement elt, final MainPropertyReceiver dst, String pname, String value, boolean important) {
        try {
            this.element = elt;
            LexicalUnit lu = this.parser.parsePropertyValue(value);
            ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                public void property(String pname, LexicalUnit lu, boolean important) {
                    int idx = CSSEngine.this.getPropertyIndex(pname);
                    if (idx != -1) {
                        ValueManager vm = CSSEngine.this.valueManagers[idx];
                        Value v = vm.createValue(lu, CSSEngine.this);
                        dst.setMainProperty(pname, v, important);
                        return;
                    }
                    idx = CSSEngine.this.getShorthandIndex(pname);
                    if (idx == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                }
            };
            ph.property(pname, lu, important);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, pname, value, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parsePropertyValue(CSSStylableElement elt, String prop, String value) {
        int idx = this.getPropertyIndex(prop);
        if (idx == -1) {
            return null;
        }
        ValueManager vm = this.valueManagers[idx];
        try {
            this.element = elt;
            LexicalUnit lu = this.parser.parsePropertyValue(value);
            Value value2 = vm.createValue(lu, this);
            return value2;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, prop, value, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return vm.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDeclaration parseStyleDeclaration(CSSStylableElement elt, String value) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            this.element = elt;
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.parser.setDocumentHandler(this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration(value);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(URL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet(ss, uri);
        return ss;
    }

    public StyleSheet parseStyleSheet(InputSource is, URL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
            this.parseStyleSheet(ss, is, uri);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, URL uri) throws DOMException {
        if (uri == null) {
            String s = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return;
        }
        try {
            ParsedURL pDocURL = null;
            if (this.documentURI != null) {
                pDocURL = new ParsedURL(this.documentURI);
            }
            ParsedURL pURL = new ParsedURL(uri);
            this.cssContext.checkLoadExternalResource(pURL, pDocURL);
            this.parseStyleSheet(ss, new InputSource(uri.toString()), uri);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String s = Messages.formatMessage("syntax.error.at", new Object[]{uri.toString(), m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    public StyleSheet parseStyleSheet(String rules, URL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet(ss, rules, uri);
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, String rules, URL uri) throws DOMException {
        try {
            this.parseStyleSheet(ss, new InputSource(new StringReader(rules)), uri);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String s = Messages.formatMessage("stylesheet.syntax.error", new Object[]{uri.toString(), rules, m});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleSheet(StyleSheet ss, InputSource is, URL uri) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        try {
            this.cssBaseURI = uri;
            this.styleSheetDocumentHandler.styleSheet = ss;
            this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(is);
            int len = ss.getSize();
            for (int i = 0; i < len; ++i) {
                Rule r = ss.getRule(i);
                if (r.getType() != 2) {
                    break;
                }
                ImportRule ir = (ImportRule)r;
                this.parseStyleSheet(ir, ir.getURI());
            }
        }
        finally {
            this.cssBaseURI = null;
        }
    }

    protected void putAuthorProperty(StyleMap dest, int idx, Value sval, boolean imp, short origin) {
        boolean cond;
        Value dval = dest.getValue(idx);
        short dorg = dest.getOrigin(idx);
        boolean dimp = dest.isImportant(idx);
        boolean bl = cond = dval == null;
        if (!cond) {
            switch (dorg) {
                case 8192: {
                    cond = !dimp;
                    break;
                }
                case 24576: {
                    cond = !dimp || imp;
                    break;
                }
                default: {
                    cond = true;
                }
            }
        }
        if (cond) {
            dest.putValue(idx, sval);
            dest.putImportant(idx, imp);
            dest.putOrigin(idx, origin);
        }
    }

    protected void addMatchingRules(List rules, StyleSheet ss, Element elt, String pseudo) {
        int len = ss.getSize();
        block4: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        if (!s.match(elt, pseudo)) continue;
                        rules.add(style);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) continue block4;
                    this.addMatchingRules(rules, mr, elt, pseudo);
                }
            }
        }
    }

    protected void addRules(Element elt, String pseudo, StyleMap sm, List rules, short origin) {
        this.sortRules(rules, elt, pseudo);
        int rlen = rules.size();
        if (origin == 24576) {
            for (int r = 0; r < rlen; ++r) {
                StyleRule sr = (StyleRule)rules.get(r);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                for (int i = 0; i < len; ++i) {
                    this.putAuthorProperty(sm, sd.getIndex(i), sd.getValue(i), sd.getPriority(i), origin);
                }
            }
        } else {
            for (int r = 0; r < rlen; ++r) {
                StyleRule sr = (StyleRule)rules.get(r);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                for (int i = 0; i < len; ++i) {
                    int idx = sd.getIndex(i);
                    sm.putValue(idx, sd.getValue(i));
                    sm.putImportant(idx, sd.getPriority(i));
                    sm.putOrigin(idx, origin);
                }
            }
        }
    }

    protected void sortRules(List rules, Element elt, String pseudo) {
        int len = rules.size();
        for (int i = 0; i < len - 1; ++i) {
            int idx = i;
            int min = Integer.MAX_VALUE;
            for (int j = i; j < len; ++j) {
                StyleRule r = (StyleRule)rules.get(j);
                SelectorList sl = r.getSelectorList();
                int spec = 0;
                int slen = sl.getLength();
                for (int k = 0; k < slen; ++k) {
                    int sp;
                    ExtendedSelector s = (ExtendedSelector)sl.item(k);
                    if (!s.match(elt, pseudo) || (sp = s.getSpecificity()) <= spec) continue;
                    spec = sp;
                }
                if (spec >= min) continue;
                min = spec;
                idx = j;
            }
            if (i == idx) continue;
            Object tmp = rules.get(i);
            rules.set(i, rules.get(idx));
            rules.set(idx, tmp);
        }
    }

    protected boolean mediaMatch(SACMediaList ml) {
        if (this.media == null || ml == null || this.media.getLength() == 0 || ml.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < ml.getLength(); ++i) {
            if (ml.item(i).equalsIgnoreCase("all")) {
                return true;
            }
            for (int j = 0; j < this.media.getLength(); ++j) {
                if (!this.media.item(j).equalsIgnoreCase("all") && !ml.item(i).equalsIgnoreCase(this.media.item(j))) continue;
                return true;
            }
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener l) {
        this.listeners.add(l);
    }

    public void removeCSSEngineListener(CSSEngineListener l) {
        this.listeners.remove(l);
    }

    protected void firePropertiesChangedEvent(Element target, int[] props) {
        CSSEngineListener[] ll = this.listeners.toArray(LISTENER_ARRAY);
        int len = ll.length;
        if (len > 0) {
            CSSEngineEvent evt = new CSSEngineEvent(this, target, props);
            for (int i = 0; i < len; ++i) {
                ll[i].propertiesChanged(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inlineStyleAttributeUpdated(CSSStylableElement elt, StyleMap style, MutationEvent evt) {
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            updated[i] = false;
        }
        switch (evt.getAttrChange()) {
            case 1: 
            case 2: {
                String decl = evt.getNewValue();
                if (decl.length() > 0) {
                    this.element = elt;
                    try {
                        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                        this.parser.setConditionFactory(this.cssConditionFactory);
                        this.styleDeclarationUpdateHandler.styleMap = style;
                        this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration(decl);
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        if (m == null) {
                            m = "";
                        }
                        String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, decl, m});
                        DOMException de = new DOMException(12, s);
                        if (this.userAgent == null) {
                            throw de;
                        }
                        this.userAgent.displayError(de);
                    }
                    finally {
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                }
            }
            case 3: {
                boolean removed = false;
                if (evt.getPrevValue() != null && evt.getPrevValue().length() > 0) {
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        if (!style.isComputed(i) || style.getOrigin(i) != Short.MIN_VALUE || updated[i]) continue;
                        removed = true;
                        updated[i] = true;
                    }
                }
                if (removed) {
                    this.invalidateProperties(elt, null, updated, true);
                    break;
                }
                int count = 0;
                boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
                boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
                boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (updated[i]) {
                        ++count;
                        continue;
                    }
                    if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i)) && (!cl || !style.isColorRelative(i))) continue;
                    updated[i] = true;
                    CSSEngine.clearComputedValue(style, i);
                    ++count;
                }
                if (count <= 0) break;
                int[] props = new int[count];
                count = 0;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!updated[i]) continue;
                    props[count++] = i;
                }
                this.invalidateProperties(elt, props, null, true);
                break;
            }
            default: {
                throw new InternalError("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap style, int n) {
        if (style.isNullCascaded(n)) {
            style.putValue(n, null);
        } else {
            Value v = style.getValue(n);
            if (v instanceof ComputedValue) {
                ComputedValue cv = (ComputedValue)v;
                v = cv.getCascadedValue();
                style.putValue(n, v);
            }
        }
        style.putComputed(n, false);
    }

    protected void invalidateProperties(Node node, int[] properties, boolean[] updated, boolean recascade) {
        int i;
        int i2;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style == null) {
            return;
        }
        boolean[] diffs = new boolean[this.getNumberOfProperties()];
        if (updated != null) {
            for (i2 = 0; i2 < updated.length; ++i2) {
                diffs[i2] = updated[i2];
            }
        }
        if (properties != null) {
            for (i2 = 0; i2 < properties.length; ++i2) {
                diffs[properties[i2]] = true;
            }
        }
        int count = 0;
        if (!recascade) {
            for (int i3 = 0; i3 < diffs.length; ++i3) {
                if (!diffs[i3]) continue;
                ++count;
            }
        } else {
            StyleMap newStyle = this.getCascadedStyleMap(elt, null);
            elt.setComputedStyleMap(null, newStyle);
            for (i = 0; i < diffs.length; ++i) {
                if (diffs[i]) {
                    ++count;
                    continue;
                }
                Value nv = newStyle.getValue(i);
                Value ov = null;
                if (!style.isNullCascaded(i) && (ov = style.getValue(i)) instanceof ComputedValue) {
                    ov = ((ComputedValue)ov).getCascadedValue();
                }
                if (nv == ov) continue;
                if (nv != null && ov != null) {
                    if (nv.equals(ov)) continue;
                    String ovCssText = ov.getCssText();
                    String nvCssText = nv.getCssText();
                    if (nvCssText == ovCssText || nvCssText != null && nvCssText.equals(ovCssText)) continue;
                }
                ++count;
                diffs[i] = true;
            }
        }
        int[] props = null;
        if (count != 0) {
            props = new int[count];
            count = 0;
            for (i = 0; i < diffs.length; ++i) {
                if (!diffs[i]) continue;
                props[count++] = i;
            }
        }
        this.propagateChanges(elt, props, recascade);
    }

    protected void propagateChanges(Node node, int[] props, boolean recascade) {
        CSSImportedElementRoot ier;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style != null) {
            int i;
            int i2;
            boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
            for (i2 = this.getNumberOfProperties() - 1; i2 >= 0; --i2) {
                updated[i2] = false;
            }
            if (props != null) {
                for (i2 = props.length - 1; i2 >= 0; --i2) {
                    int idx = props[i2];
                    updated[idx] = true;
                }
            }
            boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
            boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
            boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
            int count = 0;
            for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                if (updated[i]) {
                    ++count;
                    continue;
                }
                if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i)) && (!cl || !style.isColorRelative(i))) continue;
                updated[i] = true;
                CSSEngine.clearComputedValue(style, i);
                ++count;
            }
            if (count == 0) {
                props = null;
            } else {
                props = new int[count];
                count = 0;
                for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!updated[i]) continue;
                    props[count++] = i;
                }
                this.firePropertiesChangedEvent(elt, props);
            }
        }
        int[] inherited = props;
        if (props != null) {
            int i;
            int count = 0;
            for (i = 0; i < props.length; ++i) {
                ValueManager vm = this.valueManagers[props[i]];
                if (vm.isInheritedProperty()) {
                    ++count;
                    continue;
                }
                props[i] = -1;
            }
            if (count == 0) {
                inherited = null;
            } else {
                inherited = new int[count];
                count = 0;
                for (i = 0; i < props.length; ++i) {
                    if (props[i] == -1) continue;
                    inherited[count++] = props[i];
                }
            }
        }
        if ((ier = CSSEngine.getImportedChild(node)) != null) {
            Element e = (Element)ier.getFirstChild();
            CSSEngine subEng = this.cssContext.getCSSEngineForElement(e);
            subEng.invalidateProperties(e, inherited, null, recascade);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.invalidateProperties(n, inherited, null, recascade);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonCSSPresentationalHintUpdated(CSSStylableElement elt, StyleMap style, String property, MutationEvent evt) {
        int idx = this.getPropertyIndex(property);
        if (style.isImportant(idx)) {
            return;
        }
        switch (style.getOrigin(idx)) {
            case -32768: 
            case 24576: {
                return;
            }
        }
        switch (evt.getAttrChange()) {
            case 1: 
            case 2: {
                this.element = elt;
                try {
                    LexicalUnit lu = this.parser.parsePropertyValue(evt.getNewValue());
                    ValueManager vm = this.valueManagers[idx];
                    Value v = vm.createValue(lu, this);
                    style.putMask(idx, (short)0);
                    style.putValue(idx, v);
                    style.putOrigin(idx, (short)16384);
                    break;
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) {
                        m = "";
                    }
                    String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, property, evt.getNewValue(), m});
                    DOMException de = new DOMException(12, s);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                    break;
                }
                finally {
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int[] invalid = new int[]{idx};
                this.invalidateProperties(elt, invalid, null, true);
                return;
            }
        }
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            updated[i] = false;
        }
        updated[idx] = true;
        boolean fs = idx == this.fontSizeIndex;
        boolean lh = idx == this.lineHeightIndex;
        boolean cl = idx == this.colorIndex;
        int count = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (updated[i]) {
                ++count;
                continue;
            }
            if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i)) && (!cl || !style.isColorRelative(i))) continue;
            updated[i] = true;
            CSSEngine.clearComputedValue(style, i);
            ++count;
        }
        int[] props = new int[count];
        count = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!updated[i]) continue;
            props[count++] = i;
        }
        this.invalidateProperties(elt, props, null, true);
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (!(et instanceof CSSStylableElement)) {
                return;
            }
            MutationEvent mevt = (MutationEvent)evt;
            if (mevt.getNewValue().equals(mevt.getPrevValue())) {
                return;
            }
            Node attr = mevt.getRelatedNode();
            String attrNS = attr.getNamespaceURI();
            String name = attrNS == null ? attr.getNodeName() : attr.getLocalName();
            CSSStylableElement elt = (CSSStylableElement)((Object)et);
            StyleMap style = elt.getComputedStyleMap(null);
            if (style != null) {
                if ((attrNS == CSSEngine.this.styleNamespaceURI || attrNS != null && attrNS.equals(CSSEngine.this.styleNamespaceURI)) && name.equals(CSSEngine.this.styleLocalName)) {
                    CSSEngine.this.inlineStyleAttributeUpdated(elt, style, mevt);
                    return;
                }
                if (CSSEngine.this.nonCSSPresentationalHints != null && (attrNS == CSSEngine.this.nonCSSPresentationalHintsNamespaceURI || attrNS != null && attrNS.equals(CSSEngine.this.nonCSSPresentationalHintsNamespaceURI)) && CSSEngine.this.nonCSSPresentationalHints.contains(name)) {
                    CSSEngine.this.nonCSSPresentationalHintUpdated(elt, style, name, mevt);
                    return;
                }
            }
            if (CSSEngine.this.selectorAttributes != null && CSSEngine.this.selectorAttributes.contains(name)) {
                CSSEngine.this.invalidateProperties(elt, null, null, true);
                for (Node n = elt.getNextSibling(); n != null; n = n.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(n, null, null, true);
                }
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event evt) {
            Node n = (Node)((Object)evt.getTarget());
            if (n.getParentNode() instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
            }
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event evt) {
            if (CSSEngine.this.styleSheetRemoved) {
                CSSEngine.this.styleSheetRemoved = false;
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
            } else if (CSSEngine.this.removedStylableElementSibling != null) {
                for (Node n = CSSEngine.this.removedStylableElementSibling; n != null; n = n.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(n, null, null, true);
                }
                CSSEngine.this.removedStylableElementSibling = null;
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (et instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetRemoved = true;
            } else if (et instanceof CSSStylableElement) {
                CSSEngine.this.removedStylableElementSibling = ((Node)((Object)et)).getNextSibling();
            }
            CSSEngine.this.disposeStyleMaps((Node)((Object)et));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (et instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
                return;
            }
            if (et instanceof CSSStylableElement) {
                for (Node n = ((Node)((Object)evt.getTarget())).getNextSibling(); n != null; n = n.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(n, null, null, true);
                }
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                if (this.styleMap.isImportant(i)) {
                    return;
                }
                this.updatedProperties[i] = true;
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleMap.putMask(i, (short)0);
                this.styleMap.putValue(i, v);
                this.styleMap.putOrigin(i, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void endDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            throw new InternalError();
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            throw new InternalError();
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            throw new InternalError();
        }

        public void startMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void endMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void startFontFace() throws CSSException {
            throw new InternalError();
        }

        public void endFontFace() throws CSSException {
            throw new InternalError();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            throw new InternalError();
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource source) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            ImportRule ir = new ImportRule();
            ir.setMediaList(media);
            ir.setParent(this.styleSheet);
            try {
                URL base = CSSEngine.this.getCSSBaseURI();
                URL url = base == null ? new URL(uri) : new URL(base, uri);
                ir.setURI(url);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            this.styleSheet.append(ir);
        }

        public void startMedia(SACMediaList media) throws CSSException {
            MediaRule mr = new MediaRule();
            mr.setMediaList(media);
            mr.setParent(this.styleSheet);
            this.styleSheet.append(mr);
            this.styleSheet = mr;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        public void endFontFace() throws CSSException {
            StyleMap sm = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int len = this.styleDeclaration.size();
            for (int i = 0; i < len; ++i) {
                int idx = this.styleDeclaration.getIndex(i);
                sm.putValue(idx, this.styleDeclaration.getValue(i));
                sm.putImportant(idx, this.styleDeclaration.getPriority(i));
                sm.putOrigin(idx, (short)24576);
            }
            this.styleDeclaration = null;
            int pidx = CSSEngine.this.getPropertyIndex("font-family");
            Value fontFamily = sm.getValue(pidx);
            if (fontFamily == null) {
                return;
            }
            URL base = CSSEngine.this.getCSSBaseURI();
            ParsedURL purl = null;
            if (base != null) {
                purl = new ParsedURL(base);
            }
            CSSEngine.this.fontFaces.add(new FontFaceRule(sm, purl));
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectors);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v, i, important);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v, i, important);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, i, v, important, (short)Short.MIN_VALUE);
            }
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }
}

