/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.CSSConstants;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element e, ShapeNode node, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(e, 36);
        Marker startMarker = PaintServer.convertMarker(e, v, ctx);
        v = CSSUtilities.getComputedStyle(e, 35);
        Marker midMarker = PaintServer.convertMarker(e, v, ctx);
        v = CSSUtilities.getComputedStyle(e, 34);
        Marker endMarker = PaintServer.convertMarker(e, v, ctx);
        if (startMarker != null || midMarker != null || endMarker != null) {
            MarkerShapePainter p = new MarkerShapePainter(node.getShape());
            p.setStartMarker(startMarker);
            p.setMiddleMarker(midMarker);
            p.setEndMarker(endMarker);
            return p;
        }
        return null;
    }

    public static Marker convertMarker(Element e, Value v, BridgeContext ctx) {
        if (v.getPrimitiveType() == 21) {
            return null;
        }
        String uri = v.getStringValue();
        Element markerElement = ctx.getReferencedElement(e, uri);
        Bridge bridge = ctx.getBridge(markerElement);
        if (bridge == null || !(bridge instanceof MarkerBridge)) {
            throw new BridgeException(e, "css.uri.badTarget", new Object[]{uri});
        }
        return ((MarkerBridge)bridge).createMarker(ctx, markerElement, e);
    }

    public static ShapePainter convertFillAndStroke(Element e, ShapeNode node, BridgeContext ctx) {
        Shape shape = node.getShape();
        if (shape == null) {
            return null;
        }
        Paint fillPaint = PaintServer.convertFillPaint(e, node, ctx);
        FillShapePainter fp = new FillShapePainter(shape);
        fp.setPaint(fillPaint);
        Stroke stroke = PaintServer.convertStroke(e);
        if (stroke == null) {
            return fp;
        }
        Paint strokePaint = PaintServer.convertStrokePaint(e, node, ctx);
        StrokeShapePainter sp = new StrokeShapePainter(shape);
        sp.setStroke(stroke);
        sp.setPaint(strokePaint);
        CompositeShapePainter cp = new CompositeShapePainter(shape);
        cp.addShapePainter(fp);
        cp.addShapePainter(sp);
        return cp;
    }

    public static ShapePainter convertStrokePainter(Element e, ShapeNode node, BridgeContext ctx) {
        Shape shape = node.getShape();
        if (shape == null) {
            return null;
        }
        Stroke stroke = PaintServer.convertStroke(e);
        if (stroke == null) {
            return null;
        }
        Paint strokePaint = PaintServer.convertStrokePaint(e, node, ctx);
        StrokeShapePainter sp = new StrokeShapePainter(shape);
        sp.setStroke(stroke);
        sp.setPaint(strokePaint);
        return sp;
    }

    public static Paint convertStrokePaint(Element strokedElement, GraphicsNode strokedNode, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(strokedElement, 51);
        float opacity = PaintServer.convertOpacity(v);
        v = CSSUtilities.getComputedStyle(strokedElement, 45);
        return PaintServer.convertPaint(strokedElement, strokedNode, v, opacity, ctx);
    }

    public static Paint convertFillPaint(Element filledElement, GraphicsNode filledNode, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(filledElement, 16);
        float opacity = PaintServer.convertOpacity(v);
        v = CSSUtilities.getComputedStyle(filledElement, 15);
        return PaintServer.convertPaint(filledElement, filledNode, v, opacity, ctx);
    }

    public static Paint convertPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        if (paintDef.getCssValueType() == 1) {
            switch (paintDef.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return PaintServer.convertColor(paintDef, opacity);
                }
                case 20: {
                    return PaintServer.convertURIPaint(paintedElement, paintedNode, paintDef, opacity, ctx);
                }
            }
            throw new Error();
        }
        Value v = paintDef.item(0);
        switch (v.getPrimitiveType()) {
            case 25: {
                return PaintServer.convertRGBICCColor(paintedElement, v, (ICCColor)paintDef.item(1), opacity, ctx);
            }
            case 20: {
                Paint result = PaintServer.silentConvertURIPaint(paintedElement, paintedNode, v, opacity, ctx);
                if (result != null) {
                    return result;
                }
                v = paintDef.item(1);
                switch (v.getPrimitiveType()) {
                    case 21: {
                        return null;
                    }
                    case 25: {
                        if (paintDef.getLength() == 2) {
                            return PaintServer.convertColor(v, opacity);
                        }
                        return PaintServer.convertRGBICCColor(paintedElement, v, (ICCColor)paintDef.item(2), opacity, ctx);
                    }
                }
                throw new Error();
            }
        }
        throw new Error("Unallowed Value: " + v.getPrimitiveType());
    }

    public static Paint silentConvertURIPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(paintedElement, paintedNode, paintDef, opacity, ctx);
        }
        catch (BridgeException ex) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        String uri = paintDef.getStringValue();
        Element paintElement = ctx.getReferencedElement(paintedElement, uri);
        Bridge bridge = ctx.getBridge(paintElement);
        if (bridge == null || !(bridge instanceof PaintBridge)) {
            throw new BridgeException(paintedElement, "css.uri.badTarget", new Object[]{uri});
        }
        return ((PaintBridge)bridge).createPaint(ctx, paintElement, paintedElement, paintedNode, opacity);
    }

    public static Color convertRGBICCColor(Element paintedElement, Value colorDef, ICCColor iccColor, float opacity, BridgeContext ctx) {
        Color color = null;
        if (iccColor != null) {
            color = PaintServer.convertICCColor(paintedElement, iccColor, opacity, ctx);
        }
        if (color == null) {
            color = PaintServer.convertColor(colorDef, opacity);
        }
        return color;
    }

    public static Color convertICCColor(Element e, ICCColor c, float opacity, BridgeContext ctx) {
        String iccProfileName = c.getColorProfile();
        if (iccProfileName == null) {
            return null;
        }
        SVGColorProfileElementBridge profileBridge = (SVGColorProfileElementBridge)ctx.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (profileBridge == null) {
            return null;
        }
        ICCColorSpaceExt profileCS = profileBridge.createICCColorSpaceExt(ctx, e, iccProfileName);
        if (profileCS == null) {
            return null;
        }
        int n = c.getNumberOfColors();
        float[] colorValue = new float[n];
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            colorValue[i] = c.getColor(i);
        }
        float[] rgb = profileCS.intendedToRGB(colorValue);
        return new Color(rgb[0], rgb[1], rgb[2], opacity);
    }

    public static Color convertColor(Value c, float opacity) {
        int r = PaintServer.resolveColorComponent(c.getRed());
        int g = PaintServer.resolveColorComponent(c.getGreen());
        int b = PaintServer.resolveColorComponent(c.getBlue());
        return new Color(r, g, b, Math.round(opacity * 255.0f));
    }

    public static Stroke convertStroke(Element e) {
        Value v = CSSUtilities.getComputedStyle(e, 52);
        float width = v.getFloatValue();
        if (width == 0.0f) {
            return null;
        }
        v = CSSUtilities.getComputedStyle(e, 48);
        int linecap = PaintServer.convertStrokeLinecap(v);
        v = CSSUtilities.getComputedStyle(e, 49);
        int linejoin = PaintServer.convertStrokeLinejoin(v);
        v = CSSUtilities.getComputedStyle(e, 50);
        float miterlimit = PaintServer.convertStrokeMiterlimit(v);
        v = CSSUtilities.getComputedStyle(e, 46);
        float[] dasharray = PaintServer.convertStrokeDasharray(v);
        float dashoffset = 0.0f;
        if (dasharray != null && (dashoffset = (v = CSSUtilities.getComputedStyle(e, 47)).getFloatValue()) < 0.0f) {
            float dashpatternlength = 0.0f;
            for (int i = 0; i < dasharray.length; ++i) {
                dashpatternlength += dasharray[i];
            }
            if (dasharray.length % 2 != 0) {
                dashpatternlength *= 2.0f;
            }
            if (dashpatternlength == 0.0f) {
                dashoffset = 0.0f;
            } else {
                while (dashoffset < 0.0f) {
                    dashoffset += dashpatternlength;
                }
            }
        }
        return new BasicStroke(width, linecap, linejoin, miterlimit, dasharray, dashoffset);
    }

    public static float[] convertStrokeDasharray(Value v) {
        float[] dasharray = null;
        if (v.getCssValueType() == 2) {
            int length = v.getLength();
            dasharray = new float[length];
            float sum = 0.0f;
            for (int i = 0; i < dasharray.length; ++i) {
                dasharray[i] = v.item(i).getFloatValue();
                sum += dasharray[i];
            }
            if (sum == 0.0f) {
                dasharray = null;
            }
        }
        return dasharray;
    }

    public static float convertStrokeMiterlimit(Value v) {
        float miterlimit = v.getFloatValue();
        return miterlimit < 1.0f ? 1.0f : miterlimit;
    }

    public static int convertStrokeLinecap(Value v) {
        String s = v.getStringValue();
        switch (s.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int convertStrokeLinejoin(Value v) {
        String s = v.getStringValue();
        switch (s.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int resolveColorComponent(Value v) {
        switch (v.getPrimitiveType()) {
            case 2: {
                float f = v.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(255.0f * f / 100.0f);
            }
            case 1: {
                float f = v.getFloatValue();
                f = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(f);
            }
        }
        throw new Error();
    }

    public static float convertOpacity(Value v) {
        float r = v.getFloatValue();
        return r < 0.0f ? 0.0f : (r > 1.0f ? 1.0f : r);
    }
}

