/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.Messages;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterController;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.util.ApplicationSecurityEnforcer;

public class Main
implements SVGConverterController {
    public static final String RASTERIZER_SECURITY_POLICY = "org/apache/batik/apps/rasterizer/resources/rasterizer.policy";
    public static String USAGE = Messages.formatMessage("Main.usage", null);
    public static String CL_OPTION_OUTPUT = Messages.get("Main.cl.option.output", "-d");
    public static String CL_OPTION_OUTPUT_DESCRIPTION = Messages.get("Main.cl.option.output.description", "No description");
    public static String CL_OPTION_MIME_TYPE = Messages.get("Main.cl.option.mime.type", "-m");
    public static String CL_OPTION_MIME_TYPE_DESCRIPTION = Messages.get("Main.cl.option.mime.type.description", "No description");
    public static String CL_OPTION_WIDTH = Messages.get("Main.cl.option.width", "-w");
    public static String CL_OPTION_WIDTH_DESCRIPTION = Messages.get("Main.cl.option.width.description", "No description");
    public static String CL_OPTION_HEIGHT = Messages.get("Main.cl.option.height", "-h");
    public static String CL_OPTION_HEIGHT_DESCRIPTION = Messages.get("Main.cl.option.height.description", "No description");
    public static String CL_OPTION_MAX_WIDTH = Messages.get("Main.cl.option.max.width", "-maxw");
    public static String CL_OPTION_MAX_WIDTH_DESCRIPTION = Messages.get("Main.cl.option.max.width.description", "No description");
    public static String CL_OPTION_MAX_HEIGHT = Messages.get("Main.cl.option.max.height", "-maxh");
    public static String CL_OPTION_MAX_HEIGHT_DESCRIPTION = Messages.get("Main.cl.option.max.height.description", "No description");
    public static String CL_OPTION_AOI = Messages.get("Main.cl.option.aoi", "-a");
    public static String CL_OPTION_AOI_DESCRIPTION = Messages.get("Main.cl.option.aoi.description", "No description");
    public static String CL_OPTION_BACKGROUND_COLOR = Messages.get("Main.cl.option.background.color", "-bg");
    public static String CL_OPTION_BACKGROUND_COLOR_DESCRIPTION = Messages.get("Main.cl.option.background.color.description", "No description");
    public static String CL_OPTION_MEDIA_TYPE = Messages.get("Main.cl.option.media.type", "-cssMedia");
    public static String CL_OPTION_MEDIA_TYPE_DESCRIPTION = Messages.get("Main.cl.option.media.type.description", "No description");
    public static String CL_OPTION_DEFAULT_FONT_FAMILY = Messages.get("Main.cl.option.default.font.family", "-font-family");
    public static String CL_OPTION_DEFAULT_FONT_FAMILY_DESCRIPTION = Messages.get("Main.cl.option.default.font.family.description", "No description");
    public static String CL_OPTION_ALTERNATE_STYLESHEET = Messages.get("Main.cl.option.alternate.stylesheet", "-cssAlternate");
    public static String CL_OPTION_ALTERNATE_STYLESHEET_DESCRIPTION = Messages.get("Main.cl.option.alternate.stylesheet.description", "No description");
    public static String CL_OPTION_VALIDATE = Messages.get("Main.cl.option.validate", "-validate");
    public static String CL_OPTION_VALIDATE_DESCRIPTION = Messages.get("Main.cl.option.validate.description", "No description");
    public static String CL_OPTION_ONLOAD = Messages.get("Main.cl.option.onload", "-onload");
    public static String CL_OPTION_ONLOAD_DESCRIPTION = Messages.get("Main.cl.option.onload.description", "No description");
    public static String CL_OPTION_LANGUAGE = Messages.get("Main.cl.option.language", "-lang");
    public static String CL_OPTION_LANGUAGE_DESCRIPTION = Messages.get("Main.cl.option.language.description", "No description");
    public static String CL_OPTION_USER_STYLESHEET = Messages.get("Main.cl.option.user.stylesheet", "-cssUser");
    public static String CL_OPTION_USER_STYLESHEET_DESCRIPTION = Messages.get("Main.cl.option.user.stylesheet.description", "No description");
    public static String CL_OPTION_DPI = Messages.get("Main.cl.option.dpi", "-dpi");
    public static String CL_OPTION_DPI_DESCRIPTION = Messages.get("Main.cl.option.dpi.description", "No description");
    public static String CL_OPTION_QUALITY = Messages.get("Main.cl.option.quality", "-q");
    public static String CL_OPTION_QUALITY_DESCRIPTION = Messages.get("Main.cl.option.quality.description", "No description");
    public static String CL_OPTION_INDEXED = Messages.get("Main.cl.option.indexed", "-indexed");
    public static String CL_OPTION_INDEXED_DESCRIPTION = Messages.get("Main.cl.option.indexed.description", "No description");
    public static String CL_OPTION_ALLOWED_SCRIPTS = Messages.get("Main.cl.option.allowed.scripts", "-scripts");
    public static String CL_OPTION_ALLOWED_SCRIPTS_DESCRIPTION = Messages.get("Main.cl.option.allowed.scripts.description", "No description");
    public static String CL_OPTION_CONSTRAIN_SCRIPT_ORIGIN = Messages.get("Main.cl.option.constrain.script.origin", "-anyScriptOrigin");
    public static String CL_OPTION_CONSTRAIN_SCRIPT_ORIGIN_DESCRIPTION = Messages.get("Main.cl.option.constrain.script.origin.description", "No description");
    public static String CL_OPTION_SECURITY_OFF = Messages.get("Main.cl.option.security.off", "-scriptSecurityOff");
    public static String CL_OPTION_SECURITY_OFF_DESCRIPTION = Messages.get("Main.cl.option.security.off.description", "No description");
    protected static Map optionMap = new Hashtable();
    protected static Map mimeTypeMap = new Hashtable();
    protected Vector args = new Vector();
    public static final String ERROR_NOT_ENOUGH_OPTION_VALUES = "Main.error.not.enough.option.values";
    public static final String ERROR_ILLEGAL_ARGUMENT = "Main.error.illegal.argument";
    public static final String ERROR_WHILE_CONVERTING_FILES = "Main.error.while.converting.files";
    public static final String MESSAGE_ABOUT_TO_TRANSCODE = "Main.message.about.to.transcode";
    public static final String MESSAGE_ABOUT_TO_TRANSCODE_SOURCE = "Main.message.about.to.transcode.source";
    public static final String MESSAGE_CONVERSION_FAILED = "Main.message.conversion.failed";
    public static final String MESSAGE_CONVERSION_SUCCESS = "Main.message.conversion.success";

    public Main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.args.addElement(args[i]);
        }
    }

    protected void error(String errorCode, Object[] errorArgs) {
        System.err.println(Messages.formatMessage(errorCode, errorArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        SVGConverter c = new SVGConverter(this);
        Vector<String> sources = new Vector<String>();
        int nArgs = this.args.size();
        for (int i = 0; i < nArgs; ++i) {
            String v = (String)this.args.elementAt(i);
            OptionHandler optionHandler = (OptionHandler)optionMap.get(v);
            if (optionHandler == null) {
                sources.addElement(v);
                continue;
            }
            int nOptionArgs = optionHandler.getOptionValuesLength();
            if (i + nOptionArgs >= nArgs) {
                this.error(ERROR_NOT_ENOUGH_OPTION_VALUES, new Object[]{v, optionHandler.getOptionDescription()});
                return;
            }
            String[] optionValues = new String[nOptionArgs];
            for (int j = 0; j < nOptionArgs; ++j) {
                optionValues[j] = (String)this.args.elementAt(1 + i + j);
            }
            i += nOptionArgs;
            try {
                optionHandler.handleOption(optionValues, c);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                this.error(ERROR_ILLEGAL_ARGUMENT, new Object[]{v, optionHandler.getOptionDescription(), this.toString(optionValues)});
                return;
            }
        }
        ApplicationSecurityEnforcer securityEnforcer = new ApplicationSecurityEnforcer(this.getClass(), RASTERIZER_SECURITY_POLICY);
        securityEnforcer.enforceSecurity(!c.getSecurityOff());
        String[] expandedSources = this.expandSources(sources);
        c.setSources(expandedSources);
        this.validateConverterConfig(c);
        if (expandedSources == null || expandedSources.length < 1) {
            System.out.println(USAGE);
            System.out.flush();
            securityEnforcer.enforceSecurity(false);
            return;
        }
        try {
            c.execute();
        }
        catch (SVGConverterException e) {
            this.error(ERROR_WHILE_CONVERTING_FILES, new Object[]{e.getMessage()});
        }
        finally {
            System.out.flush();
            securityEnforcer.enforceSecurity(false);
        }
    }

    protected String toString(String[] v) {
        StringBuffer sb = new StringBuffer();
        int n = v != null ? v.length : 0;
        for (int i = 0; i < n; ++i) {
            sb.append(v[i] + " ");
        }
        return sb.toString();
    }

    public void validateConverterConfig(SVGConverter c) {
    }

    protected String[] expandSources(Vector sources) {
        Vector<String> expandedSources = new Vector<String>();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            String v = (String)iter.next();
            File f = new File(v);
            if (f.exists() && f.isDirectory()) {
                File[] fl = f.listFiles(new SVGConverter.SVGFileFilter());
                for (int i = 0; i < fl.length; ++i) {
                    expandedSources.addElement(fl[i].getPath());
                }
                continue;
            }
            expandedSources.addElement(v);
        }
        Object[] s = new String[expandedSources.size()];
        expandedSources.copyInto(s);
        return s;
    }

    public static void main(String[] args) {
        new Main(args).execute();
        System.exit(0);
    }

    public boolean proceedWithComputedTask(Transcoder transcoder, Map hints, Vector sources, Vector dest) {
        System.out.println(Messages.formatMessage(MESSAGE_ABOUT_TO_TRANSCODE, new Object[]{"" + sources.size()}));
        return true;
    }

    public boolean proceedWithSourceTranscoding(SVGConverterSource source, File dest) {
        System.out.print(Messages.formatMessage(MESSAGE_ABOUT_TO_TRANSCODE_SOURCE, new Object[]{source.toString(), dest.toString()}));
        return true;
    }

    public boolean proceedOnSourceTranscodingFailure(SVGConverterSource source, File dest, String errorCode) {
        System.out.println(Messages.formatMessage(MESSAGE_CONVERSION_FAILED, new Object[]{errorCode}));
        return true;
    }

    public void onSourceTranscodingSuccess(SVGConverterSource source, File dest) {
        System.out.println(Messages.formatMessage(MESSAGE_CONVERSION_SUCCESS, null));
    }

    static {
        mimeTypeMap.put("image/jpg", DestinationType.JPEG);
        mimeTypeMap.put("image/jpeg", DestinationType.JPEG);
        mimeTypeMap.put("image/jpe", DestinationType.JPEG);
        mimeTypeMap.put("image/png", DestinationType.PNG);
        mimeTypeMap.put("application/pdf", DestinationType.PDF);
        mimeTypeMap.put("image/tiff", DestinationType.TIFF);
        optionMap.put(CL_OPTION_OUTPUT, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setDst(new File(optionValue));
            }

            public String getOptionDescription() {
                return CL_OPTION_OUTPUT_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_MIME_TYPE, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                DestinationType dstType = (DestinationType)mimeTypeMap.get(optionValue);
                if (dstType == null) {
                    throw new IllegalArgumentException();
                }
                c.setDestinationType(dstType);
            }

            public String getOptionDescription() {
                return CL_OPTION_MIME_TYPE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_WIDTH, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                c.setWidth(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_WIDTH_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_HEIGHT, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                c.setHeight(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_HEIGHT_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_MAX_WIDTH, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                c.setMaxWidth(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_MAX_WIDTH_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_MAX_HEIGHT, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                c.setMaxHeight(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_MAX_HEIGHT_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_AOI, new RectangleOptionHandler(){

            public void handleOption(Rectangle2D optionValue, SVGConverter c) {
                c.setArea(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_AOI_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_BACKGROUND_COLOR, new ColorOptionHandler(){

            public void handleOption(Color optionValue, SVGConverter c) {
                c.setBackgroundColor(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_BACKGROUND_COLOR_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_MEDIA_TYPE, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setMediaType(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_MEDIA_TYPE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_DEFAULT_FONT_FAMILY, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setDefaultFontFamily(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_DEFAULT_FONT_FAMILY_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_ALTERNATE_STYLESHEET, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setAlternateStylesheet(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_ALTERNATE_STYLESHEET_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_USER_STYLESHEET, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setUserStylesheet(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_USER_STYLESHEET_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_LANGUAGE, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setLanguage(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_LANGUAGE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_DPI, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                c.setPixelUnitToMillimeter(2.54f / optionValue * 10.0f);
            }

            public String getOptionDescription() {
                return CL_OPTION_DPI_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_QUALITY, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue <= 0.0f || optionValue >= 1.0f) {
                    throw new IllegalArgumentException();
                }
                c.setQuality(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_QUALITY_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_INDEXED, new FloatOptionHandler(){

            public void handleOption(float optionValue, SVGConverter c) {
                if (optionValue != 1.0f && optionValue != 2.0f && optionValue != 4.0f && optionValue != 8.0f) {
                    throw new IllegalArgumentException();
                }
                c.setIndexed((int)optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_INDEXED_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_VALIDATE, new NoValueOptionHandler(){

            public void handleOption(SVGConverter c) {
                c.setValidate(true);
            }

            public String getOptionDescription() {
                return CL_OPTION_VALIDATE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_ONLOAD, new NoValueOptionHandler(){

            public void handleOption(SVGConverter c) {
                c.setExecuteOnload(true);
            }

            public String getOptionDescription() {
                return CL_OPTION_ONLOAD_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_ALLOWED_SCRIPTS, new SingleValueOptionHandler(){

            public void handleOption(String optionValue, SVGConverter c) {
                c.setAllowedScriptTypes(optionValue);
            }

            public String getOptionDescription() {
                return CL_OPTION_ALLOWED_SCRIPTS_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_CONSTRAIN_SCRIPT_ORIGIN, new NoValueOptionHandler(){

            public void handleOption(SVGConverter c) {
                c.setConstrainScriptOrigin(false);
            }

            public String getOptionDescription() {
                return CL_OPTION_CONSTRAIN_SCRIPT_ORIGIN_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_SECURITY_OFF, new NoValueOptionHandler(){

            public void handleOption(SVGConverter c) {
                c.setSecurityOff(true);
            }

            public String getOptionDescription() {
                return CL_OPTION_SECURITY_OFF_DESCRIPTION;
            }
        });
    }

    public static abstract class ColorOptionHandler
    extends SingleValueOptionHandler {
        public void handleOption(String optionValue, SVGConverter c) {
            Color color = this.parseARGB(optionValue);
            if (color == null) {
                throw new IllegalArgumentException();
            }
            this.handleOption(color, c);
        }

        public abstract void handleOption(Color var1, SVGConverter var2);

        public Color parseARGB(String argbVal) {
            StringTokenizer st;
            Color c = null;
            if (argbVal != null && (st = new StringTokenizer(argbVal, ".")).countTokens() == 4) {
                String aStr = st.nextToken();
                String rStr = st.nextToken();
                String gStr = st.nextToken();
                String bStr = st.nextToken();
                int a = -1;
                int r = -1;
                int g = -1;
                int b = -1;
                try {
                    a = Integer.parseInt(aStr);
                    r = Integer.parseInt(rStr);
                    g = Integer.parseInt(gStr);
                    b = Integer.parseInt(bStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (a >= 0 && a <= 255 && r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) {
                    c = new Color(r, g, b, a);
                }
            }
            return c;
        }
    }

    public static abstract class RectangleOptionHandler
    extends SingleValueOptionHandler {
        public void handleOption(String optionValue, SVGConverter c) {
            Rectangle2D.Float r = this.parseRect(optionValue);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            this.handleOption(r, c);
        }

        public abstract void handleOption(Rectangle2D var1, SVGConverter var2);

        public Rectangle2D.Float parseRect(String rectValue) {
            Rectangle2D.Float rect = null;
            if (rectValue != null) {
                StringTokenizer st;
                if (!rectValue.toLowerCase().endsWith("f")) {
                    rectValue = rectValue + "f";
                }
                if ((st = new StringTokenizer(rectValue, ",")).countTokens() == 4) {
                    String xStr = st.nextToken();
                    String yStr = st.nextToken();
                    String wStr = st.nextToken();
                    String hStr = st.nextToken();
                    float x = Float.NaN;
                    float y = Float.NaN;
                    float w = Float.NaN;
                    float h = Float.NaN;
                    try {
                        x = Float.parseFloat(xStr);
                        y = Float.parseFloat(yStr);
                        w = Float.parseFloat(wStr);
                        h = Float.parseFloat(hStr);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (!Float.isNaN(x) && !Float.isNaN(y) && !Float.isNaN(w) && w > 0.0f && !Float.isNaN(h) && h > 0.0f) {
                        rect = new Rectangle2D.Float(x, y, w, h);
                    }
                }
            }
            return rect;
        }
    }

    public static abstract class FloatOptionHandler
    extends SingleValueOptionHandler {
        public void handleOption(String optionValue, SVGConverter c) {
            try {
                this.handleOption(Float.parseFloat(optionValue), c);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }

        public abstract void handleOption(float var1, SVGConverter var2);
    }

    public static abstract class SingleValueOptionHandler
    extends AbstractOptionHandler {
        public void safeHandleOption(String[] optionValues, SVGConverter c) {
            this.handleOption(optionValues[0], c);
        }

        public int getOptionValuesLength() {
            return 1;
        }

        public abstract void handleOption(String var1, SVGConverter var2);
    }

    public static abstract class NoValueOptionHandler
    extends AbstractOptionHandler {
        public void safeHandleOption(String[] optionValues, SVGConverter c) {
            this.handleOption(c);
        }

        public int getOptionValuesLength() {
            return 0;
        }

        public abstract void handleOption(SVGConverter var1);
    }

    public static abstract class AbstractOptionHandler
    implements OptionHandler {
        public void handleOption(String[] optionValues, SVGConverter c) {
            int nOptions;
            int n = nOptions = optionValues != null ? optionValues.length : 0;
            if (nOptions != this.getOptionValuesLength()) {
                throw new IllegalArgumentException();
            }
            this.safeHandleOption(optionValues, c);
        }

        public abstract void safeHandleOption(String[] var1, SVGConverter var2);
    }

    public static interface OptionHandler {
        public void handleOption(String[] var1, SVGConverter var2);

        public int getOptionValuesLength();

        public String getOptionDescription();
    }
}

