/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathUtil {
    private PathUtil() {
    }

    public static File getRelativeFile(File baseFile, File fileToRelativize) throws IOException {
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return new File(PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), fileToRelativize.getCanonicalFile()));
    }

    public static String getRelativePath(String basePath, String pathToRelativize) throws IOException {
        File baseFile = new File(basePath);
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), new File(pathToRelativize).getCanonicalFile());
    }

    static String getRelativeFileInternal(File canonicalBaseFile, File canonicalFileToRelativize) {
        int i2;
        ArrayList<String> basePath = PathUtil.getPathComponents(canonicalBaseFile);
        ArrayList<String> pathToRelativize = PathUtil.getPathComponents(canonicalFileToRelativize);
        if (!basePath.get(0).equals(pathToRelativize.get(0))) {
            return canonicalFileToRelativize.getPath();
        }
        StringBuilder sb = new StringBuilder();
        for (int commonDirs = 1; commonDirs < basePath.size() && commonDirs < pathToRelativize.size() && basePath.get(commonDirs).equals(pathToRelativize.get(commonDirs)); ++commonDirs) {
        }
        boolean first = true;
        for (i2 = commonDirs; i2 < basePath.size(); ++i2) {
            if (!first) {
                sb.append(File.separatorChar);
            } else {
                first = false;
            }
            sb.append("..");
        }
        first = true;
        for (i2 = commonDirs; i2 < pathToRelativize.size(); ++i2) {
            if (first) {
                if (sb.length() != 0) {
                    sb.append(File.separatorChar);
                }
                first = false;
            } else {
                sb.append(File.separatorChar);
            }
            sb.append(pathToRelativize.get(i2));
        }
        if (sb.length() == 0) {
            return ".";
        }
        return sb.toString();
    }

    private static ArrayList<String> getPathComponents(File file) {
        ArrayList<String> path = new ArrayList<String>();
        while (file != null) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                path.add(0, file.getPath());
            } else {
                path.add(0, file.getName());
            }
            file = parentFile;
        }
        return path;
    }
}

