/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import ds.tree.RadixTree;
import ds.tree.RadixTreeImpl;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.regex.Pattern;

public class ClassFileNameHandler {
    private PackageNameEntry top;
    private String fileExtension;
    private boolean modifyWindowsReservedFilenames;
    private static Pattern reservedFileNameRegex = Pattern.compile("^CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9]$", 2);

    public ClassFileNameHandler(File path, String fileExtension) {
        this.top = new PackageNameEntry(path);
        this.fileExtension = fileExtension;
        this.modifyWindowsReservedFilenames = ClassFileNameHandler.testForWindowsReservedFileNames(path);
    }

    public File getUniqueFilenameForClass(String className) {
        if (className.charAt(0) != 'L' || className.charAt(className.length() - 1) != ';') {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        int packageElementCount = 1;
        for (int i2 = 1; i2 < className.length() - 1; ++i2) {
            if (className.charAt(i2) != '/') continue;
            ++packageElementCount;
        }
        String[] packageElements = new String[packageElementCount];
        int elementIndex = 0;
        int elementStart = 1;
        for (int i3 = 1; i3 < className.length() - 1; ++i3) {
            if (className.charAt(i3) != '/') continue;
            if (i3 - elementStart == 0) {
                throw new RuntimeException("Not a valid dalvik class name");
            }
            packageElements[elementIndex++] = className.substring(elementStart, i3);
            elementStart = ++i3;
        }
        if (elementStart >= className.length() - 1) {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        packageElements[elementIndex] = className.substring(elementStart, className.length() - 1);
        return this.top.addUniqueChild(packageElements, 0);
    }

    private static boolean testForWindowsReservedFileNames(File path) {
        File f2 = new File(path, "aux.smali");
        if (f2.exists()) {
            return false;
        }
        try {
            FileWriter writer = new FileWriter(f2);
            writer.write("test");
            writer.flush();
            writer.close();
            f2.delete();
            return false;
        }
        catch (IOException ex) {
            f2 = new File(path, "con.smali");
            if (f2.exists()) {
                return false;
            }
            try {
                FileWriter writer = new FileWriter(f2);
                writer.write("test");
                writer.flush();
                writer.close();
                f2.delete();
                return false;
            }
            catch (IOException ex2) {
                return true;
            }
        }
    }

    private static boolean isReservedFileName(String className) {
        return reservedFileNameRegex.matcher(className).matches();
    }

    private class ClassNameEntry
    extends FileSystemEntry {
        public ClassNameEntry(File parent, String name) {
            super(new File(parent, name));
        }

        public File addUniqueChild(String[] pathElements, int pathElementsIndex) {
            assert (false);
            return this.file;
        }
    }

    private class VirtualGroupEntry
    extends FileSystemEntry {
        private RadixTree<FileSystemEntry> groupEntries;
        private int isCaseSensitive;

        public VirtualGroupEntry(FileSystemEntry firstChild, File parent) {
            super(parent);
            this.groupEntries = new RadixTreeImpl<FileSystemEntry>();
            this.isCaseSensitive = -1;
            this.groupEntries.insert(firstChild.file.getName(), firstChild);
        }

        public File addUniqueChild(String[] pathElements, int pathElementsIndex) {
            FileSystemEntry existingEntry;
            String elementName = pathElements[pathElementsIndex];
            if (pathElementsIndex == pathElements.length - 1) {
                elementName = elementName + ClassFileNameHandler.this.fileExtension;
            }
            if ((existingEntry = this.groupEntries.find(elementName)) != null) {
                if (pathElementsIndex == pathElements.length - 1) {
                    return existingEntry.file;
                }
                return existingEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
            }
            if (pathElementsIndex == pathElements.length - 1) {
                String fileName = !this.isCaseSensitive() ? pathElements[pathElementsIndex] + "." + (this.groupEntries.getSize() + 1L) + ClassFileNameHandler.this.fileExtension : elementName;
                ClassNameEntry classNameEntry = new ClassNameEntry(this.file, fileName);
                this.groupEntries.insert(elementName, classNameEntry);
                return classNameEntry.file;
            }
            String fileName = !this.isCaseSensitive() ? pathElements[pathElementsIndex] + "." + (this.groupEntries.getSize() + 1L) : elementName;
            PackageNameEntry packageNameEntry = new PackageNameEntry(this.file, fileName);
            this.groupEntries.insert(elementName, packageNameEntry);
            return packageNameEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
        }

        private boolean isCaseSensitive() {
            if (this.isCaseSensitive != -1) {
                return this.isCaseSensitive == 1;
            }
            File path = this.file;
            if (path.exists() && path.isFile()) {
                path = path.getParentFile();
            }
            if (!this.file.exists() && !this.file.mkdirs()) {
                return false;
            }
            try {
                boolean result = this.testCaseSensitivity(path);
                this.isCaseSensitive = result ? 1 : 0;
                return result;
            }
            catch (IOException ex) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean testCaseSensitivity(File path) throws IOException {
            File f2;
            File f3;
            int num = 1;
            do {
                f3 = new File(path, "test." + num);
                f2 = new File(path, "TEST." + num++);
            } while (f3.exists() || f2.exists());
            try {
                try {
                    FileWriter writer = new FileWriter(f3);
                    writer.write("test");
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    try {
                        f3.delete();
                        throw ex;
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    throw ex;
                }
                if (f2.exists()) {
                    boolean ex = false;
                    return ex;
                }
                if (f2.createNewFile()) {
                    boolean ex = true;
                    return ex;
                }
                CharBuffer buf = CharBuffer.allocate(32);
                FileReader reader = new FileReader(f2);
                while (reader.read(buf) != -1 && buf.length() < 4) {
                }
                if (buf.length() == 4 && buf.toString().equals("test")) {
                    boolean bl2 = false;
                    return bl2;
                }
                assert (false);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    f3.delete();
                }
                catch (Exception ex) {}
                try {
                    f2.delete();
                }
                catch (Exception ex) {}
            }
        }

        public FileSystemEntry makeVirtual(File parent) {
            return this;
        }
    }

    private class PackageNameEntry
    extends FileSystemEntry {
        private RadixTree<FileSystemEntry> children;

        public PackageNameEntry(File parent, String name) {
            super(new File(parent, name));
            this.children = new RadixTreeImpl<FileSystemEntry>();
        }

        public PackageNameEntry(File path) {
            super(path);
            this.children = new RadixTreeImpl<FileSystemEntry>();
        }

        public File addUniqueChild(String[] pathElements, int pathElementsIndex) {
            String elementName;
            if (pathElementsIndex == pathElements.length - 1) {
                elementName = pathElements[pathElementsIndex];
                if (ClassFileNameHandler.this.modifyWindowsReservedFilenames && ClassFileNameHandler.isReservedFileName(elementName)) {
                    elementName = elementName + "#";
                }
                elementName = elementName + ClassFileNameHandler.this.fileExtension;
            } else {
                elementName = pathElements[pathElementsIndex];
                if (ClassFileNameHandler.this.modifyWindowsReservedFilenames && ClassFileNameHandler.isReservedFileName(elementName)) {
                    elementName = elementName + "#";
                }
            }
            String elementNameLower = elementName.toLowerCase();
            FileSystemEntry existingEntry = this.children.find(elementNameLower);
            if (existingEntry != null) {
                FileSystemEntry virtualEntry = existingEntry;
                if (!(existingEntry instanceof VirtualGroupEntry)) {
                    if (existingEntry.file.getName().equals(elementName)) {
                        if (pathElementsIndex == pathElements.length - 1) {
                            return existingEntry.file;
                        }
                        return existingEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
                    }
                    virtualEntry = existingEntry.makeVirtual(this.file);
                    this.children.replace(elementNameLower, virtualEntry);
                }
                return virtualEntry.addUniqueChild(pathElements, pathElementsIndex);
            }
            if (pathElementsIndex == pathElements.length - 1) {
                ClassNameEntry classNameEntry = new ClassNameEntry(this.file, elementName);
                this.children.insert(elementNameLower, classNameEntry);
                return classNameEntry.file;
            }
            PackageNameEntry packageNameEntry = new PackageNameEntry(this.file, elementName);
            this.children.insert(elementNameLower, packageNameEntry);
            return packageNameEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
        }
    }

    private abstract class FileSystemEntry {
        public final File file;

        public FileSystemEntry(File file) {
            this.file = file;
        }

        public abstract File addUniqueChild(String[] var1, int var2);

        public FileSystemEntry makeVirtual(File parent) {
            return new VirtualGroupEntry(this, parent);
        }
    }
}

