/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        this.mKeys = new int[initialCapacity];
        this.mValues = new Object[initialCapacity];
        this.mSize = 0;
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E valueIfKeyNotFound) {
        int i2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i2 < 0 || this.mValues[i2] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i2];
    }

    public void delete(int key) {
        int i2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i2 >= 0 && this.mValues[i2] != DELETED) {
            this.mValues[i2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int key) {
        this.delete(key);
    }

    private void gc() {
        int n2 = this.mSize;
        int o2 = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object val = values[i2];
            if (val == DELETED) continue;
            if (i2 != o2) {
                keys[o2] = keys[i2];
                values[o2] = val;
            }
            ++o2;
        }
        this.mGarbage = false;
        this.mSize = o2;
    }

    public void put(int key, E value) {
        int i2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i2 >= 0) {
            this.mValues[i2] = value;
        } else {
            if ((i2 ^= 0xFFFFFFFF) < this.mSize && this.mValues[i2] == DELETED) {
                this.mKeys[i2] = key;
                this.mValues[i2] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i2 = ~SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n2 = Math.max(this.mSize + 1, this.mKeys.length * 2);
                int[] nkeys = new int[n2];
                Object[] nvalues = new Object[n2];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i2 != 0) {
                System.arraycopy(this.mKeys, i2, this.mKeys, i2 + 1, this.mSize - i2);
                System.arraycopy(this.mValues, i2, this.mValues, i2 + 1, this.mSize - i2);
            }
            this.mKeys[i2] = key;
            this.mValues[i2] = value;
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (this.mValues[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        int n2 = this.mSize;
        Object[] values = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            values[i2] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n2 = Math.max(pos + 1, this.mKeys.length * 2);
            int[] nkeys = new int[n2];
            Object[] nvalues = new Object[n2];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public void ensureCapacity(int capacity) {
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if (this.mKeys.length < capacity) {
            int[] nkeys = new int[capacity];
            Object[] nvalues = new Object[capacity];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
    }

    private static int binarySearch(int[] a, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a[high] == key) {
            return high;
        }
        return ~high;
    }

    public List<E> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.mValues));
    }
}

