/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] readFile(String fileName) throws IOException {
        File file = new File(fileName);
        return FileUtils.readFile(file);
    }

    public static byte[] readFile(File file) throws IOException {
        return FileUtils.readFile(file, 0, -1);
    }

    public static byte[] readFile(File file, int offset, int length) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException(file + ": file not found");
        }
        if (!file.isFile()) {
            throw new RuntimeException(file + ": not a file");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file + ": file not readable");
        }
        long longLength = file.length();
        int fileLength = (int)longLength;
        if ((long)fileLength != longLength) {
            throw new RuntimeException(file + ": file too long");
        }
        if (length == -1) {
            length = fileLength - offset;
        }
        if (offset + length > fileLength) {
            throw new RuntimeException(file + ": file too short");
        }
        FileInputStream in = new FileInputStream(file);
        int at2 = offset;
        while (at2 > 0) {
            long amt = in.skip(at2);
            if (amt == -1L) {
                throw new RuntimeException(file + ": unexpected EOF");
            }
            at2 = (int)((long)at2 - amt);
        }
        byte[] result = FileUtils.readStream(in, length);
        in.close();
        return result;
    }

    public static byte[] readStream(InputStream in, int length) throws IOException {
        byte[] result = new byte[length];
        int at2 = 0;
        while (length > 0) {
            int amt = in.read(result, at2, length);
            if (amt == -1) {
                throw new RuntimeException("unexpected EOF");
            }
            at2 += amt;
            length -= amt;
        }
        return result;
    }
}

